/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.cheatsheet.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.actions.RunOnServerAction;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.project.examples.cheatsheet.Activator;

public class RunOnServer
extends Action
implements ICheatSheetAction {
    public void run(String[] params, ICheatSheetManager manager) {
        IFile file;
        if (params == null || params[0] == null) {
            return;
        }
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wRoot.getProject(params[0]);
        if (project == null || !project.isOpen()) {
            return;
        }
        if (params[1] != null && (file = wRoot.getFile((IPath)new Path(params[1]))) != null && file.exists()) {
            try {
                SingleDeployableFactory.makeDeployable((IPath)file.getFullPath());
                IServer[] deployableServersAsIServers = ServerConverter.getDeployableServersAsIServers();
                if (deployableServersAsIServers.length == 1) {
                    IServer server = deployableServersAsIServers[0];
                    IServerWorkingCopy copy = server.createWorkingCopy();
                    IModule[] modules = new IModule[]{SingleDeployableFactory.findModule((IPath)file.getFullPath())};
                    copy.modifyModules(modules, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
                    IServer saved = copy.save(false, (IProgressMonitor)new NullProgressMonitor());
                    saved.publish(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = new Status(1, "org.jboss.tools.project.examples.cheatsheet", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        RunOnServerAction action = new RunOnServerAction((Object)project);
        action.run();
    }
}

