/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectExamplesActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.project.examples";
    public static final String ALL_SITES = Messages.ProjectExamplesActivator_All;
    public static final String SHOW_EXPERIMENTAL_SITES = "showExperimentalSites";
    public static final String USER_SITES = "userSites";
    public static final boolean SHOW_EXPERIMENTAL_SITES_VALUE = false;
    private static ProjectExamplesActivator plugin;
    private static BundleContext context;
    public static Job waitForBuildAndValidation;

    static {
        waitForBuildAndValidation = new Job(Messages.ProjectExamplesActivator_Waiting){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                    Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProjectExamplesActivator.context = context;
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        context = null;
    }

    public static ProjectExamplesActivator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        ProjectExamplesActivator.getDefault().getLog().log((IStatus)status);
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public static List<IMarker> getMarkers(List<Project> projects) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        for (Project project : projects) {
            try {
                if (project.getIncludedProjects() == null) {
                    String projectName = project.getName();
                    ProjectExamplesActivator.getMarkers(markers, projectName);
                    continue;
                }
                List<String> includedProjects = project.getIncludedProjects();
                for (String projectName : includedProjects) {
                    ProjectExamplesActivator.getMarkers(markers, projectName);
                }
            }
            catch (CoreException e) {
                ProjectExamplesActivator.log(e);
            }
        }
        return markers;
    }

    private static List<IMarker> getMarkers(List<IMarker> markers, String projectName) throws CoreException {
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IMarker[] projectMarkers = eclipseProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        int i = 0;
        while (i < projectMarkers.length) {
            if (projectMarkers[i].getAttribute("severity", 2) == 2) {
                markers.add(projectMarkers[i]);
            }
            ++i;
        }
        return markers;
    }

    public static IProject[] getEclipseProject(Project project, ProjectFix fix) {
        String pName = fix.getProperties().get("eclipse-projects");
        if (pName == null) {
            List<String> projectNames = project.getIncludedProjects();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (String projectName : projectNames) {
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (eclipseProject == null || !eclipseProject.isOpen()) continue;
                projects.add(eclipseProject);
            }
            return projects.toArray(new IProject[0]);
        }
        StringTokenizer tokenizer = new StringTokenizer(pName, ",");
        ArrayList<IProject> projects = new ArrayList<IProject>();
        while (tokenizer.hasMoreTokens()) {
            IProject eclipseProject;
            String projectName = tokenizer.nextToken().trim();
            if (projectName == null || projectName.length() <= 0 || (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null || !eclipseProject.isOpen()) continue;
            projects.add(eclipseProject);
        }
        return projects.toArray(new IProject[0]);
    }
}

