/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.dialog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizardPage;

public class FixDialog
extends Dialog {
    private static final int FIX_BUTTON = 1;
    private TableViewer tableViewer;
    private List<ProjectFix> fixes;
    private Button fixButton;
    private ProjectFix fix;
    private NewProjectExamplesWizardPage page;

    public FixDialog(Shell parentShell, NewProjectExamplesWizardPage page) {
        super(parentShell);
        this.setShellStyle(0xC70 | FixDialog.getDefaultOrientation());
        this.page = page;
        this.refresh();
    }

    private void refresh() {
        IStructuredSelection selection = this.page.getSelection();
        Iterator iterator = selection.iterator();
        this.fixes = new ArrayList<ProjectFix>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Project)) continue;
            Project project = (Project)object;
            this.fixes.addAll(project.getUnsatisfiedFixes());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout());
        this.getShell().setText(Messages.FixDialog_Requirement_details);
        FixDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Label fixesLabel = new Label(contents, 0);
        fixesLabel.setText(Messages.FixDialog_Requirements);
        this.tableViewer = new TableViewer(contents, 2820);
        Table table = this.tableViewer.getTable();
        gd = new GridData(1808);
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.FixDialog_Type, Messages.FixDialog_Short_description};
        int[] columnWidths = new int[]{200, 350};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tc = new TableColumn(table, 16384);
            tc.setText(columnNames[i]);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FixLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new FixContentProvider(this.fixes));
        this.tableViewer.setInput(this.fixes);
        Label descriptionLabel = new Label(contents, 0);
        descriptionLabel.setText(Messages.FixDialog_Description);
        final Text description = new Text(contents, 2122);
        gd = new GridData(1808);
        gd.heightHint = 50;
        description.setLayoutData((Object)gd);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object;
                description.setText("");
                ISelection selection = event.getSelection();
                FixDialog.this.fix = null;
                FixDialog.this.fixButton.setEnabled(false);
                if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof ProjectFix) {
                    FixDialog.this.fix = (ProjectFix)object;
                    FixDialog.this.fixButton.setEnabled(FixDialog.this.fix.isFixable());
                    description.setText(FixDialog.this.fix.getProperties().get("description"));
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fixButton = this.createButton(parent, 1, Messages.FixDialog_Fix, true);
        if (this.fix == null) {
            this.fixButton.setEnabled(false);
        } else {
            this.fixButton.setEnabled(this.fix.isFixable());
        }
        this.fixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FixDialog.this.fix != null) {
                    FixDialog.this.fix.fix();
                    FixDialog.this.page.refresh(true);
                    FixDialog.this.refresh();
                    FixDialog.this.tableViewer.setInput((Object)FixDialog.this.fixes);
                }
            }
        });
        this.createButton(parent, 0, Messages.FixDialog_Finish, true);
    }

    protected void buttonPressed(int buttonId) {
        if (1 != buttonId) {
            super.buttonPressed(buttonId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FixContentProvider
    implements IStructuredContentProvider {
        private List<ProjectFix> fixes;

        public FixContentProvider(List<ProjectFix> fixes) {
            this.fixes = fixes;
        }

        public Object[] getElements(Object inputElement) {
            return this.fixes.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fixes = (List)newInput;
        }
    }

    private class FixLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FixLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ProjectFix) {
                ProjectFix fix = (ProjectFix)element;
                if (columnIndex == 0) {
                    return fix.getType();
                }
                if (columnIndex == 1) {
                    return fix.getShortDescription();
                }
            }
            return null;
        }
    }
}

