/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.fixes;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.fixes.ProjectExamplesFix;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectFix;

public class WTPRuntimeFix
implements ProjectExamplesFix {
    public boolean canFix(Project project, ProjectFix fix) {
        if (!"wtpruntime".equals(fix.getType())) {
            return false;
        }
        return this.getBestRuntime(project, fix) != null;
    }

    public boolean fix(Project project, ProjectFix fix, IProgressMonitor monitor) {
        if (!this.canFix(project, fix)) {
            return false;
        }
        IProject[] eclipseProjects = ProjectExamplesActivator.getEclipseProject(project, fix);
        if (eclipseProjects.length == 0) {
            return false;
        }
        boolean ret = true;
        int i = 0;
        while (i < eclipseProjects.length) {
            IProject eclipseProject = eclipseProjects[i];
            try {
                org.eclipse.wst.server.core.IRuntime runtime;
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)eclipseProject);
                IRuntime wtpRuntime = facetedProject.getPrimaryRuntime();
                if (wtpRuntime != null && (runtime = WTPRuntimeFix.getRuntime(wtpRuntime)) == null && (runtime = this.getBestRuntime(project, fix)) != null) {
                    facetedProject.removeTargetedRuntime(wtpRuntime, monitor);
                    wtpRuntime = RuntimeManager.getRuntime((String)runtime.getId());
                    facetedProject.addTargetedRuntime(wtpRuntime, monitor);
                    facetedProject.setPrimaryRuntime(wtpRuntime, monitor);
                }
            }
            catch (CoreException e) {
                ProjectExamplesActivator.log(e);
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    private org.eclipse.wst.server.core.IRuntime getBestRuntime(Project project, ProjectFix fix) {
        String allowedTypes = fix.getProperties().get("allowed-types");
        if (allowedTypes == null) {
            ProjectExamplesActivator.log(NLS.bind((String)Messages.WTPRuntimeFix_Invalid_WTP_runtime_fix, (Object)project.getName()));
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(allowedTypes, ",");
        while (tokenizer.hasMoreTokens()) {
            String allowedType = tokenizer.nextToken().trim();
            if (allowedType.length() <= 0) continue;
            org.eclipse.wst.server.core.IRuntime[] runtimes = ServerCore.getRuntimes();
            if (runtimes.length > 0 && "any".equals(allowedType)) {
                return runtimes[0];
            }
            int i = 0;
            while (i < runtimes.length) {
                org.eclipse.wst.server.core.IRuntime runtime = runtimes[i];
                IRuntimeType runtimeType = runtime.getRuntimeType();
                if (runtimeType.getId().equals(allowedType)) {
                    return runtime;
                }
                ++i;
            }
        }
        return null;
    }

    private static org.eclipse.wst.server.core.IRuntime getRuntime(IRuntime runtime) {
        org.eclipse.wst.server.core.IRuntime[] runtimes;
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        org.eclipse.wst.server.core.IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.wst.server.core.IRuntime r = iRuntimeArray[n2];
            if (id.equals(r.getId())) {
                return r;
            }
            ++n2;
        }
        return null;
    }
}

