/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFix {
    public static final String WTP_RUNTIME = "wtpruntime";
    public static final String SEAM_RUNTIME = "seam";
    public static final String DROOLS_RUNTIME = "drools";
    public static final String PLUGIN_TYPE = "plugin";
    public static final String ALLOWED_VERSIONS = "allowed-versions";
    public static final String ECLIPSE_PROJECTS = "eclipse-projects";
    public static final String ALLOWED_TYPES = "allowed-types";
    public static final String ID = "id";
    public static final String VERSION = "VERSION";
    public static final String DESCRIPTION = "description";
    public static final String ANY = "any";
    public static final String SEAM_PREFERENCES_ID = "org.jboss.tools.common.model.ui.seam";
    public static final String WTP_PREFERENCES_ID = "org.eclipse.wst.server.ui.runtime.preferencePage";
    private String type;
    private Map<String, String> properties = new HashMap<String, String>();
    private static Map<String, String> shortDescriptions = new HashMap<String, String>();
    private static Map<String, Boolean> fixableMaps = new HashMap<String, Boolean>();

    static {
        shortDescriptions.put(WTP_RUNTIME, Messages.ProjectFix_Missing_WTP_Runtime);
        shortDescriptions.put(SEAM_RUNTIME, Messages.ProjectFix_Missing_Seam_Runtime);
        shortDescriptions.put(PLUGIN_TYPE, Messages.ProjectFix_Missing_plugin);
        shortDescriptions.put(DROOLS_RUNTIME, Messages.ProjectFix_Missing_Drools_Runtime);
        fixableMaps.put(WTP_RUNTIME, true);
        fixableMaps.put(SEAM_RUNTIME, true);
        fixableMaps.put(PLUGIN_TYPE, true);
        fixableMaps.put(DROOLS_RUNTIME, true);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getShortDescription() {
        if (this.type == null) {
            return "";
        }
        String shortDescription = shortDescriptions.get(this.type);
        if (shortDescription == null) {
            return "";
        }
        return shortDescription;
    }

    public boolean isFixable() {
        if (this.type == null) {
            return false;
        }
        Boolean fixable = fixableMaps.get(this.type);
        if (fixable == null) {
            return false;
        }
        return fixable;
    }

    public void fix() {
        PreferenceDialog dialog;
        Shell shell;
        if (SEAM_RUNTIME.equals(this.type)) {
            shell = this.getShell();
            dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)SEAM_PREFERENCES_ID, (String[])new String[]{SEAM_PREFERENCES_ID}, null);
            if (dialog != null) {
                dialog.open();
            }
        }
        if (WTP_RUNTIME.equals(this.type)) {
            shell = this.getShell();
            dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)WTP_PREFERENCES_ID, (String[])new String[]{SEAM_PREFERENCES_ID}, null);
            if (dialog != null) {
                dialog.open();
            }
        }
        if (PLUGIN_TYPE.equals(this.type)) {
            try {
                String profileId = ProvSDKUIActivator.getSelfProfileId();
                QueryableMetadataRepositoryManager manager = new QueryableMetadataRepositoryManager(Policy.getDefault().getQueryContext(), false);
                InstallWizard wizard = new InstallWizard(Policy.getDefault(), profileId, null, null, manager);
                ProvisioningWizardDialog dialog2 = new ProvisioningWizardDialog(this.getShell(), (ProvisioningOperationWizard)wizard);
                dialog2.create();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog2.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
                dialog2.open();
            }
            catch (ProvisionException e) {
                e.printStackTrace();
                ProjectExamplesActivator.log(e);
            }
        }
    }

    private Shell getShell() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return shell;
    }
}

