/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.preferences;

import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.model.ProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectUtil;
import org.jboss.tools.project.examples.model.SiteCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sites {
    private SiteCategory[] siteCategories;
    private SiteCategory userSite;
    private Set<ProjectExampleSite> sites;

    public SiteCategory[] getSiteCategories() {
        if (this.siteCategories == null) {
            this.siteCategories = new SiteCategory[2];
            this.userSite = new SiteCategory(Messages.Sites_User_sites);
            Set<ProjectExampleSite> userSites = ProjectUtil.getUserSites();
            this.userSite.setSites(userSites);
            this.siteCategories[0] = this.userSite;
            SiteCategory pluginSite = new SiteCategory(Messages.Sites_Plugin_provided_sites);
            Set<ProjectExampleSite> pluginSites = ProjectUtil.getPluginSites();
            pluginSite.setSites(pluginSites);
            this.siteCategories[1] = pluginSite;
            this.sites = new HashSet<ProjectExampleSite>();
            this.sites.addAll(pluginSites);
            this.sites.addAll(userSites);
        }
        return this.siteCategories;
    }

    public void remove(ProjectExampleSite site) {
        this.userSite.getSites().remove(site);
        this.sites.remove(site);
    }

    public void add(ProjectExampleSite site) {
        this.userSite.getSites().add(site);
        this.sites.add(site);
    }

    public Set<ProjectExampleSite> getSites() {
        return this.sites;
    }

    public Set<ProjectExampleSite> getUserSites() {
        return this.userSite.getSites();
    }
}

