/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.cheatsheets.state.DefaultStateManager;
import org.eclipse.ui.internal.cheatsheets.state.ICheatSheetStateManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.dialog.MarkerDialog;
import org.jboss.tools.project.examples.fixes.SeamRuntimeFix;
import org.jboss.tools.project.examples.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.model.ProjectUtil;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectExamplesWizard
extends Wizard
implements INewWizard {
    private static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };
    private List<Project> projects = new ArrayList<Project>();
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewProjectExamplesWizardPage page;
    private static Shell shell;
    protected static boolean overwrite;
    private WorkspaceJob workspaceJob;

    public NewProjectExamplesWizard() {
        this.setWindowTitle(Messages.NewProjectExamplesWizard_New_Project_Example);
    }

    public boolean performFinish() {
        if (this.page.getSelection() == null || this.page.getSelection().size() <= 0) {
            return false;
        }
        this.workspaceJob = new WorkspaceJob(Messages.NewProjectExamplesWizard_Downloading){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IStructuredSelection selection = NewProjectExamplesWizard.this.page.getSelection();
                Iterator iterator = selection.iterator();
                NewProjectExamplesWizard.this.projects.clear();
                ArrayList<File> files = new ArrayList<File>();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof Project)) continue;
                    Project project = (Project)object;
                    String urlString = project.getUrl();
                    String name = project.getName();
                    URL url = null;
                    try {
                        url = new URL(urlString);
                    }
                    catch (MalformedURLException e) {
                        ProjectExamplesActivator.log(e);
                        continue;
                    }
                    File file = ProjectUtil.getProjectExamplesFile(url, name, ".zip", monitor);
                    if (file == null) {
                        return Status.CANCEL_STATUS;
                    }
                    NewProjectExamplesWizard.this.projects.add(project);
                    files.add(file);
                }
                try {
                    int i = 0;
                    this.setName(Messages.NewProjectExamplesWizard_Importing);
                    for (Project project : NewProjectExamplesWizard.this.projects) {
                        NewProjectExamplesWizard.importProject(project, (File)files.get(i++), monitor);
                        NewProjectExamplesWizard.fix(project, monitor);
                    }
                }
                catch (Exception e) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialogWithToggle.openError((Shell)NewProjectExamplesWizard.this.getShell(), (String)Messages.NewProjectExamplesWizard_Error, (String)e.getMessage(), (String)Messages.NewProjectExamplesWizard_Detail, (boolean)false, (IPreferenceStore)ProjectExamplesActivator.getDefault().getPreferenceStore(), (String)"errorDialog");
                        }
                    });
                    ProjectExamplesActivator.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        this.workspaceJob.setUser(true);
        final boolean showQuickFix = this.page.showQuickFix();
        if (showQuickFix) {
            this.workspaceJob.addJobChangeListener(new IJobChangeListener(){

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    try {
                        ProjectExamplesActivator.waitForBuildAndValidation.schedule();
                        ProjectExamplesActivator.waitForBuildAndValidation.join();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (showQuickFix) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        List<IMarker> markers = ProjectExamplesActivator.getMarkers(NewProjectExamplesWizard.this.projects);
                        if (markers != null && markers.size() > 0) {
                            NewProjectExamplesWizard.showQuickFix(NewProjectExamplesWizard.this.projects);
                        }
                    }
                    NewProjectExamplesWizard.this.openWelcome();
                }

                public void running(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }
            });
        } else {
            this.openWelcome();
        }
        this.workspaceJob.schedule();
        return true;
    }

    private void openWelcome() {
        for (final Project project : this.projects) {
            if (!project.isWelcome()) continue;
            String urlString = project.getWelcomeURL();
            URL url = null;
            if (urlString.startsWith("/")) {
                Path path = new Path(urlString);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (resource instanceof IFile && resource.isAccessible()) {
                    try {
                        url = resource.getRawLocationURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        ProjectExamplesActivator.log(e);
                    }
                } else {
                    ProjectExamplesActivator.log(NLS.bind((String)Messages.NewProjectExamplesWizard_File_does_not_exist, (Object)urlString));
                }
            } else {
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    ProjectExamplesActivator.log(e);
                }
            }
            if (url == null) continue;
            final URL finalURL = url;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if ("cheatsheets".equals(project.getType())) {
                        CheatSheetView view = ViewUtilities.showCheatSheetView();
                        if (view == null) {
                            return;
                        }
                        Path filePath = new Path(finalURL.getPath());
                        String id = filePath.lastSegment();
                        if (id == null) {
                            id = "";
                        }
                        view.getCheatSheetViewer().setInput(id, id, finalURL, (ICheatSheetStateManager)new DefaultStateManager(), false);
                    } else {
                        try {
                            IWorkbenchBrowserSupport browserSupport = ProjectExamplesActivator.getDefault().getWorkbench().getBrowserSupport();
                            IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                            browser.openURL(finalURL);
                        }
                        catch (PartInitException e) {
                            ProjectExamplesActivator.log(e);
                        }
                    }
                }
            });
        }
    }

    public static void showQuickFix(final List<Project> projects) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MarkerDialog dialog = new MarkerDialog(shell, projects);
                dialog.open();
            }
        });
    }

    public static void fix(Project project, IProgressMonitor monitor) {
        List<ProjectFix> fixes = project.getFixes();
        for (ProjectFix fix : fixes) {
            if ("wtpruntime".equals(fix.getType())) {
                new WTPRuntimeFix().fix(project, fix, monitor);
            }
            if (!"seam".equals(fix.getType())) continue;
            new SeamRuntimeFix().fix(project, fix, monitor);
        }
    }

    public static void importProject(Project projectDescription, File file, IProgressMonitor monitor) throws Exception {
        if (projectDescription.getIncludedProjects() == null) {
            NewProjectExamplesWizard.importSingleProject(projectDescription, file, monitor);
        } else {
            List<String> projects = projectDescription.getIncludedProjects();
            for (final String projectName : projects) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                if (project.exists()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            overwrite = MessageDialog.openQuestion((Shell)NewProjectExamplesWizard.getActiveShell(), (String)Messages.NewProjectExamplesWizard_Question, (String)NLS.bind((String)Messages.NewProjectExamplesWizard_OverwriteProject, (Object)projectName));
                        }
                    });
                    if (!overwrite) {
                        return;
                    }
                    project.delete(true, true, monitor);
                }
                project.create(monitor);
                project.open(monitor);
                ZipFile sourceFile = new ZipFile(file);
                ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(sourceFile);
                Enumeration<? extends ZipEntry> entries = sourceFile.entries();
                ZipEntry entry = null;
                ArrayList<ZipEntry> filesToImport = new ArrayList<ZipEntry>();
                String prefix = String.valueOf(projectName) + "/";
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    if (!entry.getName().startsWith(prefix)) continue;
                    filesToImport.add(entry);
                }
                ImportOperation operation = new ImportOperation(workspace.getRoot().getFullPath(), (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY, filesToImport);
                operation.setContext(NewProjectExamplesWizard.getActiveShell());
                operation.run(monitor);
                NewProjectExamplesWizard.reconfigure(project, monitor);
            }
        }
    }

    private static Shell getActiveShell() {
        Display display = Display.getDefault();
        shell = null;
        display.syncExec(new Runnable(){

            public void run() {
                NewProjectExamplesWizard.shell = Display.getCurrent().getActiveShell();
            }
        });
        return shell;
    }

    private static void importSingleProject(Project projectDescription, File file, IProgressMonitor monitor) throws CoreException, ZipException, IOException, InvocationTargetException, InterruptedException {
        final String projectName = projectDescription.getName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        if (project.exists()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    overwrite = MessageDialog.openQuestion((Shell)NewProjectExamplesWizard.getActiveShell(), (String)Messages.NewProjectExamplesWizard_Question, (String)NLS.bind((String)Messages.NewProjectExamplesWizard_OverwriteProject, (Object)projectName));
                }
            });
            if (!overwrite) {
                return;
            }
            project.delete(true, true, monitor);
        }
        project.create(monitor);
        project.open(monitor);
        ZipFile sourceFile = new ZipFile(file);
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(sourceFile);
        ImportOperation operation = new ImportOperation(workspace.getRoot().getFullPath(), (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY);
        operation.setContext(NewProjectExamplesWizard.getActiveShell());
        operation.run(monitor);
        NewProjectExamplesWizard.reconfigure(project, monitor);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.initializeDefaultPageImageDescriptor();
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = ProjectExamplesActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.project.examples", (String)"icons/new_wiz.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void addPages() {
        super.addPages();
        this.page = new NewProjectExamplesWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    private static List prepareFileList(IImportStructureProvider structure, ZipEntry entry, List list) {
        List son;
        if (structure == null || entry == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<ZipEntry>();
        }
        if ((son = structure.getChildren((Object)entry)) == null) {
            return list;
        }
        for (ZipEntry temp : son) {
            if (temp.isDirectory()) {
                NewProjectExamplesWizard.prepareFileList(structure, temp, list);
                continue;
            }
            list.add(temp);
        }
        return list;
    }

    private static void reconfigure(IProject project, IProgressMonitor monitor) throws CoreException {
        Object object;
        if (!(project != null && project.exists() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature"))) {
            return;
        }
        project.refreshLocal(2, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists() && javaProject.isOpen() && javaProject instanceof JavaProject && (object = ((JavaProject)javaProject).getElementInfo()) instanceof OpenableElementInfo) {
            OpenableElementInfo info = (OpenableElementInfo)object;
            IClasspathEntry[] resolvedClasspath = ((JavaProject)javaProject).getResolvedClasspath();
            IPackageFragmentRoot[] children = ((JavaProject)javaProject).computePackageFragmentRoots(resolvedClasspath, false, null);
            info.setChildren((IJavaElement[])children);
            ((JavaProject)javaProject).getPerProjectInfo().rememberExternalLibTimestamps();
        }
    }
}

