/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.dialog.FixDialog;
import org.jboss.tools.project.examples.fixes.PluginFix;
import org.jboss.tools.project.examples.fixes.SeamRuntimeFix;
import org.jboss.tools.project.examples.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.model.Category;
import org.jboss.tools.project.examples.model.Project;
import org.jboss.tools.project.examples.model.ProjectFix;
import org.jboss.tools.project.examples.model.ProjectUtil;
import org.jboss.tools.project.examples.wizard.ProjectExamplesPatternFilter;
import org.jboss.tools.project.examples.wizard.SiteFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectExamplesWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private Button showQuickFixButton;
    private Combo siteCombo;
    private Text noteText;
    private Button details;
    private PageBook notesPageBook;
    private Composite noteEmptyComposite;
    private Composite noteComposite;

    public NewProjectExamplesWizardPage() {
        super("org.jboss.tools.project.examples");
        this.setTitle(Messages.NewProjectExamplesWizardPage_Project_Example);
        this.setDescription(Messages.NewProjectExamplesWizardPage_Import_Project_Example);
        this.setImageDescriptor(ProjectExamplesActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.project.examples", (String)"icons/new_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Composite siteComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        siteComposite.setLayout((Layout)gridLayout);
        gd = new GridData(4, 1, true, false);
        siteComposite.setLayoutData((Object)gd);
        final Button button = new Button(siteComposite, 32);
        gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.setText(Messages.ProjectExamplesPreferencePage_Show_experimental_sites);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        button.setSelection(store.getBoolean("showExperimentalSites"));
        new Label(siteComposite, 0).setText(Messages.NewProjectExamplesWizardPage_Site);
        this.siteCombo = new Combo(siteComposite, 8);
        this.siteCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        String[] items = this.getItems();
        this.siteCombo.setItems(items);
        this.siteCombo.setText(ProjectExamplesActivator.ALL_SITES);
        new Label(composite, 0).setText(Messages.NewProjectExamplesWizardPage_Projects);
        ProjectExamplesPatternFilter filter = new ProjectExamplesPatternFilter();
        int styleBits = 2818;
        FilteredTree filteredTree = new FilteredTree(composite, styleBits, (PatternFilter)filter, true);
        filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        final TreeViewer viewer = filteredTree.getViewer();
        Tree tree = viewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(parent.getFont());
        viewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        viewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.refresh(viewer);
        final SiteFilter siteFilter = new SiteFilter();
        viewer.addFilter((ViewerFilter)siteFilter);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.NewProjectExamplesWizardPage_Description);
        final Text text = new Text(composite, 2122);
        gd = new GridData(1808);
        gd.heightHint = 75;
        text.setLayoutData((Object)gd);
        Composite internal = new Composite(composite, 0);
        internal.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1808);
        internal.setLayoutData((Object)gd);
        Label projectNameLabel = new Label(internal, 0);
        projectNameLabel.setText(Messages.NewProjectExamplesWizardPage_Project_name);
        final Text projectName = new Text(internal, 2056);
        projectName.setLayoutData((Object)new GridData(768));
        Label projectSizeLabel = new Label(internal, 0);
        projectSizeLabel.setText(Messages.NewProjectExamplesWizardPage_Project_size);
        final Text projectSize = new Text(internal, 2056);
        projectSize.setLayoutData((Object)new GridData(768));
        Label projectURLLabel = new Label(internal, 0);
        projectURLLabel.setText(Messages.NewProjectExamplesWizardPage_URL);
        final Text projectURL = new Text(internal, 2056);
        projectURL.setLayoutData((Object)new GridData(768));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewProjectExamplesWizardPage.this.selection = (IStructuredSelection)event.getSelection();
                Object selected = NewProjectExamplesWizardPage.this.selection.getFirstElement();
                if (selected instanceof Project && NewProjectExamplesWizardPage.this.selection.size() == 1) {
                    Project selectedProject = (Project)selected;
                    text.setText(selectedProject.getDescription());
                    projectName.setText(selectedProject.getName());
                    projectURL.setText(selectedProject.getUrl());
                    projectSize.setText(selectedProject.getSizeAsText());
                } else {
                    text.setText("");
                    projectName.setText("");
                    projectURL.setText("");
                    projectSize.setText("");
                }
                boolean canFinish = NewProjectExamplesWizardPage.this.refresh(false);
                NewProjectExamplesWizardPage.this.setPageComplete(canFinish);
            }
        });
        this.notesPageBook = new PageBook(internal, 0);
        this.notesPageBook.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.notesPageBook.setLayoutData((Object)gd);
        this.noteEmptyComposite = new Composite((Composite)this.notesPageBook, 0);
        this.noteEmptyComposite.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(1, 1, false, false);
        this.noteEmptyComposite.setLayoutData((Object)gd);
        this.noteComposite = new Composite((Composite)this.notesPageBook, 0);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1, 1, false, false);
        this.noteComposite.setLayoutData((Object)gd);
        this.noteComposite.setVisible(false);
        this.notesPageBook.showPage((Control)this.noteEmptyComposite);
        Composite messageComposite = new Composite(this.noteComposite, 2048);
        messageComposite.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1, 1, false, false);
        messageComposite.setLayoutData((Object)gd);
        Label noteLabel = new Label(messageComposite, 0);
        gd = new GridData(1, 1, false, false);
        noteLabel.setLayoutData((Object)gd);
        Image image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
        image.setBackground(noteLabel.getBackground());
        noteLabel.setImage(image);
        this.noteText = new Text(messageComposite, 74);
        this.noteText.setText("");
        gd = new GridData(1808);
        gd.heightHint = 50;
        gd.widthHint = 400;
        this.noteText.setLayoutData((Object)gd);
        this.noteText.setText(Messages.NewProjectExamplesWizardPage_Note);
        this.details = new Button(this.noteComposite, 8);
        this.details.setText(Messages.NewProjectExamplesWizardPage_Details);
        this.details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixDialog dialog = new FixDialog(NewProjectExamplesWizardPage.this.getShell(), NewProjectExamplesWizardPage.this);
                dialog.open();
            }
        });
        this.showQuickFixButton = new Button(internal, 32);
        this.showQuickFixButton.setText(Messages.NewProjectExamplesWizardPage_Show_the_Quick_Fix_dialog);
        this.showQuickFixButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.showQuickFixButton.setLayoutData((Object)gd);
        this.siteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                siteFilter.setSite(NewProjectExamplesWizardPage.this.siteCombo.getText());
                viewer.refresh();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
                store.setValue("showExperimentalSites", button.getSelection());
                NewProjectExamplesWizardPage.this.refresh(viewer);
                if (NewProjectExamplesWizardPage.this.siteCombo != null) {
                    String[] items = NewProjectExamplesWizardPage.this.getItems();
                    int index = NewProjectExamplesWizardPage.this.siteCombo.getSelectionIndex();
                    NewProjectExamplesWizardPage.this.siteCombo.setItems(items);
                    if (items.length > 0 && (index < 0 || index > items.length)) {
                        NewProjectExamplesWizardPage.this.siteCombo.select(0);
                    } else {
                        NewProjectExamplesWizardPage.this.siteCombo.select(index);
                    }
                }
                siteFilter.setSite(NewProjectExamplesWizardPage.this.siteCombo.getText());
                viewer.refresh();
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private boolean canFix(Project project, ProjectFix fix) {
        String type = fix.getType();
        if ("plugin".equals(type)) {
            return new PluginFix().canFix(project, fix);
        }
        if ("wtpruntime".equals(type)) {
            return new WTPRuntimeFix().canFix(project, fix);
        }
        if ("seam".equals(type)) {
            return new SeamRuntimeFix().canFix(project, fix);
        }
        ProjectExamplesActivator.log(NLS.bind((String)Messages.NewProjectExamplesWizardPage_Invalid_fix, (Object)project.getName()));
        return true;
    }

    private void refresh(TreeViewer viewer) {
        AdaptableList input = new AdaptableList(this.getCategories());
        viewer.setInput((Object)input);
        viewer.refresh();
    }

    private List<Category> getCategories() {
        return ProjectUtil.getProjects();
    }

    private String[] getItems() {
        List<Category> categories = this.getCategories();
        TreeSet<String> sites = new TreeSet<String>();
        sites.add(ProjectExamplesActivator.ALL_SITES);
        for (Category category : categories) {
            List<Project> projects = category.getProjects();
            for (Project project : projects) {
                sites.add(project.getSite());
            }
        }
        String[] items = sites.toArray(new String[0]);
        return items;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public boolean showQuickFix() {
        if (this.showQuickFixButton != null) {
            return this.showQuickFixButton.getSelection();
        }
        return false;
    }

    public boolean refresh(boolean force) {
        boolean canFinish = false;
        for (Object object : this.selection) {
            if (object instanceof Project) {
                canFinish = true;
                Project project = (Project)object;
                if (force || project.getUnsatisfiedFixes() == null) {
                    List<ProjectFix> fixes = project.getFixes();
                    ArrayList<ProjectFix> unsatisfiedFixes = new ArrayList<ProjectFix>();
                    project.setUnsatisfiedFixes(unsatisfiedFixes);
                    for (ProjectFix fix : fixes) {
                        if (this.canFix(project, fix)) continue;
                        unsatisfiedFixes.add(fix);
                    }
                }
                if (project.getUnsatisfiedFixes().size() > 0) {
                    this.notesPageBook.showPage((Control)this.noteComposite);
                    this.noteComposite.setVisible(true);
                    this.noteEmptyComposite.setVisible(false);
                    continue;
                }
                this.notesPageBook.showPage((Control)this.noteEmptyComposite);
                this.noteComposite.setVisible(false);
                this.noteEmptyComposite.setVisible(true);
                continue;
            }
            canFinish = false;
            break;
        }
        return canFinish;
    }

    private class ProjectContentProvider
    implements ITreeContentProvider {
        private ProjectContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AdaptableList) {
                Object[] childCollections = ((AdaptableList)parentElement).getChildren();
                return childCollections;
            }
            if (parentElement instanceof Category) {
                Category category = (Category)parentElement;
                return category.getProjects().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Project) {
                return ((Project)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Category;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Category) {
                Category category = (Category)element;
                return category.getName();
            }
            if (element instanceof Project) {
                Project project = (Project)element;
                return project.getShortDescription();
            }
            return super.getText(element);
        }
    }
}

