/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.common.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.jboss.tools.smooks.model.common.AbstractAnyType;
import org.jboss.tools.smooks.model.common.CommonPackage;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnyTypeImpl
extends AnyTypeImpl
implements AbstractAnyType,
Adapter {
    protected List<String> commentsList = new ArrayList<String>();
    protected Map<String, Integer> commentIndexMap = new HashMap<String, Integer>();
    protected boolean lock = true;
    protected List<Object> oldContents = null;

    @Override
    public boolean isLockCommentIndexChange() {
        return this.lock;
    }

    @Override
    public void setLockCOmmentIndexChange(boolean lock) {
        this.lock = lock;
    }

    public Notifier getTarget() {
        return this;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected void synchronizeOldObjects(Notification notification) {
        int eventType = notification.getEventType();
        Object feature = notification.getFeature();
        if (EAttribute.class.isInstance(feature)) {
            return;
        }
        switch (eventType) {
            case 3: 
            case 5: {
                this.oldContents.clear();
                this.oldContents.addAll((Collection<Object>)this.eContents());
                break;
            }
            case 1: {
                if (notification.getNewValue() == null) break;
                this.oldContents.clear();
                this.oldContents.addAll((Collection<Object>)this.eContents());
            }
        }
    }

    public void notifyChanged(Notification notification) {
        this.synchronizeOldObjects(notification);
        if (this.lock) {
            return;
        }
        int eventType = notification.getEventType();
        Object feature = notification.getFeature();
        if (EAttribute.class.isInstance(feature)) {
            return;
        }
        switch (eventType) {
            case 3: {
                Object addedValue = notification.getNewValue();
                this.changeCommentIndex(true, addedValue);
                break;
            }
            case 5: {
                Object addedValues = notification.getOldValue();
                if (!(addedValues instanceof Collection)) break;
                for (Object av : (Collection)addedValues) {
                    this.changeCommentIndex(true, av);
                }
                break;
            }
            case 4: {
                Object removedValue = notification.getOldValue();
                this.changeCommentIndex(false, removedValue);
                break;
            }
            case 6: {
                Object removedValues = notification.getOldValue();
                if (!(removedValues instanceof Collection)) break;
                for (Object rv : (Collection)removedValues) {
                    this.changeCommentIndex(false, rv);
                }
                break;
            }
            case 1: {
                Object value = notification.getNewValue();
                Object oldValue = notification.getOldValue();
                if (value != null) {
                    this.changeCommentIndex(true, value);
                    break;
                }
                this.changeCommentIndex(false, oldValue);
            }
        }
    }

    private void changeCommentIndex(boolean add, Object value) {
        try {
            EList contents = this.eContents();
            int index = contents.indexOf(value);
            if (!add) {
                index = this.oldContents.indexOf(value);
                this.oldContents.remove(value);
            }
            if (index == -1) {
                return;
            }
            Iterator<String> key = this.commentIndexMap.keySet().iterator();
            while (key.hasNext()) {
                String k = key.next();
                Integer i = this.getCommentIndex(k);
                if (i < index) continue;
                if (add) {
                    i = new Integer(i + 1);
                } else if (i > index) {
                    i = new Integer(i - 1);
                }
                this.commentIndexMap.remove(key);
                this.commentIndexMap.put(k, i);
            }
        }
        catch (Throwable throwable) {}
    }

    public void setTarget(Notifier newTarget) {
    }

    @Override
    public void addComment(String comment, Integer index) {
        this.commentsList.add(comment);
        this.setCommentIndex(comment, index);
    }

    @Override
    public List<String> getCommentList() {
        return this.commentsList;
    }

    @Override
    public Integer getCommentIndex(String comment) {
        return this.commentIndexMap.get(comment);
    }

    @Override
    public void setCommentIndex(String comment, Integer obj) {
        this.commentIndexMap.put(comment, obj);
    }

    protected AbstractAnyTypeImpl() {
        this.eAdapters().add((Object)this);
        this.oldContents = new ArrayList<Object>();
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.ABSTRACT_ANY_TYPE;
    }

    @Override
    public String getCDATA() {
        return SmooksModelUtils.getAnyTypeCDATA(this);
    }

    @Override
    public void setCDATA(String cdata) {
        SmooksModelUtils.cleanCDATAToSmooksType(this);
        SmooksModelUtils.appendCDATAToSmooksType(this, cdata);
    }

    @Override
    public String getStringValue() {
        return SmooksModelUtils.getAnyTypeText(this);
    }

    @Override
    public void setStringValue(String stringValue) {
        SmooksModelUtils.cleanTextToSmooksType(this);
        SmooksModelUtils.appendTextToSmooksType(this, stringValue);
    }
}

