/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.freemarker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InlineDirective implements Enumerator
{
    ADDTO(0, "addto", "addto"),
    REPLACE(1, "replace", "replace"),
    INSERTBEFORE(2, "insertbefore", "insertbefore"),
    INSERTAFTER(3, "insertafter", "insertafter");

    public static final int ADDTO_VALUE = 0;
    public static final int REPLACE_VALUE = 1;
    public static final int INSERTBEFORE_VALUE = 2;
    public static final int INSERTAFTER_VALUE = 3;
    private static final InlineDirective[] VALUES_ARRAY;
    public static final List<InlineDirective> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InlineDirective[]{ADDTO, REPLACE, INSERTBEFORE, INSERTAFTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InlineDirective get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InlineDirective result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InlineDirective getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InlineDirective result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InlineDirective get(int value) {
        switch (value) {
            case 0: {
                return ADDTO;
            }
            case 1: {
                return REPLACE;
            }
            case 2: {
                return INSERTBEFORE;
            }
            case 3: {
                return INSERTAFTER;
            }
        }
        return null;
    }

    private InlineDirective(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

