/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.jmsrouting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AcknowledgeMode implements Enumerator
{
    AUTOACKNOWLEDGE(0, "AUTOACKNOWLEDGE", "AUTO_ACKNOWLEDGE"),
    CLIENTACKNOWLEDGE(1, "CLIENTACKNOWLEDGE", "CLIENT_ACKNOWLEDGE"),
    DUPSOKACKNOWLEDGE(2, "DUPSOKACKNOWLEDGE", "DUPS_OK_ACKNOWLEDGE");

    public static final int AUTOACKNOWLEDGE_VALUE = 0;
    public static final int CLIENTACKNOWLEDGE_VALUE = 1;
    public static final int DUPSOKACKNOWLEDGE_VALUE = 2;
    private static final AcknowledgeMode[] VALUES_ARRAY;
    public static final List<AcknowledgeMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AcknowledgeMode[]{AUTOACKNOWLEDGE, CLIENTACKNOWLEDGE, DUPSOKACKNOWLEDGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AcknowledgeMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AcknowledgeMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AcknowledgeMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AcknowledgeMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AcknowledgeMode get(int value) {
        switch (value) {
            case 0: {
                return AUTOACKNOWLEDGE;
            }
            case 1: {
                return CLIENTACKNOWLEDGE;
            }
            case 2: {
                return DUPSOKACKNOWLEDGE;
            }
        }
        return null;
    }

    private AcknowledgeMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

