/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.model.jmsrouting12;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class MessageType
extends AbstractEnumerator {
    public static final int TEXT_MESSAGE = 0;
    public static final int OBJECT_MESSAGE = 1;
    public static final int MAP_MESSAGE = 2;
    public static final MessageType TEXT_MESSAGE_LITERAL = new MessageType(0, "TextMessage", "TextMessage");
    public static final MessageType OBJECT_MESSAGE_LITERAL = new MessageType(1, "ObjectMessage", "ObjectMessage");
    public static final MessageType MAP_MESSAGE_LITERAL = new MessageType(2, "MapMessage", "MapMessage");
    private static final MessageType[] VALUES_ARRAY = new MessageType[]{TEXT_MESSAGE_LITERAL, OBJECT_MESSAGE_LITERAL, MAP_MESSAGE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static MessageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageType get(int value) {
        switch (value) {
            case 0: {
                return TEXT_MESSAGE_LITERAL;
            }
            case 1: {
                return OBJECT_MESSAGE_LITERAL;
            }
            case 2: {
                return MAP_MESSAGE_LITERAL;
            }
        }
        return null;
    }

    private MessageType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

