/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jboss.tools.smooks.configuration.ProcessNodeType;
import org.jboss.tools.smooks.configuration.RuntimeMetadata;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitBefore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDependency {
    private String artifactId;
    private URI namespaceURI;
    private URI changeToNS;
    private boolean supportedByEditor;
    private List<SmooksVersion> runtimeVersions;
    private static final String GROUP_ID = "org.milyn";
    private static final String META_INF = "META-INF";
    private static final String MILYN_SMOOKS_CORE = "milyn-smooks-core";
    private static final String MILYN_SMOOKS_CSV = "milyn-smooks-csv";
    private static final String MILYN_SMOOKS_EDI = "milyn-smooks-edi";
    private static final String MILYN_SMOOKS_JSON = "milyn-smooks-json";
    private static final String MILYN_SMOOKS_TEMPLATING = "milyn-smooks-templating";
    private static final String MILYN_SMOOKS_JAVABEAN = "milyn-smooks-javabean";
    private static final String MILYN_SMOOKS_FIXED_LENGTH = "milyn-smooks-fixed-length";
    private static final String MILYN_SMOOKS_CALC = "milyn-smooks-calc";
    private static final String MILYN_SMOOKS_PERSISTENCE = "milyn-smooks-persistence";
    private static final String MILYN_SMOOKS_ROUTING = "milyn-smooks-routing";
    private static final String MILYN_SMOOKS_RULES = "milyn-smooks-rules";
    private static final String MILYN_SMOOKS_SCRIPTING = "milyn-smooks-scripting";
    private static final String MILYN_SMOOKS_VALIDATION = "milyn-smooks-validation";

    private RuntimeDependency(String artifactId, URI namespaceURI, URI changeToNS, boolean supportedByEditor, List<SmooksVersion> runtimeVersions) {
        this.artifactId = artifactId;
        this.namespaceURI = namespaceURI;
        this.changeToNS = changeToNS;
        this.supportedByEditor = supportedByEditor;
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public URI getNamespaceURI() {
        return this.namespaceURI;
    }

    public URI getChangeToNS() {
        return this.changeToNS;
    }

    public boolean isSupportedByEditor() {
        return this.supportedByEditor;
    }

    public boolean isSupportedBySmooksVersion(SmooksVersion smooksVersion) {
        return this.runtimeVersions.contains((Object)smooksVersion);
    }

    public boolean isOnProjectClasspath(ClassLoader projectClassloader) {
        String resourcePath = META_INF + this.namespaceURI.getPath();
        return projectClassloader.getResource(resourcePath) != null;
    }

    public static void addDependencyChecklist(Smooks metadataExtractor) {
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.BASE, "smooks-1.1.xsd", null, true, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CSV, ProcessNodeType.INPUT_CSV, "smooks/csv-1.2.xsd", null, true, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_EDI, ProcessNodeType.INPUT_EDI, "smooks/edi-1.2.xsd", null, true, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_JSON, ProcessNodeType.INPUT_JSON, "smooks/json-1.2.xsd", null, true, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_TEMPLATING, ProcessNodeType.TEMPLATING, "smooks/freemarker-1.1.xsd", null, true, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/freemarker");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_JAVABEAN, ProcessNodeType.JAVA_BINDING, "smooks/javabean-1.2.xsd", null, true, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/bean");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.BASE, "smooks-1.0.xsd", "smooks-1.1.xsd", false, SmooksVersion.v1_0, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CSV, ProcessNodeType.INPUT_CSV, "smooks/csv-1.1.xsd", "smooks/csv-1.2.xsd", false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CSV, ProcessNodeType.INPUT_CSV, "smooks/csv-1.3.xsd", "smooks/csv-1.2.xsd", false, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_EDI, ProcessNodeType.INPUT_EDI, "smooks/edi-1.1.xsd", "smooks/edi-1.2.xsd", false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_JSON, ProcessNodeType.INPUT_JSON, "smooks/json-1.1.xsd", "smooks/json-1.2.xsd", false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_FIXED_LENGTH, ProcessNodeType.FIXED_LENGTH, "smooks/fixed-length-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/reader");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.DATASOURCE, "smooks/datasource-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/direct");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.DATASOURCE, "smooks/datasource-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/JNDI");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.DATASOURCE, "smooks/datasource-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/direct");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.DATASOURCE, "smooks/datasource-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/JNDI");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.CORE, "smooks/core-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/filterSettings");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.CORE, "smooks/core-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/namespaces");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CORE, ProcessNodeType.CORE, "smooks/core-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/terminate");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_TEMPLATING, ProcessNodeType.TEMPLATING, "smooks/xsl-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/xsl");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_JAVABEAN, ProcessNodeType.JAVA_BINDING, "smooks/javabean-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/binding");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_JAVABEAN, ProcessNodeType.JAVA_BINDING, "smooks/javabean-1.3.xsd", null, false, SmooksVersion.v1_3), "/smooks-resource-list/bean");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_CALC, ProcessNodeType.CALC, "smooks/calc-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/counter");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/inserter");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/updater");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/deleter");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/deleter");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/flusher");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_PERSISTENCE, ProcessNodeType.PERSISTENCE, "smooks/persistence-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/locator");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/db-routing-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/executor");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/db-routing-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/resultSetRowSelector");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/file-routing-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/outputStream");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/io-routing-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/router");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/jms-routing-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/router");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_ROUTING, ProcessNodeType.ROUTING, "smooks/jms-routing-1.2.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/router");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_RULES, ProcessNodeType.RULES, "smooks/rules-1.0.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/ruleBases");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_SCRIPTING, ProcessNodeType.SCRIPTING, "smooks/groovy-1.1.xsd", null, false, SmooksVersion.v1_1, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/groovy");
        metadataExtractor.addVisitor((Visitor)new RuntimeDependencyTracker(MILYN_SMOOKS_VALIDATION, ProcessNodeType.VALIDATION, "smooks/validation-1.0.xsd", null, false, SmooksVersion.v1_2, SmooksVersion.v1_3), "/smooks-resource-list/rule");
    }

    /* synthetic */ RuntimeDependency(String string, URI uRI, URI uRI2, boolean bl, List list, RuntimeDependency runtimeDependency) {
        this(string, uRI, uRI2, bl, list);
    }

    private static class RuntimeDependencyTracker
    implements SAXVisitBefore {
        private String artifactId;
        private ProcessNodeType nodeType;
        private URI namespaceURI;
        private URI changeToNS;
        private boolean supportedByEditor;
        private List<SmooksVersion> runtimeVersions = new ArrayList<SmooksVersion>();

        public RuntimeDependencyTracker(String artifactId, ProcessNodeType nodeType, String xsd, String changeToXSD, boolean supportedByEditor, SmooksVersion ... runtimeVersions) {
            this.artifactId = artifactId;
            this.nodeType = nodeType;
            this.namespaceURI = URI.create("http://www.milyn.org/xsd/" + xsd);
            if (changeToXSD != null) {
                this.changeToNS = URI.create("http://www.milyn.org/xsd/" + changeToXSD);
            }
            this.supportedByEditor = supportedByEditor;
            if (runtimeVersions != null) {
                this.runtimeVersions.addAll(Arrays.asList(runtimeVersions));
            }
        }

        public void visitBefore(SAXElement configElement, ExecutionContext execContext) throws SmooksException, IOException {
            String configNS;
            RuntimeMetadata metadata = (RuntimeMetadata)execContext.getAttribute(RuntimeMetadata.class);
            HashSet<URI> alreadyProcessed = (HashSet<URI>)execContext.getAttribute(RuntimeDependencyTracker.class);
            metadata.getNodeTypes().add(this.nodeType);
            if (alreadyProcessed == null) {
                alreadyProcessed = new HashSet<URI>();
                execContext.setAttribute(RuntimeDependencyTracker.class, alreadyProcessed);
            }
            if ((configNS = configElement.getName().getNamespaceURI()).equals(this.namespaceURI.toString()) && !alreadyProcessed.contains(this.namespaceURI)) {
                metadata.getDependencies().add(new RuntimeDependency(this.artifactId, this.namespaceURI, this.changeToNS, this.supportedByEditor, this.runtimeVersions, null));
                alreadyProcessed.add(this.namespaceURI);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SmooksVersion {
        v1_0,
        v1_1,
        v1_2,
        v1_3;

    }
}

