/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.NewOrModifySmooksElementDialog;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.common.AbstractAnyType;

public class ModelChildrenTablePanelCreator {
    private ISmooksModelProvider smooksModelProvider;
    protected TableViewer childrenTableViewer;
    private Button newChildButton;
    private Button removeRemoveButton;
    private Button upChildButton;
    private Button downChildButton;
    private Button childPropertiesButton;
    private EObject parentModel;
    private FormToolkit toolkit;
    private IEditorPart editorPart;

    public ModelChildrenTablePanelCreator(ISmooksModelProvider smooksModelProvider, EObject parentModel, FormToolkit toolkit, IEditorPart editorPart) {
        this.parentModel = parentModel;
        this.smooksModelProvider = smooksModelProvider;
        this.toolkit = toolkit;
        this.editorPart = editorPart;
    }

    public Composite createChildrenTablePanel(Composite parent) {
        Composite mainComposite = this.toolkit.createComposite(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        this.createChildrenTablePanel(mainComposite, this.toolkit);
        return mainComposite;
    }

    protected void createChildrenTablePanel(Composite mainComposite, FormToolkit toolkit) {
        if (this.smooksModelProvider != null) {
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.smooksModelProvider.getEditingDomain();
            EObject parentModel = this.getParentModel();
            this.childrenTableViewer = new TableViewer(mainComposite);
            GridData gd = new GridData(1808);
            this.childrenTableViewer.getControl().setLayoutData((Object)gd);
            toolkit.paintBordersFor(mainComposite);
            Composite buttonArea = toolkit.createComposite(mainComposite);
            gd = new GridData(1040);
            gd.widthHint = 30;
            GridLayout bgl = new GridLayout();
            buttonArea.setLayout((Layout)bgl);
            this.newChildButton = toolkit.createButton(buttonArea, Messages.ModelChildrenTablePanelCreator_NewButtonLabel, 0);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.newChildButton.setLayoutData((Object)gd);
            this.removeRemoveButton = toolkit.createButton(buttonArea, Messages.ModelChildrenTablePanelCreator_RemoveButtonLabel, 0);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.removeRemoveButton.setLayoutData((Object)gd);
            this.upChildButton = toolkit.createButton(buttonArea, Messages.ModelChildrenTablePanelCreator_UpButtonLabel, 0);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.upChildButton.setLayoutData((Object)gd);
            this.downChildButton = toolkit.createButton(buttonArea, Messages.ModelChildrenTablePanelCreator_DownButtonLable, 0);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.downChildButton.setLayoutData((Object)gd);
            this.childPropertiesButton = toolkit.createButton(buttonArea, Messages.ModelChildrenTablePanelCreator_PropertiesButtonLabel, 0);
            gd = new GridData(768);
            gd.verticalAlignment = 1;
            this.childPropertiesButton.setLayoutData((Object)gd);
            this.childrenTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(editingDomain.getAdapterFactory()){

                public boolean hasChildren(Object object) {
                    return false;
                }
            });
            this.childrenTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(editingDomain.getAdapterFactory()){

                public String getText(Object object) {
                    Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
                    if (obj instanceof AbstractAnyType) {
                        return super.getText(obj);
                    }
                    return super.getText(object);
                }
            }, SmooksConfigurationActivator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
            if (parentModel != null) {
                this.childrenTableViewer.setInput((Object)parentModel);
            }
            this.childrenTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ModelChildrenTablePanelCreator.this.openChildPropertiesModifyDialog();
                }
            });
            this.childrenTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ModelChildrenTablePanelCreator.this.updateButtons();
                }
            });
            this.hookButtons();
            this.updateButtons();
        }
    }

    protected TableViewer getChildrenTableViewer() {
        return this.childrenTableViewer;
    }

    protected EObject newChildModel() {
        return null;
    }

    protected EStructuralFeature getChildrenFeature() {
        return null;
    }

    protected boolean performNewChild() {
        return true;
    }

    protected void endNewChild() {
    }

    protected void performRemoveChild() {
    }

    protected void endRemoveChild() {
    }

    protected void hookButtons() {
        this.newChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelChildrenTablePanelCreator.this.getSmooksVersion() == null) {
                    return;
                }
                if (ModelChildrenTablePanelCreator.this.performNewChild()) {
                    EObject childModel = ModelChildrenTablePanelCreator.this.newChildModel();
                    EObject parent = ModelChildrenTablePanelCreator.this.getParentModel();
                    if (parent == null || childModel == null) {
                        return;
                    }
                    EStructuralFeature profileFeature = ModelChildrenTablePanelCreator.this.getChildrenFeature();
                    try {
                        NewOrModifySmooksElementDialog dialog = new NewOrModifySmooksElementDialog(ModelChildrenTablePanelCreator.this.editorPart.getEditorSite().getShell(), profileFeature, childModel, parent, ModelChildrenTablePanelCreator.this.toolkit, ModelChildrenTablePanelCreator.this.smooksModelProvider, ModelChildrenTablePanelCreator.this.editorPart, false);
                        if (dialog.open() == 0) {
                            ModelChildrenTablePanelCreator.this.endNewChild();
                        }
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
                super.widgetSelected(e);
            }
        });
        this.removeRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ModelChildrenTablePanelCreator.this.childrenTableViewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj instanceof EObject) {
                    ModelChildrenTablePanelCreator.this.performRemoveChild();
                    EObject profile = (EObject)obj;
                    EObject parent = ModelChildrenTablePanelCreator.this.getParentModel();
                    if (parent == null) {
                        return;
                    }
                    CompoundCommand compoundCommand = new CompoundCommand();
                    Command command = RemoveCommand.create((EditingDomain)ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain(), (Object)profile);
                    compoundCommand.append(command);
                    ModelChildrenTablePanelCreator.this.performRunRemoveCommand(compoundCommand, ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain());
                    ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
                    ModelChildrenTablePanelCreator.this.endRemoveChild();
                }
            }
        });
        this.upChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ModelChildrenTablePanelCreator.this.childrenTableViewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj instanceof EObject) {
                    EObject profilesType = ModelChildrenTablePanelCreator.this.getParentModel();
                    if (profilesType == null) {
                        return;
                    }
                    EObject v = (EObject)AdapterFactoryEditingDomain.unwrap((Object)obj);
                    EObject parent = v.eContainer();
                    int index = parent.eContents().indexOf((Object)v);
                    Command command = MoveCommand.create((EditingDomain)ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain(), (Object)parent, null, (Object)obj, (int)(index - 1));
                    ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        this.downChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ModelChildrenTablePanelCreator.this.childrenTableViewer.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj instanceof EObject) {
                    EObject profilesType = ModelChildrenTablePanelCreator.this.getParentModel();
                    if (profilesType == null) {
                        return;
                    }
                    EObject v = (EObject)AdapterFactoryEditingDomain.unwrap((Object)obj);
                    EObject parent = v.eContainer();
                    int index = parent.eContents().indexOf((Object)v);
                    Command command = MoveCommand.create((EditingDomain)ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain(), (Object)parent, null, (Object)obj, (int)(index + 1));
                    ModelChildrenTablePanelCreator.this.smooksModelProvider.getEditingDomain().getCommandStack().execute(command);
                }
            }
        });
        this.childPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelChildrenTablePanelCreator.this.openChildPropertiesModifyDialog();
                super.widgetSelected(e);
            }
        });
    }

    protected void performRunRemoveCommand(CompoundCommand compoundCommand, EditingDomain editDomain) {
    }

    protected void updateButtons() {
        if (this.getSmooksVersion() == null) {
            this.childPropertiesButton.setEnabled(false);
            this.newChildButton.setEnabled(false);
            this.removeRemoveButton.setEnabled(false);
            this.upChildButton.setEnabled(false);
            this.downChildButton.setEnabled(false);
            return;
        }
        this.childPropertiesButton.setEnabled(true);
        this.removeRemoveButton.setEnabled(true);
        IStructuredSelection selection = (IStructuredSelection)this.childrenTableViewer.getSelection();
        if (selection == null) {
            this.childPropertiesButton.setEnabled(false);
            this.removeRemoveButton.setEnabled(false);
            this.upChildButton.setEnabled(false);
            this.downChildButton.setEnabled(false);
        } else {
            if (selection.getFirstElement() == null) {
                this.childPropertiesButton.setEnabled(false);
                this.removeRemoveButton.setEnabled(false);
                this.upChildButton.setEnabled(false);
                this.downChildButton.setEnabled(false);
                return;
            }
            Object obj = selection.getFirstElement();
            if (obj instanceof EObject) {
                EObject profilesType = this.getParentModel();
                if (profilesType == null) {
                    return;
                }
                EObject v = (EObject)AdapterFactoryEditingDomain.unwrap((Object)obj);
                EObject parent = v.eContainer();
                int index = parent.eContents().indexOf((Object)v);
                Command command = MoveCommand.create((EditingDomain)this.smooksModelProvider.getEditingDomain(), (Object)parent, null, (Object)obj, (int)(index - 1));
                this.upChildButton.setEnabled(command.canExecute());
                Command command1 = MoveCommand.create((EditingDomain)this.smooksModelProvider.getEditingDomain(), (Object)parent, null, (Object)obj, (int)(index + 1));
                this.downChildButton.setEnabled(command1.canExecute());
            }
            if (selection.size() > 1) {
                this.childPropertiesButton.setEnabled(false);
                this.removeRemoveButton.setEnabled(false);
            }
        }
    }

    protected void openChildPropertiesModifyDialog() {
        IStructuredSelection selection = (IStructuredSelection)this.childrenTableViewer.getSelection();
        if (selection == null) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof EObject) {
            EObject child = (EObject)obj;
            EObject parent = this.getParentModel();
            EStructuralFeature childFeature = this.getChildrenFeature();
            NewOrModifySmooksElementDialog dialog = new NewOrModifySmooksElementDialog(this.editorPart.getEditorSite().getShell(), childFeature, child, parent, this.toolkit, this.smooksModelProvider, this.editorPart, true);
            dialog.open();
        }
    }

    public EObject getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(EObject parentModel) {
        this.parentModel = parentModel;
    }

    public String getSmooksVersion() {
        if (this.smooksModelProvider != null) {
            return this.smooksModelProvider.getPlatformVersion();
        }
        return null;
    }
}

