/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.actions.AddSmooksResourceAction;
import org.jboss.tools.smooks.configuration.actions.ValidateSmooksAction;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.actions.Calc11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Database11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Datasources11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.FragmentRouting11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.FragmentRouting12ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.ISmooksActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.JavaBean11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.JavaBean12ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.PersistenceActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Reader11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Reader12ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Scripting11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.SeparatorActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Templating11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Validation10ActionGrouper;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.medi.DocumentRoot;
import org.jboss.tools.smooks.model.medi.EdiMap;
import org.jboss.tools.smooks.model.medi.MEdiFactory;
import org.jboss.tools.smooks.model.medi.MEdiPackage;
import org.jboss.tools.smooks.model.smooks.SmooksFactory;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected ISelection selection;
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(Messages.SmooksActionBarContributor_OpenProperyViewActionLabel){

        public void run() {
            try {
                SmooksActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                SmooksConfigurationActivator.getDefault();
                SmooksConfigurationActivator.log(exception);
            }
        }
    };
    protected IAction addSmooks11ResourceListAction = new Action("Add Smooks Resource List"){

        public void run() {
            SmooksActionBarContributor.this.addSmooks11ResourceList();
        }
    };
    protected IAction addSmooks10ResourceListAction = new Action("Add Smooks Resource List"){

        public void run() {
        }
    };
    protected IAction addMap10ResourceListAction = new Action("Add MappNode"){

        public void run() {
            SmooksActionBarContributor.this.addMapNode();
        }
    };
    protected IAction refreshViewerAction = new Action(Messages.SmooksActionBarContributor_RefreshViewActionLabel){

        public boolean isEnabled() {
            return SmooksActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (SmooksActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)SmooksActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    private ValidateSmooksAction validateSmooksAction;

    public SmooksActionBarContributor() {
        super(1);
        this.validateAction = new ValidateAction();
    }

    protected void addMapNode() {
        ISmooksModelProvider formEditor = (ISmooksModelProvider)this.getActiveEditor();
        EObject model = formEditor.getSmooksModel();
        if (model instanceof DocumentRoot) {
            EdiMap mappingNode = MEdiFactory.eINSTANCE.createEdiMap();
            Command command = AddCommand.create((EditingDomain)formEditor.getEditingDomain(), (Object)model, (Object)MEdiPackage.eINSTANCE.getMappingNode(), (Object)mappingNode);
            formEditor.getEditingDomain().getCommandStack().execute(command);
        }
    }

    protected void addSmooks11ResourceList() {
        ISmooksModelProvider formEditor = (ISmooksModelProvider)this.getActiveEditor();
        EObject model = formEditor.getSmooksModel();
        if (model instanceof org.jboss.tools.smooks.model.smooks.DocumentRoot) {
            SmooksResourceListType resourceList = SmooksFactory.eINSTANCE.createSmooksResourceListType();
            Command command = AddCommand.create((EditingDomain)formEditor.getEditingDomain(), (Object)model, (Object)SmooksPackage.eINSTANCE.getSmooksResourceListType(), (Object)resourceList);
            formEditor.getEditingDomain().getCommandStack().execute(command);
        }
    }

    public void update() {
        super.update();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("smooks-settings"));
        toolBarManager.add((IContributionItem)new Separator("smooks-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager("Smooks", "smooksMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(Messages.SmooksActionBarContributor_AddSmooksReasourceActionLabel);
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(Messages.SmooksActionBarContributor_NewSiblingActionLabel);
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.insertBefore("additions", this.addSmooks11ResourceListAction);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.validateSmooksAction = new ValidateSmooksAction();
        this.validateSmooksAction.setText(Messages.SmooksActionBarContributor_ValidateActionLabel);
        this.cutAction = new CutAction(){

            public void runWithEvent(Event event) {
                Widget widget = event.widget;
                if (widget instanceof Text) {
                    ((Text)widget).cut();
                    return;
                }
                if (widget instanceof Combo) {
                    ((Combo)widget).cut();
                    return;
                }
                super.runWithEvent(event);
            }

            public boolean isEnabled() {
                return super.isEnabled();
            }
        };
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = new CopyAction(){

            public void runWithEvent(Event event) {
                Widget widget = event.widget;
                if (widget instanceof Text) {
                    ((Text)widget).copy();
                    return;
                }
                if (widget instanceof Combo) {
                    ((Combo)widget).copy();
                    return;
                }
                super.runWithEvent(event);
            }
        };
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = new PasteAction(){

            public void runWithEvent(Event event) {
                Widget widget = event.widget;
                if (widget instanceof Text) {
                    ((Text)widget).paste();
                    return;
                }
                if (widget instanceof Combo) {
                    ((Combo)widget).paste();
                    return;
                }
                super.runWithEvent(event);
            }

            public boolean updateSelection(IStructuredSelection selection) {
                super.updateSelection(selection);
                return true;
            }
        };
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        this.selection = selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            object = AdapterFactoryEditingDomain.unwrap((Object)object);
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            this.validateSmooksAction.setResource((Resource)domain.getResourceSet().getResources().get(0));
            this.validateSmooksAction.setEditingDomain(domain);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new AddSmooksResourceAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected CommandParameter createChildParameter(Object feature, Object child) {
        return new CommandParameter(null, feature, child);
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions-end"));
        MenuManager submenuManager = null;
        this.updateRootElementAddAction();
        if (this.addSmooks11ResourceListAction.isEnabled()) {
            menuManager.insertBefore("edit", this.addSmooks11ResourceListAction);
        }
        if (this.addSmooks10ResourceListAction.isEnabled()) {
            menuManager.insertBefore("edit", this.addSmooks10ResourceListAction);
        }
        if (this.addMap10ResourceListAction.isEnabled()) {
            menuManager.insertBefore("edit", this.addMap10ResourceListAction);
        }
        submenuManager = new MenuManager(Messages.SmooksActionBarContributor_AddSmooksResourceActionLabel);
        if (this.isSmooksResourceListElement()) {
            this.groupActions(submenuManager, this.createChildActions);
        } else {
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        }
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(Messages.SmooksActionBarContributor_CreateSiblingActionLabel);
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        menuManager.insertAfter("additions-end", (IAction)this.validateSmooksAction);
        this.addGlobalActions(menuManager);
    }

    private boolean isSmooksResourceListElement() {
        Object element;
        return this.selection != null && this.selection instanceof IStructuredSelection && (element = ((IStructuredSelection)this.selection).getFirstElement()) instanceof SmooksResourceListType;
    }

    private List<ISmooksActionGrouper> getSmooksActionGrouper() {
        ArrayList<ISmooksActionGrouper> grouperList = new ArrayList<ISmooksActionGrouper>();
        grouperList.add(new JavaBean11ActionGrouper());
        grouperList.add(new Reader11ActionGrouper());
        grouperList.add(new Calc11ActionGrouper());
        grouperList.add(new Database11ActionGrouper());
        grouperList.add(new Datasources11ActionGrouper());
        grouperList.add(new FragmentRouting11ActionGrouper());
        grouperList.add(new Scripting11ActionGrouper());
        grouperList.add(new Templating11ActionGrouper());
        grouperList.add(new SeparatorActionGrouper("V1.1-V1.2"));
        grouperList.add(new JavaBean12ActionGrouper());
        grouperList.add(new Reader12ActionGrouper());
        grouperList.add(new FragmentRouting12ActionGrouper());
        grouperList.add(new PersistenceActionGrouper());
        grouperList.add(new Validation10ActionGrouper());
        grouperList.add(new SeparatorActionGrouper("No Group actions"));
        return grouperList;
    }

    protected void groupActions(MenuManager manager, Collection<?> createChildActions) {
        HashMap<MenuManager, ISmooksActionGrouper> map = new HashMap<MenuManager, ISmooksActionGrouper>();
        List<ISmooksActionGrouper> grouperList = this.getSmooksActionGrouper();
        for (ISmooksActionGrouper grouper : grouperList) {
            String name;
            if (grouper.isSeparator()) {
                name = grouper.getGroupName();
                if (name == null) {
                    name = Messages.SmooksActionBarContributor_33;
                }
                Separator s = new Separator(name);
                manager.add((IContributionItem)s);
                continue;
            }
            name = grouper.getGroupName();
            if (name == null) continue;
            MenuManager newMenu = new MenuManager(name);
            manager.add((IContributionItem)newMenu);
            map.put(newMenu, grouper);
        }
        Iterator<?> iterator = createChildActions.iterator();
        while (iterator.hasNext()) {
            boolean added = false;
            AddSmooksResourceAction action = (AddSmooksResourceAction)((Object)iterator.next());
            Object descriptor = action.getDescriptor();
            for (MenuManager newMenu : map.keySet()) {
                ISmooksActionGrouper grouper = (ISmooksActionGrouper)map.get(newMenu);
                if (!grouper.belongsToGroup(descriptor)) continue;
                newMenu.add((IAction)action);
                added = true;
                break;
            }
            if (added) continue;
            manager.add((IAction)action);
        }
        for (MenuManager newMenu : map.keySet()) {
            ISmooksActionGrouper grouper = (ISmooksActionGrouper)map.get(newMenu);
            grouper.orderActions(newMenu);
        }
    }

    protected void updateRootElementAddAction() {
        Command command;
        this.addSmooks11ResourceListAction.setEnabled(false);
        this.addMap10ResourceListAction.setEnabled(false);
        this.addSmooks10ResourceListAction.setEnabled(false);
        ISmooksModelProvider formEditor = (ISmooksModelProvider)this.getActiveEditor();
        EObject model = formEditor.getSmooksModel();
        if (model instanceof org.jboss.tools.smooks.model.smooks.DocumentRoot) {
            SmooksResourceListType resourceList = SmooksFactory.eINSTANCE.createSmooksResourceListType();
            command = AddCommand.create((EditingDomain)formEditor.getEditingDomain(), (Object)model, (Object)SmooksPackage.eINSTANCE.getSmooksResourceListType(), (Object)resourceList);
            this.addSmooks11ResourceListAction.setEnabled(command.canExecute());
        }
        if (model instanceof DocumentRoot) {
            EdiMap mappingNode = MEdiFactory.eINSTANCE.createEdiMap();
            command = AddCommand.create((EditingDomain)formEditor.getEditingDomain(), (Object)model, (Object)MEdiPackage.eINSTANCE.getEdiMap(), (Object)mappingNode);
            this.addMap10ResourceListAction.setEnabled(command.canExecute());
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }
}

