/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SmooksConfigFileHandle
extends DefaultHandler {
    private boolean correctContentFile = false;
    private String[] smooksSpportURI = this.createSupportURI();
    private SAXParserFactory fFactory;

    protected String[] createSupportURI() {
        return new String[]{"http://www.milyn.org/xsd/smooks-1.1.xsd", "http://www.milyn.org/xsd/smooks-1.0.xsd", "http://www.milyn.org/xsd/smooks/xsl-1.1.xsd", "http://www.milyn.org/xsd/smooks/freemarker-1.1.xsd", "http://www.milyn.org/xsd/smooks/groovy-1.1.xsd", "http://www.milyn.org/xsd/smooks/calc-1.1.xsd", "http://www.milyn.org/xsd/smooks/datasource-1.1.xsd", "http://www.milyn.org/xsd/smooks/file-routing-1.1.xsd", "http://www.milyn.org/xsd/smooks/io-routing-1.1.xsd", "http://www.milyn.org/xsd/smooks/jms-routing-1.1.xsd"};
    }

    private final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAXParserFactory getFactory() {
        SmooksConfigFileHandle smooksConfigFileHandle = this;
        synchronized (smooksConfigFileHandle) {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            this.fFactory = SAXParserFactory.newInstance();
            this.fFactory.setNamespaceAware(true);
        }
        return this.fFactory;
    }

    public boolean parseContents(InputSource contents) throws ParserConfigurationException, IOException {
        block3: {
            try {
                this.fFactory = this.getFactory();
                if (this.fFactory != null) break block3;
                return false;
            }
            catch (SAXException sAXException) {}
        }
        SAXParser parser = this.createParser(this.fFactory);
        contents.setSystemId("/");
        parser.parse(contents, (DefaultHandler)this);
        return true;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        if (this.containtSmooksURI(uri)) {
            this.setCorrectContentFile(true);
            throw new SAXException(Messages.SmooksConfigFileHandle_exception);
        }
    }

    private boolean unSupportUIR(String uri) {
        return false;
    }

    private boolean containtSmooksURI(String uri) {
        int i = 0;
        while (i < this.smooksSpportURI.length) {
            if (uri != null && uri.trim().equalsIgnoreCase(this.smooksSpportURI[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
        if (this.isCorrectContentFile()) {
            throw new SAXException(Messages.SmooksConfigFileHandle_exception);
        }
        if (this.containtSmooksURI(uri)) {
            this.setCorrectContentFile(true);
            throw new SAXException(Messages.SmooksConfigFileHandle_exception);
        }
    }

    public boolean isCorrectContentFile() {
        return this.correctContentFile;
    }

    public void setCorrectContentFile(boolean correctContentFile) {
        this.correctContentFile = correctContentFile;
    }
}

