/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.smooks.configuration.SmooksConstants;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.ModelPanelCreator;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.ISourceSynchronizeListener;
import org.jboss.tools.smooks.graphical.editors.ISmooksEditorInitListener;
import org.jboss.tools.smooks.graphical.editors.SmooksMessage;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.ParamsType;
import org.jboss.tools.smooks.model.smooks.SmooksFactory;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksConfigurationOverviewPage
extends FormPage
implements ISmooksModelValidateListener,
ISourceSynchronizeListener,
ISmooksEditorInitListener {
    private int currentMessageType = 0;
    private String currentMessage = null;
    private ISmooksModelProvider smooksModelProvider;
    private ModelPanelCreator defaultSettingPanelCreator;
    private Section globalParamSection;
    private Section settingSection;
    protected boolean lockEventFire = false;
    private Combo streamFilterTypeCombo;
    private Button defaultSerializationOnCheckbox;
    private Combo versionCombo;

    public SmooksConfigurationOverviewPage(FormEditor editor, String id, String title, ISmooksModelProvider provider) {
        super(editor, id, title);
        this.smooksModelProvider = provider;
    }

    public SmooksConfigurationOverviewPage(String id, String title, ISmooksModelProvider provider) {
        super(id, title);
        this.smooksModelProvider = provider;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        String title = this.getTitle();
        form.setText(title);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        form.getBody().setLayout((Layout)gl);
        ScrolledPageBook pageBook = new ScrolledPageBook(form.getBody());
        pageBook.setBackground(toolkit.getColors().getBackground());
        Composite mainComposite = pageBook.createPage((Object)pageBook);
        pageBook.showPage((Object)pageBook);
        GridData gd = new GridData(1808);
        pageBook.setLayoutData((Object)gd);
        GridLayout mgl = new GridLayout();
        mgl.numColumns = 2;
        mgl.horizontalSpacing = 20;
        mainComposite.setLayout((Layout)mgl);
        this.settingSection = toolkit.createSection(mainComposite, 256);
        this.settingSection.setLayout((Layout)new FillLayout());
        this.settingSection.setText(Messages.SmooksConfigurationOverviewPage_ConfigurationSectionTitle);
        Composite settingComposite = toolkit.createComposite((Composite)this.settingSection);
        this.settingSection.setClient((Control)settingComposite);
        gd = new GridData();
        gd.widthHint = 500;
        gd.verticalAlignment = 1;
        this.settingSection.setLayoutData((Object)gd);
        GridLayout sgl = new GridLayout();
        settingComposite.setLayout((Layout)sgl);
        sgl.numColumns = 2;
        this.createSettingSection(settingComposite, toolkit);
        this.globalParamSection = toolkit.createSection(mainComposite, 322);
        this.globalParamSection.setText(Messages.SmooksConfigurationOverviewPage_FilterSettingSectionTitle);
        this.globalParamSection.setLayout((Layout)new FillLayout());
        Composite globalParamComposite = toolkit.createComposite((Composite)this.globalParamSection);
        this.globalParamSection.setClient((Control)globalParamComposite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.widthHint = 500;
        this.globalParamSection.setLayoutData((Object)gd);
        GridLayout gpgl = new GridLayout();
        globalParamComposite.setLayout((Layout)gpgl);
        gpgl.numColumns = 2;
        this.createGlobalParamterSection(globalParamComposite, toolkit);
        this.updateFormHeader();
    }

    private void createSettingSection(Composite settingComposite, FormToolkit toolkit) {
        toolkit.createLabel(settingComposite, Messages.SmooksConfigurationOverviewPage_VersionLabel).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        int type = 2048;
        if (SmooksUIUtils.isLinuxOS()) {
            type = 2048;
        }
        this.versionCombo = new Combo(settingComposite, type | 8);
        this.versionCombo.setEnabled(false);
        GridData gd = new GridData(768);
        this.versionCombo.setLayoutData((Object)gd);
        int i = 0;
        while (i < SmooksConstants.SMOOKS_VERSIONS.length) {
            String version = SmooksConstants.SMOOKS_VERSIONS[i];
            this.versionCombo.add(version);
            ++i;
        }
        String version = this.getSmooksVersion();
        if (version != null) {
            this.versionCombo.setText(version);
        }
        this.versionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        toolkit.paintBordersFor(settingComposite);
    }

    private ParamsType getParamsType() {
        EObject smooksModel;
        if (this.smooksModelProvider != null && (smooksModel = this.smooksModelProvider.getSmooksModel()) instanceof DocumentRoot) {
            ParamsType m = ((DocumentRoot)smooksModel).getSmooksResourceList().getParams();
            return m;
        }
        return null;
    }

    private void updateGlobalProperty(String propertyID, String value) {
        boolean foundProperty = false;
        EObject resource = this.getSmooksResourceList();
        if (resource == null) {
            return;
        }
        if (this.getSmooksVersion() == null) {
            return;
        }
        ParamsType parent = this.getParamsType();
        ParamType param = null;
        ParamType newparam = null;
        if (parent != null) {
            EList parmList = parent.getParam();
            int i = 0;
            while (i < parmList.size()) {
                param = (ParamType)parmList.get(i);
                if (param.getName().equals(propertyID)) {
                    foundProperty = true;
                    break;
                }
                ++i;
            }
        }
        newparam = SmooksFactory.eINSTANCE.createParamType();
        newparam.setName(propertyID);
        newparam.setStringValue(value);
        if (parent == null) {
            parent = SmooksFactory.eINSTANCE.createParamsType();
            Command command = SetCommand.create((EditingDomain)this.smooksModelProvider.getEditingDomain(), (Object)resource, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__PARAMS, (Object)parent);
            if (command.canExecute()) {
                ((SmooksResourceListType)resource).setParams(parent);
            }
        }
        EditingDomain editingDomain = this.smooksModelProvider.getEditingDomain();
        Command command = null;
        Command command2 = null;
        EReference feature = SmooksPackage.Literals.PARAMS_TYPE__PARAM;
        if (feature instanceof EReference) {
            if (foundProperty) {
                command2 = RemoveCommand.create((EditingDomain)editingDomain, (Object)parent, (Object)feature, (Object)param);
            }
            command = AddCommand.create((EditingDomain)editingDomain, (Object)parent, (Object)feature, (Object)newparam);
        }
        if (command2 != null && command2.canExecute()) {
            editingDomain.getCommandStack().execute(command2);
        }
        if (command != null) {
            editingDomain.getCommandStack().execute(command);
        }
        ((SmooksResourceListType)resource).setParams(parent);
    }

    private void createGlobalParamterSection(Composite globalParamComposite, FormToolkit toolkit) {
        if (this.smooksModelProvider != null) {
            toolkit.createLabel(globalParamComposite, Messages.SmooksConfigurationOverviewPage_FilterTypeLabel).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            GridData gd = new GridData(4, 0, true, false);
            this.streamFilterTypeCombo = new Combo(globalParamComposite, 12);
            this.streamFilterTypeCombo.setItems(new String[]{"SAX", "DOM"});
            this.streamFilterTypeCombo.setLayoutData((Object)gd);
            toolkit.createLabel(globalParamComposite, Messages.SmooksConfigurationOverviewPage_SerializationLabel).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            gd = new GridData(4, 0, true, false);
            this.defaultSerializationOnCheckbox = toolkit.createButton(globalParamComposite, null, 32);
            this.defaultSerializationOnCheckbox.setLayoutData((Object)gd);
            this.initGlobalSettingControls();
            toolkit.paintBordersFor(globalParamComposite);
            this.streamFilterTypeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (SmooksConfigurationOverviewPage.this.lockEventFire) {
                        return;
                    }
                    String value = SmooksConfigurationOverviewPage.this.streamFilterTypeCombo.getText();
                    SmooksConfigurationOverviewPage.this.updateGlobalProperty("stream.filter.type", value);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.defaultSerializationOnCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (SmooksConfigurationOverviewPage.this.lockEventFire) {
                        return;
                    }
                    String value = Boolean.toString(SmooksConfigurationOverviewPage.this.defaultSerializationOnCheckbox.getSelection());
                    SmooksConfigurationOverviewPage.this.updateGlobalProperty("default.serialization.on", value);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }
            });
        }
    }

    public void graphPropertyChange(EStructuralFeature featre, Object value) {
    }

    protected void initGlobalSettingControls() {
        ParamsType m = this.getParamsType();
        if (m != null) {
            EList parmList = m.getParam();
            int i = 0;
            while (i < parmList.size()) {
                ParamType param = (ParamType)parmList.get(i);
                if (param.getName().equals("stream.filter.type")) {
                    this.streamFilterTypeCombo.setText(param.getStringValue());
                } else if (param.getName().equals("default.serialization.on")) {
                    Boolean boolValue = Boolean.valueOf(param.getStringValue());
                    this.defaultSerializationOnCheckbox.setSelection(boolValue.booleanValue());
                }
                ++i;
            }
        } else {
            this.streamFilterTypeCombo.setText("SAX");
            this.defaultSerializationOnCheckbox.setSelection(true);
        }
    }

    public ModelPanelCreator getDefaultSettingPanelCreator() {
        if (this.defaultSettingPanelCreator == null) {
            this.defaultSettingPanelCreator = new ModelPanelCreator();
        }
        return this.defaultSettingPanelCreator;
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        ModelPanelCreator creator = this.getDefaultSettingPanelCreator();
        creator.markPropertyUI(diagnosticResult, this.getSmooksResourceList());
    }

    @Override
    public void validateStart() {
    }

    @Override
    public void sourceChange(Object model) {
        this.lockEventFire = true;
        if (this.streamFilterTypeCombo == null || this.defaultSerializationOnCheckbox == null || this.versionCombo == null) {
            this.lockEventFire = false;
            return;
        }
        this.streamFilterTypeCombo.setEnabled(true);
        this.defaultSerializationOnCheckbox.setEnabled(true);
        String version = this.getSmooksVersion();
        if (version == null) {
            version = "";
        }
        this.versionCombo.setText(version);
        if (model == null) {
            this.streamFilterTypeCombo.setEnabled(false);
            this.defaultSerializationOnCheckbox.setEnabled(false);
            this.defaultSerializationOnCheckbox.setSelection(false);
        } else {
            this.initGlobalSettingControls();
        }
        this.lockEventFire = false;
    }

    protected void disposeCompositeControls(Composite composite, Control[] ignoreControl) {
        if (composite != null) {
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (ignoreControl != null) {
                    int j = 0;
                    while (j < ignoreControl.length) {
                        if (child == ignoreControl[j]) {
                            // empty if block
                        }
                        ++j;
                    }
                }
                child.dispose();
                child = null;
                ++i;
            }
        }
    }

    private EObject getSmooksResourceList() {
        if (this.smooksModelProvider != null) {
            SmooksResourceListType m = null;
            EObject smooksModel = this.smooksModelProvider.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                m = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            return m;
        }
        return null;
    }

    private String getSmooksVersion() {
        if (this.smooksModelProvider != null) {
            return this.smooksModelProvider.getPlatformVersion();
        }
        return null;
    }

    @Override
    public void initFailed(int messageType, String message) {
        this.currentMessage = message;
        this.currentMessageType = messageType;
        this.updateFormHeader();
    }

    protected void updateFormHeader() {
        if (this.currentMessageType == 0) {
            if (this.getManagedForm() != null) {
                this.getManagedForm().getMessageManager().removeAllMessages();
                this.getManagedForm().getMessageManager().update();
                this.streamFilterTypeCombo.setEnabled(true);
                this.defaultSerializationOnCheckbox.setEnabled(true);
            }
        } else if (this.getManagedForm() != null) {
            this.streamFilterTypeCombo.setEnabled(false);
            this.defaultSerializationOnCheckbox.setEnabled(false);
            String[] messages = this.currentMessage.split("\n");
            ArrayList<SmooksMessage> messageList = new ArrayList<SmooksMessage>();
            int i = 0;
            while (i < messages.length) {
                String message = messages[i];
                if (message != null) {
                    message.trim();
                }
                if (message.length() != 0) {
                    messageList.add(new SmooksMessage(this.currentMessageType, message));
                }
                ++i;
            }
            String mainMessage = null;
            mainMessage = messageList.isEmpty() ? this.currentMessage : ((IMessage)messageList.get(0)).getMessage();
            this.getManagedForm().getForm().getForm().setMessage(mainMessage, this.currentMessageType, messageList.toArray(new IMessage[0]));
        }
    }
}

