/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.smooks.configuration.editors.ExtentionInputContentProvider;
import org.jboss.tools.smooks.configuration.editors.ExtentionInputLabelProvider;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.OnlyReaderViewerFilter;
import org.jboss.tools.smooks.configuration.editors.SmooksConfigurationFormPage;
import org.jboss.tools.smooks.configuration.editors.SmooksMasterDetailBlock;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.input.InputType;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class SmooksConfigurationReaderPage
extends SmooksConfigurationFormPage {
    private CheckboxTableViewer inputDataViewer;
    boolean lockCheck = false;

    public SmooksConfigurationReaderPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public SmooksConfigurationReaderPage(String id, String title) {
        super(id, title);
    }

    protected ViewerFilter[] createViewerFilters() {
        return new ViewerFilter[]{new OnlyReaderViewerFilter()};
    }

    protected SmooksMasterDetailBlock createSmooksMasterDetailsBlock() {
        SmooksMasterDetailBlock detailBlock = new SmooksMasterDetailBlock(this.getEditor(), (AdapterFactoryEditingDomain)((SmooksMultiFormEditor)this.getEditor()).getEditingDomain()){

            protected Object getEmptyDefaultSelection(EObject smooksTreeViewerInput) {
                EList contents = smooksTreeViewerInput.eContents();
                for (EObject eObject : contents) {
                    if (!(smooksTreeViewerInput instanceof SmooksResourceListType) || !(eObject instanceof AbstractReader)) continue;
                    return eObject;
                }
                return super.getEmptyDefaultSelection(smooksTreeViewerInput);
            }
        };
        return detailBlock;
    }

    protected String getNewSmooksElementDescription() {
        return Messages.SmooksConfigurationReaderPage_NewReaderDes;
    }

    protected String getNewSmooksElementTitle() {
        return Messages.SmooksConfigurationReaderPage_NewReaderTitle;
    }

    protected String getMainSectionDescription() {
        return Messages.SmooksConfigurationReaderPage_EditReaderDes;
    }

    protected String getMainSectionTitle() {
        return Messages.SmooksConfigurationReaderPage_ReaderSectionTitle;
    }

    protected void setPageTitle(ScrolledForm form) {
        form.setText(Messages.SmooksConfigurationReaderPage_PageTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createExtentionArea(managedForm);
    }

    protected void createExtentionArea(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Section section = toolkit.createSection(form.getBody(), 322);
        GridData gd = new GridData(768);
        section.setLayoutData((Object)gd);
        section.setText(Messages.SmooksConfigurationReaderPage_InputSectionTitle);
        FillLayout flayout = new FillLayout();
        section.setLayout((Layout)flayout);
        Composite mainComposite = toolkit.createComposite((Composite)section, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        section.setClient((Control)mainComposite);
        Composite tableComposite = toolkit.createComposite(mainComposite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        gd = new GridData(1808);
        tableComposite.setLayoutData((Object)gd);
        tableComposite.setBackground(GraphicsConstants.BORDER_CORLOR);
        tableComposite.setLayout((Layout)fillLayout);
        this.inputDataViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)65538);
        this.inputDataViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof InputType) {
                    return ((InputType)element).isActived();
                }
                return false;
            }
        });
        this.inputDataViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SmooksConfigurationReaderPage.this.lockCheck) {
                    return;
                }
                boolean checked = event.getChecked();
                InputType inputType = (InputType)event.getElement();
                inputType.getParameters();
                if (checked) {
                    inputType.setActived(checked);
                    Object[] checkedObjects = SmooksConfigurationReaderPage.this.inputDataViewer.getCheckedElements();
                    int i = 0;
                    while (i < checkedObjects.length) {
                        InputType type = (InputType)checkedObjects[i];
                        type.setActived(!checked);
                        SmooksConfigurationReaderPage.this.lockCheck = true;
                        SmooksConfigurationReaderPage.this.inputDataViewer.setChecked((Object)type, false);
                        SmooksConfigurationReaderPage.this.lockCheck = false;
                        ++i;
                    }
                } else {
                    inputType.setActived(checked);
                }
            }
        });
        TableColumn header = new TableColumn(this.inputDataViewer.getTable(), 0);
        header.setText(Messages.SmooksConfigurationReaderPage_InputTableTypeColumnText);
        header.setWidth(100);
        TableColumn pathColumn = new TableColumn(this.inputDataViewer.getTable(), 0);
        pathColumn.setText(Messages.SmooksConfigurationReaderPage_InputTablePathColumnLabel);
        pathColumn.setWidth(300);
        TableColumn extColumn = new TableColumn(this.inputDataViewer.getTable(), 0);
        extColumn.setText(Messages.SmooksConfigurationReaderPage_InputTableExtensionLabel);
        extColumn.setWidth(400);
        this.inputDataViewer.setContentProvider((IContentProvider)new ExtentionInputContentProvider());
        this.inputDataViewer.setLabelProvider((IBaseLabelProvider)new ExtentionInputLabelProvider());
        this.inputDataViewer.getTable().setHeaderVisible(true);
        this.inputDataViewer.getTable().setLinesVisible(true);
        ISmooksModelProvider smooksModelProvider = (ISmooksModelProvider)this.getAdapter(ISmooksModelProvider.class);
        if (smooksModelProvider != null) {
            this.inputDataViewer.setInput((Object)SmooksUIUtils.getSmooks11ResourceListType(smooksModelProvider.getSmooksModel()));
        }
        Composite buttonComposite = toolkit.createComposite(mainComposite, 0);
        gd = new GridData(1040);
        buttonComposite.setLayoutData((Object)gd);
        GridLayout l = new GridLayout();
        buttonComposite.setLayout((Layout)l);
        Button addButton = toolkit.createButton(buttonComposite, Messages.SmooksConfigurationReaderPage_AddInputButtonLabel, 0x800000);
        gd = new GridData(768);
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmooksConfigurationReaderPage.this.showInputDataWizard();
            }
        });
        Button removeButton = toolkit.createButton(buttonComposite, Messages.SmooksConfigurationReaderPage_DeleteInputButtonLabel, 0x800000);
        gd = new GridData(768);
        removeButton.setLayoutData((Object)gd);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SmooksConfigurationReaderPage.this.inputDataViewer.getSelection();
                if (selection != null) {
                    ISmooksModelProvider modelProvider = (ISmooksModelProvider)SmooksConfigurationReaderPage.this.getAdapter(ISmooksModelProvider.class);
                    if (modelProvider == null) {
                        return;
                    }
                    Object[] objs = selection.toArray();
                    int i = 0;
                    while (i < objs.length) {
                        Object obj = objs[i];
                        if (obj instanceof InputType) {
                            InputType input = (InputType)obj;
                            SmooksUIUtils.removeInputType(input, modelProvider);
                        }
                        ++i;
                    }
                }
            }
        });
    }
}

