/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.SmooksStuffDetailsPageProvider;
import org.jboss.tools.smooks.configuration.editors.SmooksStuffPropertyDetailPage;
import org.jboss.tools.smooks.configuration.wizards.NewSmooksElementWizard;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksMasterDetailBlock
extends MasterDetailsBlock
implements IMenuListener,
ISelectionChangedListener {
    private Section configurationSection;
    private SectionPart sectionPart;
    private TreeViewer smooksTreeViewer;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private String newSmooksElementTitle;
    private String newSmooksElementDescription;
    private AdapterFactoryEditingDomain editingDomain = null;
    private ViewerFilter[] viewerFilters = null;
    private FormEditor formEditor;
    private String sectionTitle;
    private String sectionDescription;

    public SmooksMasterDetailBlock(FormEditor formEditor, AdapterFactoryEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.formEditor = formEditor;
    }

    public ViewerFilter[] getViewerFilters() {
        return this.viewerFilters;
    }

    public void setViewerFilters(ViewerFilter[] viewerFilters) {
        this.viewerFilters = viewerFilters;
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit tool = managedForm.getToolkit();
        this.createSmooksTreeViewer(tool, managedForm, parent);
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sashForm.setLayoutData((Object)gd);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        SmooksStuffDetailsPageProvider provider = new SmooksStuffDetailsPageProvider();
        detailsPart.setPageProvider((IDetailsPageProvider)provider);
        detailsPart.registerPage(EObject.class, (IDetailsPage)new SmooksStuffPropertyDetailPage((IEditorPart)this.formEditor, (ISmooksModelProvider)this.formEditor));
    }

    protected void refreshSmooksTreeViewer() {
        if (this.smooksTreeViewer.getControl().isDisposed()) {
            return;
        }
        this.smooksTreeViewer.refresh();
    }

    public void setMainSectionTitle(String sectionTitle) {
        this.sectionTitle = sectionTitle;
    }

    public String getMainSectionTitle() {
        return this.sectionTitle;
    }

    public String getMainSectionDescription() {
        return this.sectionDescription;
    }

    public void setMainSectionDescription(String sectionDescription) {
        this.sectionDescription = sectionDescription;
    }

    protected void createSmooksTreeViewer(FormToolkit tool, IManagedForm managedForm, Composite rootMainControl) {
        EObject smooksModel;
        this.configurationSection = tool.createSection(rootMainControl, 384);
        if (this.getMainSectionTitle() != null) {
            this.configurationSection.setText(this.getMainSectionTitle());
        }
        if (this.getMainSectionDescription() != null) {
            this.configurationSection.setDescription(this.getMainSectionDescription());
        }
        this.sectionPart = new SectionPart(this.configurationSection);
        managedForm.addPart((IFormPart)this.sectionPart);
        GridData gd = new GridData(768);
        Composite dataTypeComposite = tool.createComposite((Composite)this.configurationSection);
        this.configurationSection.setClient((Control)dataTypeComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dataTypeComposite.setLayout((Layout)layout);
        Composite tableComposite = tool.createComposite(dataTypeComposite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        tableComposite.setLayout((Layout)fillLayout);
        this.smooksTreeViewer = new TreeViewer(tableComposite, 0);
        this.smooksTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.smooksTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editingDomain.getAdapterFactory()));
        this.smooksTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(this.editingDomain.getAdapterFactory()){

            public String getText(Object object) {
                Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (obj instanceof EObject) {
                    return super.getText(obj);
                }
                return super.getText(object);
            }
        }, SmooksConfigurationActivator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.smooksTreeViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                Object elementB;
                Object elementA = AdapterFactoryEditingDomain.unwrap((Object)a);
                if (elementA == (elementB = AdapterFactoryEditingDomain.unwrap((Object)b))) {
                    return true;
                }
                return elementA == null ? elementB == null : elementA.equals(elementB);
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        });
        if (this.getViewerFilters() != null) {
            this.smooksTreeViewer.setFilters(this.getViewerFilters());
        }
        if ((smooksModel = ((ISmooksModelProvider)this.formEditor).getSmooksModel()) != null) {
            this.setTreeViewerModel(smooksModel);
        }
        this.createMenuForViewer(this.smooksTreeViewer);
        if (this.formEditor.getEditorSite().getActionBarContributor() instanceof ISelectionChangedListener) {
            this.smooksTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.formEditor.getEditorSite().getActionBarContributor());
        }
        this.smooksTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        tableComposite.setBackground(new Color(null, 128, 128, 128));
        gd = new GridData(1808);
        tableComposite.setLayoutData((Object)gd);
        tool.paintBordersFor(tableComposite);
        Composite buttonComposite = tool.createComposite(dataTypeComposite);
        gd = new GridData(1040);
        gd.widthHint = 100;
        buttonComposite.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonComposite.setLayout((Layout)buttonLayout);
        this.addButton = tool.createButton(buttonComposite, Messages.SmooksMasterDetailBlock_AddButtonLabel, 0);
        gd = new GridData(768);
        this.addButton.setLayoutData((Object)gd);
        this.removeButton = tool.createButton(buttonComposite, Messages.SmooksMasterDetailBlock_RemoveButtonlabel, 0);
        gd = new GridData(768);
        this.removeButton.setLayoutData((Object)gd);
        Composite sc = tool.createComposite(buttonComposite);
        gd = new GridData(768);
        gd.heightHint = 40;
        sc.setLayoutData((Object)gd);
        this.upButton = tool.createButton(buttonComposite, Messages.SmooksMasterDetailBlock_UpButtonLabel, 0);
        gd = new GridData(768);
        this.upButton.setLayoutData((Object)gd);
        this.downButton = tool.createButton(buttonComposite, Messages.SmooksMasterDetailBlock_DownButtonLabel, 0);
        gd = new GridData(768);
        this.downButton.setLayoutData((Object)gd);
        gd = new GridData(1040);
        gd.widthHint = 70;
        buttonComposite.setLayoutData((Object)gd);
        this.hookButtons();
    }

    private void setTreeViewerModel(Object smooksModel) {
        boolean seted = false;
        if (smooksModel instanceof DocumentRoot) {
            SmooksResourceListType list = ((DocumentRoot)smooksModel).getSmooksResourceList();
            try {
                this.smooksTreeViewer.setInput((Object)list);
                seted = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!seted) {
            this.smooksTreeViewer.setInput(smooksModel);
        }
    }

    private EObject getTreeViewerInput() {
        EObject smooksModel = ((ISmooksModelProvider)this.formEditor).getSmooksModel();
        if (smooksModel instanceof DocumentRoot) {
            return ((DocumentRoot)smooksModel).getSmooksResourceList();
        }
        return null;
    }

    public List<?> getViewerSelections() {
        IStructuredSelection selections = (IStructuredSelection)this.smooksTreeViewer.getSelection();
        if (selections == null) {
            return null;
        }
        return selections.toList();
    }

    public String getNewSmooksElementTitle() {
        return this.newSmooksElementTitle;
    }

    public void setNewSmooksElementTitle(String newSmooksElementTitle) {
        this.newSmooksElementTitle = newSmooksElementTitle;
    }

    public String getNewSmooksElementDescription() {
        return this.newSmooksElementDescription;
    }

    public void setNewSmooksElementDescription(String newSmooksElementDescription) {
        this.newSmooksElementDescription = newSmooksElementDescription;
    }

    private void hookButtons() {
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                NewSmooksElementWizard wizard = new NewSmooksElementWizard(SmooksMasterDetailBlock.this.editingDomain, SmooksMasterDetailBlock.this.getTreeViewerInput(), SmooksMasterDetailBlock.this.getViewerFilters(), SmooksMasterDetailBlock.this.getNewSmooksElementTitle(), SmooksMasterDetailBlock.this.getNewSmooksElementDescription());
                WizardDialog dialog = new WizardDialog(SmooksMasterDetailBlock.this.formEditor.getSite().getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<?> list = SmooksMasterDetailBlock.this.getViewerSelections();
                CompoundCommand ccommand = new CompoundCommand();
                for (Object object : list) {
                    Command command = DeleteCommand.create((EditingDomain)SmooksMasterDetailBlock.this.editingDomain, object);
                    if (!command.canExecute()) continue;
                    ccommand.append(command);
                }
                SmooksMasterDetailBlock.this.editingDomain.getCommandStack().execute((Command)ccommand);
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<?> list = SmooksMasterDetailBlock.this.getViewerSelections();
                if (list.size() == 1) {
                    Object obj = list.get(0);
                    EObject v = (EObject)AdapterFactoryEditingDomain.unwrap(obj);
                    EObject parent = v.eContainer();
                    int index = parent.eContents().indexOf((Object)v);
                    Command command = MoveCommand.create((EditingDomain)SmooksMasterDetailBlock.this.editingDomain, (Object)parent, null, obj, (int)(index + 1));
                    SmooksMasterDetailBlock.this.editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<?> list = SmooksMasterDetailBlock.this.getViewerSelections();
                if (list.size() == 1) {
                    Object obj = list.get(0);
                    EObject v = (EObject)AdapterFactoryEditingDomain.unwrap(obj);
                    EObject parent = v.eContainer();
                    int index = parent.eContents().indexOf((Object)v);
                    Command command = MoveCommand.create((EditingDomain)SmooksMasterDetailBlock.this.editingDomain, (Object)parent, null, obj, (int)(index - 1));
                    SmooksMasterDetailBlock.this.editingDomain.getCommandStack().execute(command);
                }
            }
        });
    }

    private void createMenuForViewer(TreeViewer smooksTreeViewer2) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(smooksTreeViewer2.getControl());
        smooksTreeViewer2.getControl().setMenu(menu);
    }

    public TreeViewer getSmooksTreeViewer() {
        return this.smooksTreeViewer;
    }

    public void setSmooksTreeViewer(TreeViewer smooksTreeViewer) {
        this.smooksTreeViewer = smooksTreeViewer;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.formEditor.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void setSmooksModel(Object model) {
        if (model != null) {
            this.setTreeViewerModel(model);
        } else {
            this.smooksTreeViewer.setInput(new Object());
        }
    }

    protected void updateButtons(List<?> selections) {
        this.removeButton.setEnabled(true);
        this.upButton.setEnabled(true);
        this.downButton.setEnabled(true);
        List<?> list = this.getViewerSelections();
        if (list.size() == 1) {
            Object obj = list.get(0);
            EObject v = (EObject)AdapterFactoryEditingDomain.unwrap(obj);
            EObject parent = v.eContainer();
            int index = parent.eContents().indexOf((Object)v);
            Command upCommand = MoveCommand.create((EditingDomain)this.editingDomain, (Object)parent, null, obj, (int)(index - 1));
            this.upButton.setEnabled(upCommand.canExecute());
            Command downCommand = MoveCommand.create((EditingDomain)this.editingDomain, (Object)parent, null, obj, (int)(index + 1));
            this.downButton.setEnabled(downCommand.canExecute());
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.sectionPart != null && this.sectionPart.getManagedForm() != null) {
            Object defaultObj;
            Object input;
            Object[] objs = ((IStructuredSelection)event.getSelection()).toArray();
            ArrayList<Object> objList = new ArrayList<Object>();
            int i = 0;
            while (i < objs.length) {
                Object obj = objs[i];
                obj = AdapterFactoryEditingDomain.unwrap((Object)obj);
                objList.add(obj);
                ++i;
            }
            if (objList.isEmpty() && (input = this.smooksTreeViewer.getInput()) instanceof EObject && (defaultObj = this.getEmptyDefaultSelection((EObject)input)) != null) {
                objList.add(defaultObj);
            }
            if (objList.isEmpty()) {
                this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)this.sectionPart, event.getSelection());
            } else {
                this.sectionPart.getManagedForm().fireSelectionChanged((IFormPart)this.sectionPart, (ISelection)new StructuredSelection(objList.toArray()));
            }
            this.updateButtons(objList);
        }
        if (this.formEditor instanceof ISelectionProvider) {
            ((ISelectionProvider)this.formEditor).setSelection(event.getSelection());
        }
    }

    protected Object getEmptyDefaultSelection(EObject smooksTreeViewerInput) {
        return null;
    }
}

