/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.smooks.configuration.editors.CompoundStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.CompoundStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.editors.ExtentionInputContentProvider;
import org.jboss.tools.smooks.configuration.editors.ExtentionInputLabelProvider;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.configuration.editors.Messages;
import org.jboss.tools.smooks.configuration.editors.ModelPanelCreator;
import org.jboss.tools.smooks.configuration.editors.OnlyReaderViewerFilter;
import org.jboss.tools.smooks.configuration.editors.SelectorCreationDialog;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.StructuredDataSelectionWizardDailog;
import org.jboss.tools.smooks.configuration.editors.input.InputType;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.wizard.StructuredDataSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.wizard.ViewerInitorStore;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.ISourceSynchronizeListener;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.csv12.Csv12Package;
import org.jboss.tools.smooks.model.edi12.EDI12Reader;
import org.jboss.tools.smooks.model.edi12.Edi12Package;
import org.jboss.tools.smooks.model.json12.Json12Package;
import org.jboss.tools.smooks.model.json12.Json12Reader;
import org.jboss.tools.smooks.model.smooks.AbstractReader;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.ParamsType;
import org.jboss.tools.smooks.model.smooks.ReaderType;
import org.jboss.tools.smooks.model.smooks.SmooksFactory;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.milyn.SmooksException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksReaderFormPage
extends FormPage
implements ISmooksModelValidateListener,
ISourceSynchronizeListener,
CommandStackListener {
    private CheckboxTableViewer inputDataViewer;
    private TreeViewer inputModelViewer;
    private Combo readerCombo;
    private List<Object> readerTypeList = new ArrayList<Object>();
    private Composite readerConfigComposite;
    private ModelPanelCreator modelPanelCreator;
    protected boolean lockCheck = false;
    private Button removeInputDataButton;
    private Button addInputDataButton;
    private ScrolledPageBook scrolledPageBook;

    public void commandStackChanged(EventObject event) {
        final Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (mostRecentCommand != null) {
                    Command rawCommand = mostRecentCommand;
                    while (rawCommand instanceof CommandWrapper) {
                        rawCommand = ((CommandWrapper)rawCommand).getCommand();
                    }
                    if (rawCommand instanceof CompoundCommand) {
                        List command = ((CompoundCommand)rawCommand).getCommandList();
                        for (Command command2 : command) {
                            while (command2 instanceof CommandWrapper) {
                                command2 = ((CommandWrapper)command2).getCommand();
                            }
                            if (!SmooksReaderFormPage.this.handleInputParamChange(command2)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        SmooksReaderFormPage.this.handleInputParamChange(rawCommand);
                    }
                }
            }
        });
    }

    public SmooksReaderFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public SmooksReaderFormPage(String id, String title) {
        super(id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("");
        Composite leftComposite = toolkit.createComposite(form.getBody());
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        leftComposite.setLayoutData((Object)gd);
        Composite rightComposite = toolkit.createComposite(form.getBody());
        gd = new GridData(1808);
        rightComposite.setLayoutData((Object)gd);
        GridLayout lgl = new GridLayout();
        lgl.marginWidth = 0;
        lgl.marginHeight = 0;
        leftComposite.setLayout((Layout)lgl);
        GridLayout rgl = new GridLayout();
        rgl.marginWidth = 0;
        rgl.marginHeight = 0;
        rightComposite.setLayout((Layout)rgl);
        this.createReaderSection(toolkit, leftComposite);
        this.createInputDataSection(toolkit, rightComposite);
        this.createReaderConfigSection(toolkit, leftComposite);
        this.createInputModelViewerSection(toolkit, rightComposite);
        this.handleReaderCombo(this.readerCombo);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 13;
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 20;
        gridLayout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)gridLayout);
        this.refreshInputDataButtons();
    }

    private void createInputModelViewerSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 322);
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        section.setText(Messages.SmooksReaderFormPage_InputSectionTitle);
        FillLayout flayout = new FillLayout();
        section.setLayout((Layout)flayout);
        Composite mainContainer = toolkit.createComposite((Composite)section);
        GridLayout gl = new GridLayout();
        mainContainer.setLayout((Layout)gl);
        section.setClient((Control)mainContainer);
        Hyperlink refreshLink = toolkit.createHyperlink(mainContainer, Messages.SmooksReaderFormPage_RefreshLinkLabel, 0);
        refreshLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                SmooksReaderFormPage.this.refreshInputModelView();
            }
        });
        Composite viewerContainer = toolkit.createComposite(mainContainer);
        gd = new GridData(1808);
        viewerContainer.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        viewerContainer.setBackground(GraphicsConstants.BORDER_CORLOR);
        viewerContainer.setLayout((Layout)fillLayout);
        this.inputModelViewer = new TreeViewer(viewerContainer, 0);
        this.inputModelViewer.setContentProvider((IContentProvider)new CompoundStructuredDataContentProvider());
        this.inputModelViewer.setLabelProvider((IBaseLabelProvider)new CompoundStructuredDataLabelProvider());
        this.inputModelViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this.inputModelViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.refreshInputModelView();
    }

    protected List<Object> generateInputData() {
        EObject obj = ((SmooksMultiFormEditor)this.getEditor()).getSmooksModel();
        SmooksResourceListType resourceList = null;
        if (obj instanceof DocumentRoot) {
            resourceList = ((DocumentRoot)obj).getSmooksResourceList();
        }
        return SelectorCreationDialog.generateInputData(resourceList);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.getEditor() != null && this.getEditor() instanceof ISmooksModelProvider) {
            this.handleCommandStack(((ISmooksModelProvider)this.getEditor()).getEditingDomain().getCommandStack());
        }
    }

    protected boolean handleInputParamChange(Command command) {
        Collection affectedObjects = command.getAffectedObjects();
        boolean refreshInputModel = false;
        for (Object object : affectedObjects) {
            if (object instanceof AbstractReader) {
                refreshInputModel = true;
                break;
            }
            if (object instanceof ParamType && SmooksUIUtils.isInputParamType((ParamType)object)) {
                refreshInputModel = true;
                break;
            }
            Collection deletedObjs = null;
            if (command instanceof DeleteCommand) {
                deletedObjs = ((DeleteCommand)command).getCollection();
            }
            if (command instanceof RemoveCommand) {
                deletedObjs = ((RemoveCommand)command).getCollection();
            }
            if (deletedObjs != null) {
                for (Object object2 : deletedObjs) {
                    if (object2 instanceof AbstractReader) {
                        refreshInputModel = true;
                        break;
                    }
                    if (!(object2 instanceof ParamType) || !SmooksUIUtils.isInputParamType((ParamType)object2)) continue;
                    refreshInputModel = true;
                    break;
                }
            }
            if (refreshInputModel) break;
        }
        if (refreshInputModel) {
            this.refreshInputModelView();
        }
        return refreshInputModel;
    }

    private void handleCommandStack(CommandStack commandStack) {
        commandStack.addCommandStackListener((CommandStackListener)this);
    }

    public void dispose() {
        if (this.getEditor() != null && this.getEditor() instanceof ISmooksModelProvider) {
            ((ISmooksModelProvider)this.getEditor()).getEditingDomain().getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        super.dispose();
    }

    private void createReaderConfigSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 322);
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        section.setText(Messages.SmooksReaderFormPage_InputConfigurationSectionTitle);
        section.setDescription(Messages.SmooksReaderFormPage_InputConfigurationSectionDes);
        FillLayout flayout = new FillLayout();
        section.setLayout((Layout)flayout);
        this.scrolledPageBook = new ScrolledPageBook((Composite)section);
        this.scrolledPageBook.setBackground(toolkit.getColors().getBackground());
        section.setClient((Control)this.scrolledPageBook);
        this.readerConfigComposite = this.scrolledPageBook.createPage((Object)this.scrolledPageBook);
        this.scrolledPageBook.showPage((Object)this.scrolledPageBook);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.readerConfigComposite.setLayout((Layout)gl);
        this.initReaderConfigSection();
    }

    private void createReaderSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 322);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        section.setLayoutData((Object)gd);
        section.setText(Messages.SmooksReaderFormPage_InputTypeSectionTitle);
        FillLayout flayout = new FillLayout();
        section.setLayout((Layout)flayout);
        Composite mainComposite = toolkit.createComposite((Composite)section);
        section.setClient((Control)mainComposite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        toolkit.createLabel(mainComposite, Messages.SmooksReaderFormPage_InputTypeLabel);
        this.readerCombo = new Combo(mainComposite, 8);
        gd = new GridData(768);
        this.readerCombo.setLayoutData((Object)gd);
        toolkit.createLabel(mainComposite, " ");
        this.bindingReaderCombo();
        this.initReaderCombo();
        gd = new GridData(768);
        this.readerCombo.setLayoutData((Object)gd);
        toolkit.paintBordersFor(mainComposite);
    }

    private void initReaderConfigSection() {
        Object reader = this.getCurrentReaderModel();
        ISmooksModelProvider provider = this.getSmooksModelProvider();
        if (provider == null) {
            return;
        }
        String type = provider.getInputType();
        if (reader instanceof EObject && type != null) {
            SmooksResourceListType list = this.getSmooksConfigResourceList();
            this.createReaderPanel((EObject)list.getAbstractReader().get(0));
        } else {
            this.disposeCompositeControls(this.readerConfigComposite, null);
            this.createSimpleReaderPanel(reader);
        }
    }

    private void selectCorrectReaderItem(Object reader) {
        int i = 0;
        while (i < this.readerTypeList.size()) {
            Object r = this.readerTypeList.get(i);
            if (r instanceof EObject) {
                if (CSV12Reader.class.isInstance(reader) && CSV12Reader.class.isInstance(r)) {
                    this.readerCombo.select(i);
                    break;
                }
                if (EDI12Reader.class.isInstance(reader) && EDI12Reader.class.isInstance(r)) {
                    this.readerCombo.select(i);
                    break;
                }
                if (Json12Reader.class.isInstance(reader) && Json12Reader.class.isInstance(r)) {
                    this.readerCombo.select(i);
                    break;
                }
                if (ReaderType.class.isInstance(reader) && ReaderType.class.isInstance(r)) {
                    this.readerCombo.select(i);
                    break;
                }
            }
            ++i;
        }
    }

    private String getCurrentReaderType() {
        Object reader = this.getCurrentReaderModel();
        return this.getReaderType(reader);
    }

    private void initReaderCombo() {
        AbstractReader reader;
        if (this.readerCombo == null) {
            return;
        }
        SmooksResourceListType rlist = this.getSmooksConfigResourceList();
        if (rlist == null) {
            this.readerCombo.select(-1);
            return;
        }
        ISmooksModelProvider modelProvider = this.getSmooksModelProvider();
        String inputType = modelProvider.getInputType();
        if (inputType == null && rlist.getAbstractReader().isEmpty()) {
            this.readerCombo.select(0);
            return;
        }
        if ("input.xml".equals(inputType)) {
            this.readerCombo.select(1);
        }
        if ("input.java".equals(inputType)) {
            this.readerCombo.select(2);
        }
        if ("input.xsd".equals(inputType)) {
            this.readerCombo.select(3);
        }
        if ("input.csv".equals(inputType) && !rlist.getAbstractReader().isEmpty() && CSV12Reader.class.isInstance(reader = (AbstractReader)rlist.getAbstractReader().get(0))) {
            this.selectCorrectReaderItem(reader);
        }
        if ("input.edi".equals(inputType) && !rlist.getAbstractReader().isEmpty() && EDI12Reader.class.isInstance(reader = (AbstractReader)rlist.getAbstractReader().get(0))) {
            this.selectCorrectReaderItem(reader);
        }
        if ("input.json".equals(inputType) && !rlist.getAbstractReader().isEmpty() && Json12Reader.class.isInstance(reader = (AbstractReader)rlist.getAbstractReader().get(0))) {
            this.selectCorrectReaderItem(reader);
        }
        if ("input.custom".equals(inputType) && !rlist.getAbstractReader().isEmpty() && ReaderType.class.isInstance(reader = (AbstractReader)rlist.getAbstractReader().get(0))) {
            this.selectCorrectReaderItem(reader);
        }
    }

    private void handleReaderCombo(Combo combo) {
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object newreader = SmooksReaderFormPage.this.getCurrentReaderModel();
                if (newreader == null) {
                    return;
                }
                SmooksReaderFormPage.this.readerChanged(newreader);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Object createReaderEntry(Object reader, boolean clone) {
        if (clone) {
            reader = EcoreUtil.copy((EObject)((EObject)reader));
        }
        if (reader instanceof CSV12Reader) {
            return FeatureMapUtil.createEntry((EStructuralFeature)Csv12Package.Literals.CSV12_DOCUMENT_ROOT__READER, (Object)reader);
        }
        if (reader instanceof EDI12Reader) {
            return FeatureMapUtil.createEntry((EStructuralFeature)Edi12Package.Literals.EDI12_DOCUMENT_ROOT__READER, (Object)reader);
        }
        if (reader instanceof Json12Reader) {
            return FeatureMapUtil.createEntry((EStructuralFeature)Json12Package.Literals.JSON12_DOCUMENT_ROOT__READER, (Object)reader);
        }
        if (reader instanceof ReaderType) {
            return FeatureMapUtil.createEntry((EStructuralFeature)SmooksPackage.Literals.DOCUMENT_ROOT__READER, (Object)reader);
        }
        return null;
    }

    private Command createRemoveReaderCommand() {
        SmooksResourceListType rlist = this.getSmooksConfigResourceList();
        EList readerList = rlist.getAbstractReader();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (AbstractReader abstractReader : readerList) {
            Command removeCommand;
            Object readerEntry = this.createReaderEntry(abstractReader, false);
            if (readerEntry == null || !(removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)rlist, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_READER_GROUP, (Object)readerEntry)).canExecute()) continue;
            compoundCommand.append(removeCommand);
        }
        if (compoundCommand.isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    private String getReaderType(Object reader) {
        if (reader instanceof XMLReader) {
            return "input.xml";
        }
        if (reader instanceof JavaReader) {
            return "input.java";
        }
        if (reader instanceof XSDReader) {
            return "input.xsd";
        }
        if (reader instanceof EObject) {
            EObject obj = (EObject)reader;
            if (obj instanceof CSV12Reader) {
                return "input.csv";
            }
            if (obj instanceof EDI12Reader) {
                return "input.edi";
            }
            if (obj instanceof Json12Reader) {
                return "input.json";
            }
            if (obj instanceof ReaderType) {
                return "input.custom";
            }
        }
        return null;
    }

    private void refreshInputDataButtons() {
        this.addInputDataButton.setEnabled(true);
        this.removeInputDataButton.setEnabled(true);
        String inputType = this.getSmooksModelProvider().getInputType();
        if (inputType == null || inputType.trim().equals("")) {
            this.addInputDataButton.setEnabled(false);
            this.removeInputDataButton.setEnabled(false);
        }
    }

    private void readerChanged(Object reader) {
        Command removeCommand;
        ParamType param;
        String type = this.getCurrentReaderType();
        String oldType = this.getSmooksModelProvider().getInputType();
        if (type == null && oldType == null) {
            return;
        }
        if (type != null && type.equals(oldType)) {
            return;
        }
        if (oldType != null && oldType.equals(type)) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        ParamsType params = this.getSmooksConfigResourceList().getParams();
        if (params == null) {
            params = SmooksFactory.eINSTANCE.createParamsType();
            Command addparamsCommand = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getSmooksConfigResourceList(), (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__PARAMS, (Object)params);
            if (addparamsCommand.canExecute()) {
                compoundCommand.append(addparamsCommand);
            }
        }
        if ((param = SmooksUIUtils.getInputTypeParam(this.getSmooksConfigResourceList())) == null) {
            param = SmooksFactory.eINSTANCE.createParamType();
            param.setName("inputType");
            param.setStringValue(type);
            Command addparamc = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)params, (Object)SmooksPackage.Literals.PARAMS_TYPE__PARAM, (Object)param);
            if (addparamc.canExecute()) {
                compoundCommand.append(addparamc);
            }
        } else {
            Object removeValue;
            Command addCommand = null;
            if (type != null) {
                addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)param, (Object)XMLTypePackage.Literals.ANY_TYPE__MIXED, (Object)FeatureMapUtil.createEntry((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, (Object)type));
            }
            if ((removeValue = param.getMixed().get((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, true)) != null && removeValue instanceof Collection) {
                ArrayList<FeatureMap.Entry> rList = new ArrayList<FeatureMap.Entry>();
                for (Object string : (Collection)removeValue) {
                    rList.add(FeatureMapUtil.createEntry((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, string));
                }
                Command cc = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)param, null, rList);
                if (cc != null && cc.canExecute()) {
                    compoundCommand.append(cc);
                }
            }
            if (addCommand != null && addCommand.canExecute()) {
                compoundCommand.append(addCommand);
            }
        }
        if ((removeCommand = this.createRemoveReaderCommand()) != null && removeCommand.canExecute()) {
            compoundCommand.append(removeCommand);
        }
        if (this.readerConfigComposite != null) {
            this.disposeCompositeControls(this.readerConfigComposite, null);
            this.scrolledPageBook.reflow(true);
        }
        if (reader instanceof EObject) {
            Object obj = (EObject)reader;
            obj = AdapterFactoryEditingDomain.unwrap((Object)obj);
            Command command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getSmooksConfigResourceList(), (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_READER_GROUP, (Object)this.createReaderEntry(obj, false));
            if (command.canExecute()) {
                compoundCommand.append(command);
            }
        } else {
            this.createSimpleReaderPanel(reader);
        }
        this.deactiveAllInputFile(compoundCommand);
        if (!compoundCommand.isEmpty() && compoundCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
            if (reader != null && reader instanceof EObject) {
                this.createReaderPanel((EObject)reader);
            }
        }
        if (this.inputDataViewer != null) {
            this.inputDataViewer.refresh();
        }
        this.refreshInputModelView();
        this.refreshInputDataButtons();
    }

    private void deactiveAllInputFile(CompoundCommand command) {
        Object viewerInput = this.inputDataViewer.getInput();
        if (viewerInput != null && viewerInput instanceof List) {
            List inputList = (List)viewerInput;
            for (InputType inputType : inputList) {
                this.setInputDataActiveStatus(false, inputType, command);
            }
        }
    }

    private void createSimpleReaderPanel(Object reader) {
        Label formText = this.getManagedForm().getToolkit().createLabel(this.readerConfigComposite, "");
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        gd.horizontalSpan = 2;
        formText.setLayoutData((Object)gd);
        if (reader instanceof XMLReader || reader instanceof JavaReader || reader instanceof XSDReader) {
            formText.setText(Messages.SmooksReaderFormPage_Warning_Specify_Sample_Data);
        }
        if (reader instanceof NullReader) {
            formText.setText(Messages.SmooksReaderFormPage_Warning_Specify_Input_Type);
        }
        this.readerConfigComposite.layout();
        this.scrolledPageBook.reflow(false);
    }

    private void createReaderPanel(EObject reader) {
        this.disposeCompositeControls(this.readerConfigComposite, null);
        try {
            ModelPanelCreator modelPanelCreator = this.getModelPanelCreator();
            IItemPropertySource ps = (IItemPropertySource)this.getEditingDomain().getAdapterFactory().adapt((Notifier)reader, IItemPropertySource.class);
            modelPanelCreator.createModelPanel(reader, this.getManagedForm().getToolkit(), this.readerConfigComposite, ps, (ISmooksModelProvider)this.getEditor(), (IEditorPart)this.getEditor());
            Composite parentPage = this.readerConfigComposite.getParent();
            if (parentPage != null) {
                parentPage.layout();
            }
            this.scrolledPageBook.reflow(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ModelPanelCreator getModelPanelCreator() {
        if (this.modelPanelCreator == null) {
            this.modelPanelCreator = new ModelPanelCreator();
        }
        return this.modelPanelCreator;
    }

    private void bindingReaderCombo() {
        if (this.readerCombo == null) {
            return;
        }
        this.readerCombo.removeAll();
        this.readerTypeList.clear();
        this.readerCombo.add(Messages.SmooksReaderFormPage_NoInputComboText);
        this.readerTypeList.add(new NullReader());
        this.readerCombo.add(Messages.SmooksReaderFormPage_XMLReaderComboText);
        this.readerTypeList.add(new XMLReader());
        this.readerCombo.add(Messages.SmooksReaderFormPage_JavaReaderComboText);
        this.readerTypeList.add(new JavaReader());
        this.readerCombo.add(Messages.SmooksReaderFormPage_XSDReaderComboText);
        this.readerTypeList.add(new XSDReader());
        SmooksResourceListType resourceList = this.getSmooksConfigResourceList();
        if (resourceList == null) {
            return;
        }
        AdapterFactoryEditingDomain editDomain = this.getEditingDomain();
        IEditingDomainItemProvider provider = (IEditingDomainItemProvider)editDomain.getAdapterFactory().adapt((Notifier)resourceList, IEditingDomainItemProvider.class);
        Collection collections = provider.getNewChildDescriptors((Object)resourceList, (EditingDomain)editDomain, null);
        String customReaderText = null;
        Object customReaderInstance = null;
        ISmooksModelProvider modelProvider = this.getSmooksModelProvider();
        if (modelProvider != null) {
            String version = modelProvider.getPlatformVersion();
            OnlyReaderViewerFilter filter = new OnlyReaderViewerFilter();
            for (Object object : collections) {
                if (!(object instanceof CommandParameter)) continue;
                Object value = ((CommandParameter)object).getValue();
                if (!filter.select(null, null, value = AdapterFactoryEditingDomain.unwrap((Object)value)) || SmooksUIUtils.isUnSupportElement(version, (EObject)value)) continue;
                IItemLabelProvider lp = (IItemLabelProvider)editDomain.getAdapterFactory().adapt(value, IItemLabelProvider.class);
                String text = lp.getText(value);
                if (ReaderType.class.isInstance(value)) {
                    customReaderText = text;
                    customReaderInstance = value;
                    continue;
                }
                this.readerCombo.add(text);
                this.readerTypeList.add(value);
            }
        }
        if (customReaderInstance != null && customReaderText != null) {
            this.readerCombo.add(customReaderText);
            this.readerTypeList.add(customReaderInstance);
        }
    }

    private void setInputDataActiveStatus(boolean active, InputType inputType, CompoundCommand command) {
        inputType.setActived(active);
        ParamType param = SmooksUIUtils.getInputTypeAssociatedParamType(inputType, this.getSmooksConfigResourceList());
        if (param != null) {
            String value = "input.type.actived";
            if (!active) {
                value = "input.type.deactived";
            }
            Command c = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)param, (Object)SmooksPackage.Literals.PARAM_TYPE__TYPE, (Object)value);
            if (command != null) {
                command.append(c);
            } else {
                this.getEditingDomain().getCommandStack().execute(c);
            }
        }
    }

    protected void createInputDataSection(FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 450);
        GridData gd = new GridData(768);
        section.setLayoutData((Object)gd);
        section.setText(Messages.SmooksReaderFormPage_InputDataSectionTitle);
        section.setDescription(Messages.SmooksReaderFormPage_InputDataSectionDes);
        FillLayout flayout = new FillLayout();
        section.setLayout((Layout)flayout);
        Composite mainComposite = toolkit.createComposite((Composite)section, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        section.setClient((Control)mainComposite);
        Composite tableComposite = toolkit.createComposite(mainComposite, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 1;
        fillLayout.marginWidth = 1;
        gd = new GridData(1808);
        gd.heightHint = 70;
        tableComposite.setLayoutData((Object)gd);
        tableComposite.setBackground(GraphicsConstants.BORDER_CORLOR);
        tableComposite.setLayout((Layout)fillLayout);
        this.inputDataViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)65538);
        this.inputDataViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return SmooksReaderFormPage.this.isIncorrectInputType((InputType)element);
            }

            public boolean isChecked(Object element) {
                if (element instanceof InputType) {
                    return ((InputType)element).isActived();
                }
                return false;
            }
        });
        this.inputDataViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (SmooksReaderFormPage.this.lockCheck) {
                    return;
                }
                boolean checked = event.getChecked();
                InputType inputType = (InputType)event.getElement();
                if (SmooksReaderFormPage.this.isIncorrectInputType(inputType)) {
                    SmooksReaderFormPage.this.lockCheck = true;
                    SmooksReaderFormPage.this.inputDataViewer.setChecked((Object)inputType, false);
                    SmooksReaderFormPage.this.lockCheck = false;
                    return;
                }
                CompoundCommand compoundCommand = new CompoundCommand();
                if (checked) {
                    ParamType param = SmooksUIUtils.getInputTypeAssociatedParamType(inputType, SmooksReaderFormPage.this.getSmooksConfigResourceList());
                    if (param != null) {
                        inputType.setActived(checked);
                        String value = "input.type.actived";
                        Command c = SetCommand.create((EditingDomain)SmooksReaderFormPage.this.getEditingDomain(), (Object)param, (Object)SmooksPackage.Literals.PARAM_TYPE__TYPE, (Object)value);
                        if (c.canExecute()) {
                            compoundCommand.append(c);
                        }
                    }
                    Object[] checkedObjects = SmooksReaderFormPage.this.inputDataViewer.getCheckedElements();
                    int i = 0;
                    while (i < checkedObjects.length) {
                        InputType type = (InputType)checkedObjects[i];
                        if (type != inputType) {
                            type.setActived(!checked);
                            ParamType param1 = SmooksUIUtils.getInputTypeAssociatedParamType(type, SmooksReaderFormPage.this.getSmooksConfigResourceList());
                            if (param1 != null) {
                                String value1 = "input.type.deactived";
                                Command c1 = SetCommand.create((EditingDomain)SmooksReaderFormPage.this.getEditingDomain(), (Object)param1, (Object)SmooksPackage.Literals.PARAM_TYPE__TYPE, (Object)value1);
                                compoundCommand.append(c1);
                            }
                            SmooksReaderFormPage.this.lockCheck = true;
                            SmooksReaderFormPage.this.inputDataViewer.setChecked((Object)type, false);
                            SmooksReaderFormPage.this.lockCheck = false;
                        }
                        ++i;
                    }
                } else {
                    ParamType param = SmooksUIUtils.getInputTypeAssociatedParamType(inputType, SmooksReaderFormPage.this.getSmooksConfigResourceList());
                    if (param != null) {
                        String value = "input.type.deactived";
                        Command c = SetCommand.create((EditingDomain)SmooksReaderFormPage.this.getEditingDomain(), (Object)param, (Object)SmooksPackage.Literals.PARAM_TYPE__TYPE, (Object)value);
                        compoundCommand.append(c);
                    }
                }
                try {
                    SmooksReaderFormPage.this.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
                }
                catch (Exception exception) {}
            }
        });
        this.inputDataViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block14: {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof InputType) {
                        String type = ((InputType)element).getType();
                        String filePath = ((InputType)element).getPath();
                        if (type != null && filePath != null) {
                            if ("input.java".equals(type)) {
                                IFile file = ((IFileEditorInput)SmooksReaderFormPage.this.getEditorInput()).getFile();
                                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                                if (javaProject != null) {
                                    try {
                                        IType result;
                                        if (filePath.endsWith("[]")) {
                                            filePath = filePath.substring(0, filePath.length() - 2);
                                        }
                                        if ((result = javaProject.findType(filePath)) != null) {
                                            JavaUI.openInEditor((IJavaElement)result);
                                            break block14;
                                        }
                                        MessageDialog.openError((Shell)SmooksReaderFormPage.this.getSite().getWorkbenchWindow().getShell(), (String)Messages.SmooksReaderFormPage_CantFindTypeErrorTitle, (String)("Can't find type \"" + filePath + "\" in \"" + javaProject.getProject().getName() + "\" project."));
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                try {
                                    IFileStore fileStore;
                                    IFileInfo fetchInfo;
                                    filePath = SmooksUIUtils.parseFilePath(filePath);
                                    if (filePath != null && !(fetchInfo = (fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(filePath))).fetchInfo()).isDirectory() && fetchInfo.exists()) {
                                        IWorkbenchWindow window = SmooksReaderFormPage.this.getSite().getWorkbenchWindow();
                                        IWorkbenchPage page = window.getActivePage();
                                        try {
                                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                                        }
                                        catch (PartInitException partInitException) {
                                            MessageDialog.open((int)1, (Shell)window.getShell(), (String)Messages.SmooksReaderFormPage_OpenFileErrorTitle, (String)("Can't open the file : '" + filePath + "'"), (int)0x10000000);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    MessageDialog.open((int)1, (Shell)SmooksReaderFormPage.this.getSite().getWorkbenchWindow().getShell(), (String)Messages.SmooksReaderFormPage_OpenFileErrorTitle, (String)("Can't open the file : '" + filePath + "'"), (int)0x10000000);
                                }
                            }
                        }
                    }
                }
            }
        });
        TableColumn header = new TableColumn(this.inputDataViewer.getTable(), 0);
        header.setText(Messages.SmooksReaderFormPage_TypeColumnText);
        header.setWidth(100);
        TableColumn pathColumn = new TableColumn(this.inputDataViewer.getTable(), 0);
        pathColumn.setText(Messages.SmooksReaderFormPage_PathColumnText);
        pathColumn.setWidth(300);
        this.inputDataViewer.setContentProvider((IContentProvider)new ExtentionInputContentProvider());
        this.inputDataViewer.setLabelProvider((IBaseLabelProvider)new InputDataViewerLabelProvider());
        this.inputDataViewer.getTable().setHeaderVisible(true);
        this.inputDataViewer.getTable().setLinesVisible(true);
        ISmooksModelProvider provider = this.getSmooksModelProvider();
        if (provider != null) {
            this.inputDataViewer.setInput(SmooksUIUtils.getInputTypeList(this.getSmooksConfigResourceList()));
        }
        Composite buttonComposite = toolkit.createComposite(mainComposite, 0);
        gd = new GridData(1040);
        buttonComposite.setLayoutData((Object)gd);
        GridLayout l = new GridLayout();
        buttonComposite.setLayout((Layout)l);
        this.addInputDataButton = toolkit.createButton(buttonComposite, Messages.SmooksReaderFormPage_AddButtonLabel, 0x800000);
        gd = new GridData(768);
        this.addInputDataButton.setLayoutData((Object)gd);
        this.addInputDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmooksReaderFormPage.this.showInputDataWizard();
            }
        });
        this.removeInputDataButton = toolkit.createButton(buttonComposite, Messages.SmooksReaderFormPage_DeleteButtonLabel, 0x800000);
        gd = new GridData(768);
        this.removeInputDataButton.setLayoutData((Object)gd);
        this.removeInputDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SmooksReaderFormPage.this.inputDataViewer.getSelection();
                if (selection != null) {
                    List inputs = selection.toList();
                    ISmooksModelProvider smooksModelProvider = SmooksReaderFormPage.this.getSmooksModelProvider();
                    for (InputType input : inputs) {
                        SmooksUIUtils.removeInputType(input, smooksModelProvider);
                    }
                    if (!inputs.isEmpty()) {
                        List viewerInput = (List)SmooksReaderFormPage.this.inputDataViewer.getInput();
                        viewerInput.removeAll(inputs);
                        if (SmooksReaderFormPage.this.inputDataViewer != null) {
                            SmooksReaderFormPage.this.inputDataViewer.refresh();
                        }
                    }
                }
            }
        });
    }

    protected ISmooksModelProvider getSmooksModelProvider() {
        return (ISmooksModelProvider)this.getEditor();
    }

    protected AdapterFactoryEditingDomain getEditingDomain() {
        AdapterFactoryEditingDomain editDomain = (AdapterFactoryEditingDomain)((SmooksMultiFormEditor)this.getEditor()).getEditingDomain();
        return editDomain;
    }

    protected SmooksResourceListType getSmooksConfigResourceList() {
        EObject doc = ((SmooksMultiFormEditor)this.getEditor()).getSmooksModel();
        if (doc instanceof DocumentRoot) {
            return ((DocumentRoot)doc).getSmooksResourceList();
        }
        return null;
    }

    protected void showInputDataWizard() {
        WizardDialog dialog;
        Object wizard;
        CompoundCommand compoundCommand = new CompoundCommand();
        String inputType = this.getSmooksModelProvider().getInputType();
        List<InputType> inputTypes = null;
        if (inputType == null || "input.custom".equals(inputType) || inputType.trim().equals("")) {
            wizard = new StructuredDataSelectionWizard();
            ((StructuredDataSelectionWizard)((Object)wizard)).setInput(this.getEditorInput());
            ((StructuredDataSelectionWizard)((Object)wizard)).setSite(this.getEditorSite());
            wizard.setForcePreviousAndNextButtons(true);
            dialog = new StructuredDataSelectionWizardDailog(this.getEditorSite().getShell(), (IWizard)wizard);
            if (dialog.show() == 0) {
                String type = dialog.getType();
                String path = dialog.getPath();
                Properties pros = dialog.getProperties();
                inputTypes = SmooksUIUtils.recordInputDataInfomation((EditingDomain)this.getEditingDomain(), this.getSmooksConfigResourceList().getParams(), type, path, pros, compoundCommand);
            }
        } else {
            wizard = ViewerInitorStore.getInstance().getStructuredDataCreationWizard(inputType);
            dialog = new WizardDialog(this.getEditorSite().getShell(), (IWizard)wizard);
            wizard.init(this.getEditorSite(), this.getEditorInput());
            if (dialog.open() == 0) {
                String path = wizard.getStructuredDataSourcePath();
                Properties pros = wizard.getProperties();
                inputTypes = SmooksUIUtils.recordInputDataInfomation((EditingDomain)this.getEditingDomain(), this.getSmooksConfigResourceList().getParams(), inputType, path, pros, compoundCommand);
            }
        }
        if (inputTypes != null && !inputTypes.isEmpty()) {
            InputType addedInputType = (InputType)inputTypes.get(0);
            Object obj = this.inputDataViewer.getInput();
            if (obj != null && obj instanceof List) {
                ((List)obj).add(addedInputType);
            }
            this.deactiveAllInputFile(compoundCommand);
            if (!inputType.equals("input.custom")) {
                addedInputType.setActived(true);
                ParamType param = addedInputType.getRelatedParameter();
                if (param != null) {
                    String value = "input.type.actived";
                    Command c = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)param, (Object)SmooksPackage.Literals.PARAM_TYPE__TYPE, (Object)value);
                    if (c.canExecute()) {
                        compoundCommand.append(c);
                    }
                }
            }
            if (!compoundCommand.isEmpty()) {
                this.getSmooksModelProvider().getEditingDomain().getCommandStack().execute((Command)compoundCommand);
            }
            if (this.inputDataViewer != null) {
                this.inputDataViewer.refresh();
            }
        }
    }

    private void refreshInputModelView() {
        if (this.getManagedForm() != null) {
            this.getManagedForm().getMessageManager().removeAllMessages();
        }
        if (this.inputModelViewer != null) {
            Throwable t;
            List<Object> input = this.generateInputData();
            try {
                this.inputModelViewer.setInput(input);
                SmooksUIUtils.expandSelectorViewer(input, this.inputModelViewer);
            }
            catch (Throwable throwable) {}
            if ((input == null || input.isEmpty()) && (t = SelectorCreationDialog.getCurrentException()) != null && this.getManagedForm() != null) {
                if (t instanceof SmooksException && t.getCause() != null) {
                    t = t.getCause();
                }
                this.getManagedForm().getMessageManager().addMessage((Object)Messages.SmooksReaderFormPage_Input_Error, String.valueOf(Messages.SmooksReaderFormPage_Error_Creating_Input_Model) + t.getMessage() + "\"", null, 3);
            }
        }
    }

    public void inputTypeChanged() {
        if (this.inputDataViewer != null) {
            this.inputDataViewer.refresh();
        }
        this.refreshInputModelView();
    }

    protected void disposeCompositeControls(Composite composite, Control[] ignoreControl) {
        if (composite != null) {
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (ignoreControl != null) {
                    int j = 0;
                    while (j < ignoreControl.length) {
                        if (child == ignoreControl[j]) {
                            // empty if block
                        }
                        ++j;
                    }
                }
                child.dispose();
                child = null;
                ++i;
            }
        }
    }

    private Object getCurrentReaderModel() {
        if (this.readerCombo == null || this.readerCombo.isDisposed()) {
            return null;
        }
        int index = this.readerCombo.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return this.readerTypeList.get(index);
    }

    @Override
    public void sourceChange(Object model) {
        this.bindingReaderCombo();
        this.initReaderCombo();
        this.initReaderConfigSection();
        if (this.inputDataViewer != null) {
            this.inputDataViewer.setInput(SmooksUIUtils.getInputTypeList(this.getSmooksConfigResourceList()));
            this.inputDataViewer.refresh();
        }
        this.refreshInputModelView();
    }

    public void graphPropertyChange(EStructuralFeature featre, Object value) {
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        if (diagnosticResult == null) {
            return;
        }
        Object model = this.getCurrentReaderModel();
        if (model == null) {
            return;
        }
        if (model instanceof EObject) {
            this.getModelPanelCreator().markPropertyUI(diagnosticResult, (EObject)model);
        }
    }

    @Override
    public void validateStart() {
    }

    protected boolean isIncorrectInputType(InputType element) {
        if (element == null) {
            return false;
        }
        if (element instanceof InputType) {
            String type = element.getType();
            int index = this.readerCombo.getSelectionIndex();
            if (index == -1) {
                return true;
            }
            Object reader = this.readerTypeList.get(index);
            if (reader instanceof NullReader) {
                return true;
            }
            if (!(reader instanceof XMLReader) && !(reader instanceof XSDReader)) {
                boolean cfr_ignored_0 = reader instanceof JavaReader;
            }
            if (reader instanceof XMLReader && !"input.xml".equals(type)) {
                return true;
            }
            if (reader instanceof XSDReader && !"input.xsd".equals(type)) {
                return true;
            }
            if (reader instanceof JavaReader && !"input.java".equals(type)) {
                return true;
            }
            if (reader instanceof EObject) {
                Object obj = (EObject)reader;
                if ((obj = AdapterFactoryEditingDomain.unwrap((Object)obj)) instanceof EDI12Reader && !"input.edi".equals(type)) {
                    return true;
                }
                if (obj instanceof CSV12Reader && !"input.csv".equals(type)) {
                    return true;
                }
                if (obj instanceof Json12Reader && !"input.json".equals(type)) {
                    return true;
                }
                if (obj instanceof ReaderType && !"input.custom".equals(type)) {
                    return true;
                }
            }
        }
        return false;
    }

    private class InputDataViewerLabelProvider
    extends ExtentionInputLabelProvider
    implements ITableColorProvider {
        private InputDataViewerLabelProvider() {
        }

        public Color getBackground(Object element, int columnIndex) {
            SmooksReaderFormPage.this.isIncorrectInputType((InputType)element);
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (SmooksReaderFormPage.this.isIncorrectInputType((InputType)element)) {
                return ColorConstants.lightGray;
            }
            return null;
        }
    }

    private class JavaReader {
        private JavaReader() {
        }
    }

    private class NullReader {
        private NullReader() {
        }
    }

    private class XMLReader {
        private XMLReader() {
        }
    }

    private class XSDReader {
        private XSDReader() {
        }
    }
}

