/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.smooks.configuration.editors.SmooksMultiFormEditor;
import org.jboss.tools.smooks.configuration.editors.csv.CSVDataConfigurationWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv.CSVDataPathWizardPage;
import org.jboss.tools.smooks.configuration.editors.csv.Messages;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

public class CSVInputDataWizard
extends Wizard
implements IStructuredDataSelectionWizard,
INewWizard {
    private SmooksResourceListType resourceList;
    private EditingDomain editingDomain;
    private CSVDataConfigurationWizardPage configPage;
    private CSVDataPathWizardPage pathPage;
    private IContainer folder = null;

    public CSVInputDataWizard() {
        this.setWindowTitle(Messages.CSVInputDataWizard_WizardTitle);
    }

    public void addPages() {
        if (this.pathPage == null) {
            this.pathPage = new CSVDataPathWizardPage(Messages.CSVInputDataWizard_WizardPageText, new String[]{Messages.CSVInputDataWizard_ExtensionName}, this.configPage);
            if (this.folder != null) {
                this.pathPage.setInitSelections(new Object[]{this.folder});
            }
        }
        this.addPage((IWizardPage)this.pathPage);
        super.addPages();
    }

    public boolean performFinish() {
        if (this.configPage != null) {
            boolean bl = this.configPage.isCreateCSVReader();
        }
        return true;
    }

    public boolean canFinish() {
        if (this.pathPage != null) {
            return this.pathPage.isPageComplete();
        }
        return this.configPage != null && this.pathPage != null && this.configPage.isPageComplete() && this.pathPage.isPageComplete();
    }

    public void complate(SmooksMultiFormEditor formEditor) {
    }

    public String getInputDataTypeID() {
        return "input.csv";
    }

    public Properties getProperties() {
        Properties pro = new Properties();
        this.fillProperties(pro);
        return pro;
    }

    private void fillProperties(Properties pro) {
        if (this.configPage != null) {
            String skiplines;
            String quoteChar;
            String separator;
            String encoding;
            boolean createCSVReader = this.configPage.isCreateCSVReader();
            boolean useAvailabelReader = this.configPage.isUseAvailabelReader();
            if (useAvailabelReader || createCSVReader) {
                pro.put("linkCSVReader", "true");
                return;
            }
            String fields = null;
            List<CSVDataConfigurationWizardPage.FieldString> fieldList = this.configPage.getFieldsList();
            if (fieldList != null && !fieldList.isEmpty()) {
                fields = "";
                for (CSVDataConfigurationWizardPage.FieldString fieldString : fieldList) {
                    String f = fieldString.getText();
                    fields = String.valueOf(fields) + f + ",";
                }
                if (fields.length() > 1) {
                    fields = fields.substring(0, fields.length() - 1);
                }
            }
            if (fields != null && fields.length() != 0) {
                pro.put("fields", fields);
            }
            if ((encoding = this.configPage.getEncoding()) != null && encoding.length() != 0) {
                pro.put("encoding", encoding);
            }
            if ((separator = this.configPage.getSeparator()) != null && separator.length() != 0) {
                pro.put("separator", separator);
            }
            if ((quoteChar = this.configPage.getQuoteChar()) != null && quoteChar.length() != 0) {
                pro.put("quoteChar", quoteChar);
            }
            if ((skiplines = this.configPage.getSkipLines()) != null && skiplines.length() != 0) {
                pro.put("skiplines", skiplines);
            }
        }
    }

    public Object getReturnData() {
        return null;
    }

    public String getStructuredDataSourcePath() {
        if (this.pathPage != null) {
            return this.pathPage.getFilePath();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IEditorPart editorPart = site.getWorkbenchWindow().getActivePage().findEditor(input);
        if (editorPart != null && editorPart instanceof SmooksMultiFormEditor) {
            SmooksMultiFormEditor formEditor = (SmooksMultiFormEditor)editorPart;
            EObject smooksModel = formEditor.getSmooksModel();
            if (smooksModel instanceof DocumentRoot) {
                this.resourceList = ((DocumentRoot)smooksModel).getSmooksResourceList();
            }
            this.editingDomain = formEditor.getEditingDomain();
        }
        this.folder = ((IFileEditorInput)input).getFile().getParent();
        if (this.pathPage != null && this.folder != null && input instanceof IFileEditorInput) {
            this.pathPage.setInitSelections(new Object[]{this.folder});
        }
        if (this.configPage != null) {
            this.configPage.setSmooksResourceList(this.resourceList);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

