/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.csv12;

import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.ModelMultiChildrenTabelPanelCreator;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.csv12.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.csv12.Binding;
import org.jboss.tools.smooks.model.csv12.CSV12Reader;
import org.jboss.tools.smooks.model.csv12.Csv12Package;
import org.jboss.tools.smooks.model.csv12.MapBinding;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Csv12ReaderUICreator
extends PropertyUICreator {
    @Override
    public AttributeFieldEditPart createPropertyUI(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart part) {
        return super.createPropertyUI(toolkit, parent, propertyDescriptor, model, feature, formEditor, part);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnTop(AdapterFactoryEditingDomain editingDomain, FormToolkit formToolkit, Composite detailsComposite, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        this.createFiledsComposite(editingDomain, formToolkit, detailsComposite, model, formEditor);
        return super.createExtendUIOnTop(editingDomain, formToolkit, detailsComposite, model, formEditor, editorPart);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnBottom(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        return super.createExtendUIOnBottom(editingdomain, toolkit, parent, model, formEditor, editorPart);
    }

    @Override
    public boolean ignoreProperty(EAttribute feature) {
        if (feature.equals(Csv12Package.Literals.CSV12_READER__ENCODING)) {
            return true;
        }
        if (feature.equals(SmooksPackage.Literals.ABSTRACT_READER__TARGET_PROFILE)) {
            return true;
        }
        if (feature.equals(Csv12Package.Literals.CSV12_READER__FIELDS)) {
            return true;
        }
        if (feature.equals(Csv12Package.Literals.CSV12_READER__QUOTE)) {
            return true;
        }
        if (feature.equals(Csv12Package.Literals.CSV12_READER__SEPARATOR)) {
            return true;
        }
        if (feature.equals(Csv12Package.Literals.CSV12_READER__RECORD_ELEMENT_NAME)) {
            return true;
        }
        if (feature.equals(Csv12Package.Literals.CSV12_READER__ROOT_ELEMENT_NAME)) {
            return true;
        }
        return super.ignoreProperty(feature);
    }

    private void createParametersGroup(Composite parent, CSV12Reader reader, FormToolkit toolkit, ISmooksModelProvider modelProvider, IEditorPart editorPart) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Csv12ReaderUICreator_0);
        group.setBackground(ColorConstants.white);
        FillLayout fl = new FillLayout();
        group.setLayout((Layout)fl);
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)modelProvider.getEditingDomain();
        Shell shell = parent.getShell();
        IEditingDomainItemProvider p = (IEditingDomainItemProvider)editingDomain.getAdapterFactory().adapt((Notifier)reader, IEditingDomainItemProvider.class);
        Collection children = p.getNewChildDescriptors((Object)reader, (EditingDomain)editingDomain, null);
        ModelMultiChildrenTabelPanelCreator creator = new ModelMultiChildrenTabelPanelCreator(shell, children, editingDomain, modelProvider, (EObject)reader, toolkit, editorPart, (ILabelProvider)new ReaderBindingLabelProvider());
        creator.createChildrenTablePanel((Composite)group);
        GridData gd = new GridData(768);
        gd.heightHint = 180;
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
    }

    private void createFiledsComposite(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor) {
        IItemPropertySource propertySource = (IItemPropertySource)editingdomain.getAdapterFactory().adapt(model, IItemPropertySource.class);
        IItemPropertyDescriptor fieldsDescriptor = propertySource.getPropertyDescriptor(model, (Object)Csv12Package.Literals.CSV12_READER__FIELDS);
        String fields = (String)SmooksUIUtils.getEditValue(fieldsDescriptor, model);
        final AttributeFieldEditPart fieldsEditPart = SmooksUIUtils.createStringFieldEditor(Messages.Csv12ReaderUICreator_Fields, parent, (EditingDomain)editingdomain, toolkit, fieldsDescriptor, model, false, false, false, null, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null, false);
        Text text = (Text)fieldsEditPart.getContentControl();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Csv12ReaderUICreator.this.updateFieldsMessage(((Text)arg0.getSource()).getText(), fieldsEditPart);
            }
        });
        this.updateFieldsMessage(fields, fieldsEditPart);
        IItemPropertyDescriptor descriptor = propertySource.getPropertyDescriptor(model, (Object)Csv12Package.Literals.CSV12_READER__SEPARATOR);
        AttributeFieldEditPart separatorEditPart = SmooksUIUtils.createStringFieldEditor(Messages.Csv12ReaderUICreator_Separator_Char, parent, (EditingDomain)editingdomain, toolkit, descriptor, model, false, false, false, null, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null, false);
        Text separateText = (Text)separatorEditPart.getContentControl();
        separateText.setTextLimit(1);
        IItemPropertyDescriptor quotedescriptor = propertySource.getPropertyDescriptor(model, (Object)Csv12Package.Literals.CSV12_READER__QUOTE);
        AttributeFieldEditPart quoteEditPart = SmooksUIUtils.createStringFieldEditor(Messages.Csv12ReaderUICreator_Quote_Char, parent, (EditingDomain)editingdomain, toolkit, quotedescriptor, model, false, false, false, null, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null, false);
        Text quoteText = (Text)quoteEditPart.getContentControl();
        quoteText.setTextLimit(1);
        IItemPropertyDescriptor recorddescriptor = propertySource.getPropertyDescriptor(model, (Object)Csv12Package.Literals.CSV12_READER__RECORD_ELEMENT_NAME);
        SmooksUIUtils.createStringFieldEditor(Messages.Csv12ReaderUICreator_Record_Name, parent, (EditingDomain)editingdomain, toolkit, recorddescriptor, model, false, false, false, null, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null, false);
        IItemPropertyDescriptor rootdescriptor = propertySource.getPropertyDescriptor(model, (Object)Csv12Package.Literals.CSV12_READER__ROOT_ELEMENT_NAME);
        SmooksUIUtils.createStringFieldEditor(Messages.Csv12ReaderUICreator_Root_Name, parent, (EditingDomain)editingdomain, toolkit, rootdescriptor, model, false, false, false, null, 0, null, SmooksUIUtils.VALUE_TYPE_VALUE, null, false);
    }

    protected void updateFieldsMessage(String fields, AttributeFieldEditPart editPart) {
        editPart.getFieldMarker().clean();
        String error = null;
        if (fields == null) {
            error = "";
        } else if ("".equals(fields = fields.trim())) {
            error = "";
        } else {
            char[] chars = fields.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c != ',' && !Character.isLetterOrDigit(c)) {
                    error = "" + c;
                    break;
                }
                ++i;
            }
            String[] fieldsArray = fields.split(",");
            if (fieldsArray.length == 0) {
                error = "";
            }
            int i2 = 0;
            while (i2 < fieldsArray.length) {
                String f = fieldsArray[i2];
                if (f == null || "".equals(f.trim())) {
                    error = "";
                    break;
                }
                ++i2;
            }
        }
        if (error != null) {
            editPart.getFieldMarker().setMarkerType(1);
            editPart.getFieldMarker().setMessage(error);
        }
    }

    private class ReaderBindingLabelProvider
    extends LabelProvider {
        private ReaderBindingLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof CommandParameter) {
                Object v = ((CommandParameter)element).getValue();
                v = AdapterFactoryEditingDomain.unwrap((Object)v);
                EStructuralFeature feature = ((CommandParameter)element).getEStructuralFeature();
                if (v instanceof MapBinding) {
                    if (feature == Csv12Package.Literals.CSV12_READER__MAP_BINDING) {
                        return Messages.Csv12ReaderUICreator_MapBinding;
                    }
                    if (feature == Csv12Package.Literals.CSV12_READER__SINGLE_BINDING) {
                        return Messages.Csv12ReaderUICreator_SingleMapBinding;
                    }
                    if (feature == Csv12Package.Literals.CSV12_READER__LIST_BINDING) {
                        return Messages.Csv12ReaderUICreator_ListMapBinding;
                    }
                }
                if (v instanceof Binding) {
                    if (feature == Csv12Package.Literals.CSV12_READER__SINGLE_BINDING) {
                        return Messages.Csv12ReaderUICreator_SingleBinding;
                    }
                    if (feature == Csv12Package.Literals.CSV12_READER__LIST_BINDING) {
                        return Messages.Csv12ReaderUICreator_ListBinding;
                    }
                }
            }
            return super.getText(element);
        }
    }
}

