/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.edi;

import java.util.List;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.smooks.configuration.editors.ClassPathFileProcessor;
import org.jboss.tools.smooks.configuration.editors.edi.Messages;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractFileSelectionWizardPage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIMappingDataPathWizardPage
extends AbstractFileSelectionWizardPage {
    private boolean hasReader = false;
    private boolean createNewReader = true;
    private String mappingFile = null;
    private Composite fileComposite = null;
    private String encoding = "UTF-8";
    private Button createNewReaderButton;
    private boolean useAvaliableReader = false;
    private SmooksResourceListType resourceList;

    public EDIMappingDataPathWizardPage(String pageName, boolean multiSelect, Object[] initSelections, List<ViewerFilter> filters) {
        super(pageName, multiSelect, initSelections, filters);
        this.setTitle(Messages.EDIMappingDataPathWizardPage_EDI_Wizard_Title);
        this.setDescription(Messages.EDIMappingDataPathWizardPage_EDI_Wizard_Description);
        this.setFilePathProcessor(new ClassPathFileProcessor());
    }

    public EDIMappingDataPathWizardPage(String pageName, String[] fileExtensionNames) {
        super(pageName, fileExtensionNames);
        this.setTitle(Messages.EDIMappingDataPathWizardPage_EDI_Wizard_Title);
        this.setDescription(Messages.EDIMappingDataPathWizardPage_EDI_Wizard_Description);
        this.setFilePathProcessor(new ClassPathFileProcessor());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isUseAvaliableReader() {
        return this.useAvaliableReader;
    }

    public SmooksResourceListType getSmooksResourceList() {
        return this.resourceList;
    }

    public void setSmooksResourceList(SmooksResourceListType resourceList) {
        this.resourceList = resourceList;
    }

    private void initData() {
        this.encoding = "UTF-8";
        this.hasReader = false;
        this.useAvaliableReader = false;
        this.createNewReader = true;
        this.mappingFile = null;
        if (this.hasReader) {
            this.useAvaliableReader = true;
            this.createNewReader = false;
        }
    }

    public boolean isHasReader() {
        return this.hasReader;
    }

    public boolean isCreateNewReader() {
        return this.createNewReader;
    }

    @Override
    public void createControl(Composite parent) {
        this.initData();
        super.createControl(parent);
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    @Override
    protected void createExtensionGUIFirst(Composite parent) {
        Label encodingLabel = new Label(parent, 0);
        encodingLabel.setText(Messages.EDIMappingDataPathWizardPage_Label_Encoding);
        final Text encodingText = new Text(parent, 2048);
        encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDIMappingDataPathWizardPage.this.mappingFile = encodingText.getText();
            }
        });
        GridData gd = new GridData(768);
        encodingText.setLayoutData((Object)gd);
    }

    @Override
    protected Composite createFileSelectionComposite(Composite parent) {
        Composite chooseComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        chooseComposite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        chooseComposite.setLayout((Layout)gl);
        Button newReaderButton = new Button(chooseComposite, 16);
        newReaderButton.setText(Messages.EDIMappingDataPathWizardPage_Button_Create_Readers);
        final Button useReaderButton = new Button(chooseComposite, 16);
        useReaderButton.setText(Messages.EDIMappingDataPathWizardPage_Button_Use_Existing_Reader);
        this.fileComposite = super.createFileSelectionComposite(parent);
        this.createNewReaderButton = new Button(this.fileComposite, 32);
        this.createNewReaderButton.setText(Messages.EDIMappingDataPathWizardPage_Button_Create_New_Reader);
        this.createNewReaderButton.setSelection(true);
        if (this.hasReader) {
            this.createNewReaderButton.setSelection(false);
            this.createNewReaderButton.setEnabled(false);
            useReaderButton.setSelection(true);
            this.setConfigCompositeStates(false);
        } else {
            newReaderButton.setSelection(true);
            this.createNewReaderButton.setSelection(true);
        }
        this.createNewReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIMappingDataPathWizardPage.this.createNewReader = EDIMappingDataPathWizardPage.this.createNewReaderButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        newReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIMappingDataPathWizardPage.this.useAvaliableReader = useReaderButton.getSelection();
                EDIMappingDataPathWizardPage.this.setConfigCompositeStates(true);
                EDIMappingDataPathWizardPage.this.changeWizardPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        useReaderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EDIMappingDataPathWizardPage.this.useAvaliableReader = useReaderButton.getSelection();
                EDIMappingDataPathWizardPage.this.setConfigCompositeStates(false);
                EDIMappingDataPathWizardPage.this.changeWizardPageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.createNewReaderButton.setLayoutData((Object)gd);
        return this.fileComposite;
    }

    private void setConfigCompositeStates(boolean enabled) {
        this.fileComposite.setEnabled(enabled);
        Control[] controls = this.fileComposite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c == this.createNewReaderButton && this.hasReader) {
                c.setEnabled(false);
            } else {
                if (c == this.fileTextComposite) {
                    Control[] cs = ((Composite)c).getChildren();
                    int j = 0;
                    while (j < cs.length) {
                        Control cc = cs[j];
                        cc.setEnabled(enabled);
                        ++j;
                    }
                }
                c.setEnabled(enabled);
            }
            ++i;
        }
    }

    @Override
    protected Object loadedTheObject(String path) throws Exception {
        return null;
    }

    @Override
    protected void changeWizardPageStatus() {
        if (!this.useAvaliableReader) {
            super.changeWizardPageStatus();
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }
}

