/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanList
extends JavaBeanModel
implements IXMLStructuredObject {
    private List<IXMLStructuredObject> children = null;

    @Override
    public List<IXMLStructuredObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IXMLStructuredObject>();
        }
        return this.children;
    }

    public JavaBeanList() {
        super(null);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String getJavaBeanName(JavaBeanModel javaBean) {
        List<IXMLStructuredObject> children = this.getChildren();
        int sameNameBean = 0;
        for (JavaBeanModel javaBeanModel : children) {
            if (!javaBeanModel.getBeanClass().getName().equals(javaBean.getBeanClass().getName())) continue;
            ++sameNameBean;
        }
        if (sameNameBean > 0) {
            String name = String.valueOf(javaBean.getName()) + String.valueOf(sameNameBean);
            while (this.hasSameNameBean(name, javaBean.getBeanClass())) {
                name = String.valueOf(javaBean.getName()) + String.valueOf(++sameNameBean);
            }
            return name;
        }
        return javaBean.getName();
    }

    private boolean hasSameNameBean(String name, Class<?> clazz) {
        for (JavaBeanModel javaBeanModel : this.children) {
            if (!javaBeanModel.getBeanClass().getName().equals(clazz.getName()) || !name.equals(javaBeanModel.getName())) continue;
            return true;
        }
        return false;
    }

    public void addJavaBean(JavaBeanModel javaBean) {
        String n1;
        if (javaBean == null) {
            return;
        }
        String name = javaBean.getName();
        if (!name.equals(n1 = this.getJavaBeanName(javaBean))) {
            javaBean.setName(n1);
        }
        javaBean.setParent(this);
        this.getChildren().add(javaBean);
    }

    public void removeJavaBean(JavaBeanModel javaBean) {
        this.getChildren().remove(javaBean);
        javaBean.setParent(null);
    }

    @Override
    public List<?> getProperties() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getID() {
        return this;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public JavaBeanModel getParent() {
        return null;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isRootNode() {
        return true;
    }
}

