/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanList;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.uitls.JavaPropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanModel
implements IXMLStructuredObject,
Cloneable {
    private boolean flat = false;
    private boolean expaned = false;
    private Properties extendProperties = new Properties();
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String beanClassString = null;
    private Object waring = null;
    private Object error = null;
    private String name = "";
    private Class typeRef = null;
    private boolean many = false;
    private boolean collection = false;
    private boolean isPrimitive = false;
    private boolean hasGenericType = false;
    private Class<? extends Object> beanClass = null;
    private JavaBeanModel parent = null;
    private Class parentClass = null;
    private boolean isRootClassModel = false;
    private boolean isList = false;
    private Class componentClass = null;
    private boolean lazyLoadProperties = true;
    private PropertyDescriptor propertyDescriptor;
    private List properties;

    public void setBeanClassString(String beanClassString) {
        this.beanClassString = beanClassString;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public boolean isRootClassModel() {
        return this.isRootClassModel || this.getParent() == null;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setRootClassModel(boolean isRootClassModel) {
        this.isRootClassModel = isRootClassModel;
    }

    public void addNodePropetyChangeListener(PropertyChangeListener listener) {
        PropertyChangeListener[] array = this.support.getPropertyChangeListeners();
        int i = 0;
        while (i < array.length) {
            if (listener == array[i]) {
                return;
            }
            ++i;
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void removeNodePropetyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void cleanAllNodePropertyChangeListeners() {
        PropertyChangeListener[] ps = this.support.getPropertyChangeListeners();
        int i = 0;
        while (i < ps.length) {
            PropertyChangeListener p = ps[i];
            this.support.removePropertyChangeListener(p);
            ++i;
        }
    }

    public String getBeanClassString() {
        if (this.beanClassString != null && this.beanClassString.length() != 0) {
            return this.beanClassString;
        }
        Class clazz = this.getBeanClass();
        if (clazz == null) {
            return "<null>";
        }
        if (clazz.isArray()) {
            String s = clazz.getComponentType().getName();
            return String.valueOf(s) + "[]";
        }
        return clazz.getName();
    }

    public String getBeanClassStringWithList() {
        Class genericType;
        String s = this.getBeanClassString();
        if (this.isList() && (genericType = this.getGenericType()) != null) {
            s = String.valueOf(s) + "<" + genericType.getName() + ">";
        }
        return s;
    }

    public boolean isList() {
        if (this.beanClass == null) {
            return false;
        }
        if (Collection.class.isAssignableFrom(this.beanClass)) {
            Type returnType;
            Method rmethod;
            if (this.propertyDescriptor != null && (rmethod = this.propertyDescriptor.getReadMethod()) != null && (returnType = rmethod.getGenericReturnType()) instanceof ParameterizedType) {
                Type gtype = ((ParameterizedType)returnType).getActualTypeArguments()[0];
                if (gtype instanceof Class) {
                    Class beanType;
                    this.componentClass = beanType = (Class)gtype;
                    this.setGenericType(true);
                }
                if (gtype instanceof WildcardType) {
                    Type[] upperBounds = ((WildcardType)gtype).getUpperBounds();
                    Type[] lowerBounds = ((WildcardType)gtype).getLowerBounds();
                    if (upperBounds.length != 0) {
                        this.componentClass = (Class)upperBounds[0];
                        this.setGenericType(true);
                    }
                    if (lowerBounds.length != 0) {
                        this.componentClass = (Class)lowerBounds[0];
                        this.setGenericType(true);
                    }
                }
            }
            this.setList(true);
        }
        return this.isList;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    JavaBeanModel(Class beanClass, String beanName, PropertyDescriptor propertyDescriptor, Class parentClass, boolean lazyLoadProperties) {
        this.lazyLoadProperties = lazyLoadProperties;
        this.beanClass = this.toConcreteImpl(beanClass);
        this.name = beanName;
        if (beanClass == null) {
            return;
        }
        if (this.name == null) {
            this.name = beanClass.getSimpleName();
        }
        if (propertyDescriptor == null) {
            this.setRootClassModel(true);
        }
        this.propertyDescriptor = propertyDescriptor;
        Class beanType = beanClass;
        if (beanClass.isArray()) {
            beanType = beanClass.getComponentType();
            this.setMany(true);
            this.componentClass = beanType;
        }
        if (Collection.class.isAssignableFrom(beanClass)) {
            Type gtype;
            Type returnType;
            Method rmethod;
            if (this.propertyDescriptor != null && (rmethod = propertyDescriptor.getReadMethod()) != null && (returnType = rmethod.getGenericReturnType()) instanceof ParameterizedType && (gtype = ((ParameterizedType)returnType).getActualTypeArguments()[0]) instanceof Class) {
                this.componentClass = beanType = (Class)gtype;
            }
            this.setList(true);
        }
        if (beanType.isPrimitive() || JavaBeanModelFactory.isPrimitiveObject(beanType)) {
            this.parentClass = parentClass;
            if (!this.isArray() && !this.isList()) {
                this.setPrimitive(true);
            }
            return;
        }
        this.parentClass = parentClass;
        if (!lazyLoadProperties) {
            this.getProperties();
        }
    }

    JavaBeanModel(Class beanClass, String beanName, PropertyDescriptor propertyDescriptor) {
        this(beanClass, beanName, propertyDescriptor, null, true);
    }

    public JavaBeanModel(Class beanClass) {
        this(beanClass, null, null, null, true);
    }

    public JavaBeanModel(Class beanClass, String name) {
        this(beanClass, name, null, null, true);
    }

    JavaBeanModel(Class<?> beanClass, boolean lazyLoadProperties) {
        this(beanClass, null, null, null, lazyLoadProperties);
    }

    private Class<? extends Object> toConcreteImpl(Class declaredType) {
        if (declaredType == List.class) {
            return ArrayList.class;
        }
        if (declaredType == Set.class) {
            return LinkedHashSet.class;
        }
        if (declaredType == Collection.class) {
            return ArrayList.class;
        }
        if (declaredType == Map.class) {
            return LinkedHashMap.class;
        }
        return declaredType;
    }

    public boolean isPrimitive() {
        Class beanType = this.getBeanClass();
        if (beanType == null) {
            return false;
        }
        if ((beanType.isPrimitive() || JavaBeanModelFactory.isPrimitiveObject(beanType)) && !this.isArray() && !this.isList()) {
            this.setPrimitive(true);
        }
        return this.isPrimitive;
    }

    public void setPrimitive(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    public boolean isArray() {
        if (this.beanClass == null) {
            return false;
        }
        if (this.beanClass.isArray()) {
            Class<?> beanType = this.beanClass.getComponentType();
            this.setMany(true);
            this.componentClass = beanType;
            this.setGenericType(true);
        }
        return this.many;
    }

    public Class getGenericType() {
        return this.componentClass;
    }

    public void setMany(boolean many) {
        this.many = many;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addProperty(JavaBeanModel property) {
        if (this.properties != null) {
            this.properties.add(property);
            property.setParent(this);
        }
    }

    protected void createArrayChildren(Class<Object> clazz, String name, PropertyDescriptor pd, Class<? extends Object> parentClass, boolean lazyLoad) {
        JavaBeanModel proxyModel = this.newChildJavaBean(clazz, name, pd, parentClass, lazyLoad);
        this.addProperty(proxyModel);
    }

    protected void createListChildren(Class<Object> clazz, String name, PropertyDescriptor pd, Class<? extends Object> parentClass, boolean lazyLoad) {
        JavaBeanModel proxyModel = this.newChildJavaBean(clazz, name, pd, parentClass, lazyLoad);
        this.addProperty(proxyModel);
    }

    public boolean isExpaned() {
        return this.expaned;
    }

    public List getProperties() {
        this.expaned = true;
        JavaBeanModel parent = this.getParent();
        if (parent != null && parent.isFlat()) {
            return Collections.emptyList();
        }
        if (this.properties == null) {
            this.properties = new ArrayList();
            if (this.isPrimitive()) {
                return this.properties;
            }
            Class beanType = this.beanClass;
            if (this.isArray() || this.isList()) {
                if (this.componentClass != null) {
                    this.createArrayChildren(this.componentClass, this.componentClass.getSimpleName(), null, this.beanClass, this.lazyLoadProperties);
                    beanType = this.componentClass;
                } else {
                    this.createListChildren(Object.class, "object", null, this.beanClass, this.lazyLoadProperties);
                    beanType = this.componentClass;
                }
                return this.properties;
            }
            if (beanType == null) {
                return Collections.EMPTY_LIST;
            }
            PropertyDescriptor[] pds = JavaPropertyUtils.getPropertyDescriptor(beanType);
            int i = 0;
            while (i < pds.length) {
                Type[] types;
                Type returnType;
                Method rmethod;
                PropertyDescriptor pd = pds[i];
                if (!"class".equals(pd.getName()) && pd.getPropertyType() != null && (!Collection.class.isAssignableFrom(pd.getPropertyType()) || (rmethod = pd.getReadMethod()) == null || (returnType = rmethod.getGenericReturnType()) instanceof ParameterizedType && (types = ((ParameterizedType)returnType).getActualTypeArguments()) != null && types.length != 0)) {
                    JavaBeanModel jbm = this.newChildJavaBean(pd.getPropertyType(), pd.getName(), pd, this.beanClass, this.lazyLoadProperties);
                    this.addProperty(jbm);
                }
                ++i;
            }
        }
        return this.properties;
    }

    protected JavaBeanModel newChildJavaBean(Class clazz, String name, PropertyDescriptor pd, Class parentClass, boolean lazyLoading) {
        return new JavaBeanModel(clazz, name, pd, parentClass, lazyLoading);
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }

    public boolean propertiesHasBeenLoaded() {
        return this.properties != null;
    }

    @Override
    public JavaBeanModel getParent() {
        return this.parent;
    }

    public void setParent(JavaBeanModel parent) {
        this.parent = parent;
    }

    public Object getWarning() {
        return this.waring;
    }

    public void setWarning(Object waring) {
        this.waring = waring;
    }

    public Object getError() {
        return this.error;
    }

    public void setError(Object error) {
        this.error = error;
    }

    public JavaBeanModel getRootParent() {
        JavaBeanModel parent = this.getParent();
        if (parent == null) {
            return this;
        }
        JavaBeanModel temp = parent;
        while (temp != null) {
            parent = temp;
            temp = temp.getParent();
        }
        return parent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("JavaName : " + this.name);
        if (this.beanClass != null) {
            buffer.append("BeanClass : " + this.beanClass.getName());
        }
        if (this.properties != null) {
            buffer.append("\n");
            for (JavaBeanModel child : this.properties) {
                buffer.append("\t");
                buffer.append(child.toString());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public String getSelectorString() {
        if (this.parent == null) {
            return this.getBeanClassString();
        }
        if (this.parent.getClass() == JavaBeanList.class) {
            return this.getBeanClassString();
        }
        if (this.parent.isArray() || this.parent.isList()) {
            return this.getBeanClassString();
        }
        return this.getName();
    }

    public boolean hasGenericType() {
        return this.hasGenericType;
    }

    public void setGenericType(boolean hasGenericType) {
        this.hasGenericType = hasGenericType;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public List<IXMLStructuredObject> getChildren() {
        List ps = this.getProperties();
        if (ps != null) {
            return ps;
        }
        return null;
    }

    @Override
    public Object getID() {
        Class clazz = this.getBeanClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            return String.valueOf(this.getBeanClassString()) + this.getName();
        }
        return this.getBeanClass();
    }

    @Override
    public String getNodeName() {
        return this.getSelectorString();
    }

    @Override
    public boolean isRootNode() {
        return false;
    }

    public void setComponentClass(Class clazz) {
        this.componentClass = clazz;
    }

    public Class getComponentClass() {
        return this.componentClass;
    }

    public void addExtendProperty(String name, String value) {
        this.extendProperties.setProperty(name, value);
    }

    public String getExtendProperty(String name) {
        return this.extendProperties.getProperty(name);
    }

    public Object clone() {
        if (this.isList()) {
            JavaBeanModel model = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(ArrayList.class);
            model.setComponentClass(this.componentClass);
            return model;
        }
        return JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(this.getBeanClass());
    }
}

