/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.javabean.IJavaBeanSelectionListener;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.uitls.ProjectClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanModelLoadComposite
extends Composite
implements SelectionListener {
    private List<JavaBeanModel> javabeanList = new ArrayList<JavaBeanModel>();
    protected Text classText;
    protected String classFullName;
    protected boolean loadAtomic;
    protected IJavaProject javaProject;
    protected IRunnableContext runnableContext;
    protected JavaBeanModel currentRootJavaBeanModel = null;
    protected JavaBeanModel returnJavaBeanModel = null;
    private List<IJavaBeanSelectionListener> selectionListenerList = new ArrayList<IJavaBeanSelectionListener>();
    protected ProjectClassLoader loader = null;
    private TableViewer listViewer;

    public JavaBeanModelLoadComposite(Composite parent, int style, IRunnableContext runnableContext, IJavaProject project, boolean loadJavapropertiesAtomic) throws Exception {
        super(parent, style);
        this.loadAtomic = loadJavapropertiesAtomic;
        this.runnableContext = runnableContext;
        if (this.runnableContext == null) {
            this.runnableContext = SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (this.runnableContext == null) {
                throw new Exception("Init error");
            }
        }
        if (project != null) {
            this.javaProject = project;
            this.loader = new ProjectClassLoader(this.javaProject);
        }
        this.createCompositeContent();
    }

    public JavaBeanModelLoadComposite(Composite parent, int style, IRunnableContext runnableContext, IJavaProject project) throws Exception {
        this(parent, style, runnableContext, project, true);
    }

    public List<JavaBeanModel> getJavabeanList() {
        return this.javabeanList;
    }

    public void addJavaBeanSelectionListener(IJavaBeanSelectionListener listener) {
        this.selectionListenerList.add(listener);
    }

    public void removeJavaBeanSelectionListener(IJavaBeanSelectionListener listener) {
        this.selectionListenerList.remove(listener);
    }

    public void setJavabeanList(List<JavaBeanModel> javabeanList) {
        this.javabeanList = javabeanList;
    }

    protected Control createCompositeContent() {
        JavaBeanModelLoadComposite parent = this;
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        com.setLayout((Layout)layout);
        Label classLabel = new Label(com, 0);
        classLabel.setText("Class : ");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        classLabel.setLayoutData((Object)gd);
        Composite listViewerComposite = new Composite(com, 0);
        GridLayout listLayout = new GridLayout();
        listLayout.numColumns = 2;
        listViewerComposite.setLayout((Layout)listLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        listViewerComposite.setLayoutData((Object)gd);
        this.listViewer = new TableViewer(listViewerComposite, 67584);
        TableColumn nameColumn = new TableColumn(this.listViewer.getTable(), 0);
        nameColumn.setText("Class");
        TableColumn isArrayColumn = new TableColumn(this.listViewer.getTable(), 0);
        isArrayColumn.setText("Is Array");
        nameColumn.setWidth(400);
        isArrayColumn.setWidth(60);
        this.listViewer.getTable().setHeaderVisible(true);
        gd = new GridData(1808);
        this.listViewer.getTable().addMouseListener((MouseListener)new ColumnSelectionListener());
        this.listViewer.getControl().setLayoutData((Object)gd);
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setLabelProvider((IBaseLabelProvider)new BeanViewerLabelProvider());
        this.listViewer.setInput(this.javabeanList);
        Composite buttonArea = new Composite(listViewerComposite, 0);
        gd = new GridData(1040);
        buttonArea.setLayoutData((Object)gd);
        GridLayout buttonAreaLayout = new GridLayout();
        buttonArea.setLayout((Layout)buttonAreaLayout);
        Button addButton = new Button(buttonArea, 0);
        addButton.setText("Add");
        gd = new GridData(768);
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)this);
        Button removeButton = new Button(buttonArea, 0);
        removeButton.setText("Remove");
        gd = new GridData(768);
        removeButton.setLayoutData((Object)gd);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)JavaBeanModelLoadComposite.this.listViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                JavaBeanModelLoadComposite.this.javabeanList.removeAll(selection.toList());
                JavaBeanModelLoadComposite.this.listViewer.refresh();
            }
        });
        return com;
    }

    public ProjectClassLoader getProjectClassLoader() {
        if (this.loader == null) {
            try {
                this.loader = new ProjectClassLoader(this.javaProject);
            }
            catch (Exception exception) {}
        }
        return this.loader;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.widgetSelected(arg0);
    }

    public void widgetSelected(SelectionEvent arg0) {
        IJavaSearchScope scope = null;
        if (this.javaProject == null) {
            scope = JavaSearchScopeFactory.getInstance().createWorkspaceScope(true);
        } else {
            String[] requiredProjects = null;
            try {
                requiredProjects = this.javaProject.getRequiredProjectNames();
            }
            catch (Exception exception) {}
            if (requiredProjects == null) {
                requiredProjects = new String[]{this.javaProject.getElementName()};
            } else {
                String[] temp = new String[requiredProjects.length + 1];
                temp[0] = this.javaProject.getElementName();
                System.arraycopy(requiredProjects, 0, temp, 1, requiredProjects.length);
                requiredProjects = temp;
            }
            scope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope(requiredProjects, true);
        }
        Throwable exception = null;
        try {
            Object[] results;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.runnableContext, (IJavaSearchScope)scope, (int)512, (boolean)false);
            dialog.setMessage("Search Java Class");
            dialog.setTitle("Search");
            if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
                Class<?> clazz;
                ProjectClassLoader l;
                Object result = results[0];
                String packageFullName = JavaModelUtil.getTypeContainerName((IType)((IType)result));
                String className = null;
                className = packageFullName == null || packageFullName.length() <= 0 ? ((IType)result).getElementName() : String.valueOf(packageFullName) + "." + ((IType)result).getElementName();
                if (className != null && (l = this.getProjectClassLoader()) != null && (clazz = l.loadClass(className)) != null) {
                    JavaBeanModel model = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                    this.javabeanList.add(model);
                    this.listViewer.refresh();
                }
            }
        }
        catch (Throwable e) {
            exception = e;
        }
        for (IJavaBeanSelectionListener l : this.selectionListenerList) {
            if (exception != null) {
                l.exceptionOccur(new Exception(exception));
                continue;
            }
            l.exceptionOccur(null);
        }
    }

    private class BeanViewerCellModifyer
    implements ICellModifier {
        private BeanViewerCellModifyer() {
        }

        public boolean canModify(Object element, String property) {
            return !property.equals("name");
        }

        public Object getValue(Object element, String property) {
            if (element instanceof JavaBeanModel) {
                if (property.equals("array")) {
                    return ((JavaBeanModel)element).isArray();
                }
                if (property.equals("list")) {
                    return ((JavaBeanModel)element).isList();
                }
            }
            return Boolean.TRUE;
        }

        public void modify(Object element, String property, Object value) {
        }
    }

    private class BeanViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BeanViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof JavaBeanModel) {
                boolean isArray = "array".equals(((JavaBeanModel)element).getExtendProperty("many"));
                boolean isList = "list".equals(((JavaBeanModel)element).getExtendProperty("many"));
                switch (columnIndex) {
                    case 0: {
                        if (isArray) {
                            return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/javaarraymodel.gif");
                        }
                        if (isList) {
                            return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/javalistmodel.gif");
                        }
                        return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/class_obj.gif");
                    }
                    case 1: {
                        if (isArray) {
                            return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/checkbox_checked.gif");
                        }
                        return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/checkbox_uncheck.gif");
                    }
                    case 2: {
                        if (isList) {
                            return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/checkbox_checked.gif");
                        }
                        return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/checkbox_uncheck.gif");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JavaBeanModel) {
                switch (columnIndex) {
                    case 0: {
                        return ((JavaBeanModel)element).getBeanClassString();
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    public class ColumnSelectionListener
    implements MouseListener {
        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Object element;
            if (e.button != 1) {
                return;
            }
            ViewerCell cell = JavaBeanModelLoadComposite.this.listViewer.getCell(new Point(e.x, e.y));
            if (cell != null && (element = cell.getElement()) instanceof JavaBeanModel) {
                String many;
                if (cell.getColumnIndex() == 1) {
                    many = ((JavaBeanModel)element).getExtendProperty("many");
                    if ("array".equals(many)) {
                        ((JavaBeanModel)element).addExtendProperty("many", "");
                    } else {
                        ((JavaBeanModel)element).addExtendProperty("many", "array");
                    }
                }
                if (cell.getColumnIndex() == 2) {
                    many = ((JavaBeanModel)element).getExtendProperty("many");
                    if ("list".equals(many)) {
                        ((JavaBeanModel)element).addExtendProperty("many", "");
                    } else {
                        ((JavaBeanModel)element).addExtendProperty("many", "list");
                    }
                }
                try {
                    JavaBeanModelLoadComposite.this.listViewer.refresh(element);
                }
                catch (Exception exception) {}
            }
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

