/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.javabean.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.IFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.JavaPropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodsSelectionDialog
implements IFieldDialog {
    private IJavaProject resource;
    private Class<?> clazz;

    public JavaMethodsSelectionDialog(IJavaProject resource, Class<?> clazz) {
        this.resource = resource;
        this.clazz = clazz;
    }

    @Override
    public Object open(Shell shell) {
        if (this.resource != null && this.clazz != null) {
            MethodSelectionDialog dialog = new MethodSelectionDialog(shell, this.resource, this.clazz);
            if (dialog.open() == 0) {
                Method pd = (Method)dialog.getCurrentSelection();
                if (pd == null) {
                    return null;
                }
                return pd.getName();
            }
            return null;
        }
        MessageDialog.openInformation((Shell)shell, (String)Messages.JavaMethodsSelectionDialog_ErrorDialogTitle, (String)Messages.JavaMethodsSelectionDialog_ErrorMessage);
        return null;
    }

    @Override
    public IModelProcsser getModelProcesser() {
        return null;
    }

    @Override
    public void setModelProcesser(IModelProcsser processer) {
    }

    private class MethodContentProvider
    implements IStructuredContentProvider {
        private MethodContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement.getClass().isArray()) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MethodLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MethodLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/att_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Method) {
                Method p = (Method)element;
                switch (columnIndex) {
                    case 0: {
                        return p.getName();
                    }
                    case 1: {
                        Class<?>[] pts = p.getParameterTypes();
                        String paramtersName = "";
                        int i = 0;
                        while (i < pts.length) {
                            String name = pts[i].getName();
                            if (pts[i].isArray()) {
                                name = String.valueOf(pts[i].getComponentType().getName()) + "[]";
                            }
                            paramtersName = String.valueOf(paramtersName) + name;
                            ++i;
                            paramtersName = String.valueOf(paramtersName) + ",";
                        }
                        if (paramtersName.endsWith(",")) {
                            paramtersName = paramtersName.substring(0, paramtersName.length() - 1);
                        }
                        return paramtersName;
                    }
                }
            }
            return this.getText(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodSelectionDialog
    extends Dialog {
        private TableViewer viewer;
        private Class<?> clazz;
        private Object currentSelection;

        public MethodSelectionDialog(IShellProvider parentShell) {
            super(parentShell);
        }

        public MethodSelectionDialog(Shell parentShell, IJavaProject project, Class<?> clazz) {
            super(parentShell);
            this.clazz = clazz;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.heightHint = 400;
            gd.widthHint = 400;
            composite.setLayoutData((Object)gd);
            FillLayout fl = new FillLayout();
            fl.marginHeight = 10;
            fl.marginWidth = 10;
            composite.setLayout((Layout)fl);
            this.viewer = new TableViewer(composite, 67584);
            Table table = this.viewer.getTable();
            TableColumn nameColumn = new TableColumn(table, 0);
            nameColumn.setWidth(100);
            nameColumn.setText(Messages.JavaMethodsSelectionDialog_MethodNameColumnText);
            TableColumn typeColumn = new TableColumn(table, 0);
            typeColumn.setWidth(200);
            typeColumn.setText(Messages.JavaMethodsSelectionDialog_MethodParamsColumnText);
            table.setHeaderVisible(true);
            this.viewer.setContentProvider((IContentProvider)new MethodContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new MethodLabelProvider());
            Method[] settMethods = JavaPropertyUtils.getSetterMethods(this.clazz);
            this.viewer.setInput((Object)settMethods);
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    MethodSelectionDialog.this.okPressed();
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MethodSelectionDialog.this.currentSelection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.getShell().setText(String.valueOf(this.clazz.getSimpleName()) + Messages.JavaMethodsSelectionDialog_SetterDialogTitle);
            return composite;
        }

        public Object getCurrentSelection() {
            return this.currentSelection;
        }

        public void setCurrentSelection(Object currentSelection) {
            this.currentSelection = currentSelection;
        }
    }
}

