/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.javabean;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModel;
import org.jboss.tools.smooks.configuration.editors.javabean.JavaBeanModelFactory;
import org.jboss.tools.smooks.configuration.editors.javabean.Messages;
import org.jboss.tools.smooks.configuration.editors.uitls.IFieldDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.IModelProcsser;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;

public class JavaPropertiesSelectionDialog
implements IFieldDialog {
    private IJavaProject project;
    private String className;

    public JavaPropertiesSelectionDialog(IJavaProject resource, String className) {
        this.project = resource;
        this.className = className;
    }

    public Object open(Shell shell) {
        String errorMessage;
        block5: {
            block6: {
                JavaBeanModel pd;
                block7: {
                    Class<?> clazz;
                    errorMessage = "";
                    if (this.project == null) {
                        errorMessage = Messages.JavaPropertiesSelectionDialog_ProjectisJavaProjectErrorMessage;
                    }
                    if (this.project == null || this.className == null || (clazz = SmooksUIUtils.loadClass(this.className, this.project)) == null) break block5;
                    JavaBeanModel beanModel = JavaBeanModelFactory.getJavaBeanModelWithLazyLoad(clazz);
                    PropertySelectionDialog dialog = new PropertySelectionDialog(shell, this.project, beanModel);
                    if (dialog.open() != 0) break block6;
                    pd = (JavaBeanModel)dialog.getCurrentSelection();
                    if (pd != null) break block7;
                    return null;
                }
                try {
                    return pd.getName();
                }
                catch (JavaModelException javaModelException) {
                    errorMessage = "";
                    break block5;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = "'" + this.className + "' can't be found.";
                }
            }
            return null;
        }
        MessageDialog.openInformation((Shell)shell, (String)Messages.JavaPropertiesSelectionDialog_CantOpenDialogTitle, (String)(String.valueOf(Messages.JavaPropertiesSelectionDialog_CantOpenDialogErrorMessage1) + this.className + "'.\n" + errorMessage));
        return null;
    }

    public IModelProcsser getModelProcesser() {
        return null;
    }

    public void setModelProcesser(IModelProcsser processer) {
    }

    private class PropertyDescriptorContentProvider
    implements IStructuredContentProvider {
        private PropertyDescriptorContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof JavaBeanModel) {
                return ((JavaBeanModel)inputElement).getChildren().toArray();
            }
            if (inputElement.getClass().isArray()) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PropertyDescriptorLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PropertyDescriptorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/att_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JavaBeanModel) {
                JavaBeanModel p = (JavaBeanModel)element;
                switch (columnIndex) {
                    case 0: {
                        return p.getName();
                    }
                    case 1: {
                        return p.getBeanClassString();
                    }
                }
            }
            return this.getText(element);
        }
    }

    private class PropertySelectionDialog
    extends Dialog {
        private TableViewer viewer;
        private Object currentSelection;
        private JavaBeanModel beanModel;

        public PropertySelectionDialog(IShellProvider parentShell) {
            super(parentShell);
            this.beanModel = null;
        }

        public PropertySelectionDialog(Shell parentShell, IJavaProject project, JavaBeanModel beanModel) {
            super(parentShell);
            this.beanModel = null;
            this.beanModel = beanModel;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.heightHint = 400;
            gd.widthHint = 400;
            composite.setLayoutData((Object)gd);
            FillLayout fl = new FillLayout();
            fl.marginHeight = 10;
            fl.marginWidth = 10;
            composite.setLayout((Layout)fl);
            this.viewer = new TableViewer(composite, 67584);
            Table table = this.viewer.getTable();
            TableColumn nameColumn = new TableColumn(table, 0);
            nameColumn.setWidth(100);
            nameColumn.setText(Messages.JavaPropertiesSelectionDialog_NameColumnText);
            TableColumn typeColumn = new TableColumn(table, 0);
            typeColumn.setWidth(200);
            typeColumn.setText(Messages.JavaPropertiesSelectionDialog_TypeColumnText);
            table.setHeaderVisible(true);
            this.viewer.setContentProvider((IContentProvider)new PropertyDescriptorContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new PropertyDescriptorLabelProvider());
            this.viewer.setInput((Object)this.beanModel);
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    PropertySelectionDialog.this.okPressed();
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PropertySelectionDialog.this.currentSelection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.getShell().setText(String.valueOf(this.beanModel.getName()) + Messages.JavaPropertiesSelectionDialog_DialogTitle);
            return composite;
        }

        public Object getCurrentSelection() {
            return this.currentSelection;
        }

        public void setCurrentSelection(Object currentSelection) {
            this.currentSelection = currentSelection;
        }
    }
}

