/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.uitls;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectClassLoader
extends URLClassLoader {
    public ProjectClassLoader(IJavaProject project) throws JavaModelException {
        super(ProjectClassLoader.getURLSFromProject(project, null, true), Thread.currentThread().getContextClassLoader());
    }

    public ProjectClassLoader(IJavaProject project, URL[] extraUrls) throws JavaModelException {
        super(ProjectClassLoader.getURLSFromProject(project, extraUrls, true), Thread.currentThread().getContextClassLoader());
    }

    private static URL[] getURLSFromProject(IJavaProject project, URL[] extraUrls, boolean cludeRequiredProject) throws JavaModelException {
        int i;
        if (project == null || !project.exists()) {
            return new URL[0];
        }
        ArrayList<URL> list = new ArrayList<URL>();
        if (extraUrls != null) {
            int i2 = 0;
            while (i2 < extraUrls.length) {
                list.add(extraUrls[i2]);
                ++i2;
            }
        }
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        if (cludeRequiredProject) {
            String[] requiredProjectNames = project.getRequiredProjectNames();
            i = 0;
            while (i < requiredProjectNames.length) {
                URL[] requeiredURL;
                IJavaProject jp;
                String requiredProjectName = requiredProjectNames[i];
                IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjectName);
                if (requiredProject != null && requiredProject.isOpen() && (jp = JavaCore.create((IProject)requiredProject)) != null && (requeiredURL = ProjectClassLoader.getURLSFromProject(jp, extraUrls, false)) != null) {
                    int j = 0;
                    while (j < requeiredURL.length) {
                        list.add(requeiredURL[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        IPath installPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        i = 0;
        while (i < roots.length) {
            try {
                if (roots[i].isArchive()) {
                    File f = new File(FileLocator.resolve((URL)installPath.append(roots[i].getPath()).toFile().toURL()).getFile());
                    if (!f.exists()) {
                        f = new File(FileLocator.resolve((URL)roots[i].getPath().makeAbsolute().toFile().toURL()).getFile());
                    }
                    if (!f.exists()) {
                        IJavaElement javaElement = roots[i].getPrimaryElement();
                        String jarName = javaElement.getElementName();
                        IResource jarResource = project.getProject().findMember(jarName);
                        if (jarResource != null) {
                            f = jarResource.getRawLocation().toFile();
                        }
                    }
                    list.add(f.toURL());
                } else {
                    IPath path = roots[i].getJavaProject().getOutputLocation();
                    if (path.segmentCount() > 1) {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        path = root.getFolder(path).getLocation();
                        list.add(path.toFile().toURL());
                    } else {
                        path = roots[i].getJavaProject().getProject().getLocation();
                        list.add(path.toFile().toURL());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        URL[] urls = new URL[list.size()];
        int index = 0;
        Iterator i3 = list.iterator();
        while (i3.hasNext()) {
            urls[index] = (URL)i3.next();
            ++index;
        }
        return urls;
    }
}

