/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.validation10;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.PropertyUICreator;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.model.rules10.RuleBase;
import org.jboss.tools.smooks.model.rules10.RuleBasesType;
import org.jboss.tools.smooks.model.smooks.AbstractResourceConfig;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.jboss.tools.smooks.model.validation10.Validation10Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleUICreator
extends PropertyUICreator {
    @Override
    public boolean ignoreProperty(EAttribute feature) {
        if (feature == Validation10Package.Literals.RULE_TYPE__EXECUTE_ON) {
            return true;
        }
        if (feature == Validation10Package.Literals.RULE_TYPE__EXECUTE_ON_NS) {
            return true;
        }
        return super.ignoreProperty(feature);
    }

    @Override
    public List<AttributeFieldEditPart> createExtendUIOnTop(AdapterFactoryEditingDomain editingdomain, FormToolkit toolkit, Composite parent, Object model, ISmooksModelProvider formEditor, IEditorPart part) {
        return super.createExtendUIOnTop(editingdomain, toolkit, parent, model, formEditor, part);
    }

    @Override
    public AttributeFieldEditPart createPropertyUI(FormToolkit toolkit, Composite parent, IItemPropertyDescriptor propertyDescriptor, Object model, EAttribute feature, ISmooksModelProvider formEditor, IEditorPart editorPart) {
        if (feature == Validation10Package.Literals.RULE_TYPE__NAME) {
            return SmooksUIUtils.createChoiceFieldEditor(parent, toolkit, propertyDescriptor, model, this.getRuleNames(model), null, false);
        }
        return super.createPropertyUI(toolkit, parent, propertyDescriptor, model, feature, formEditor, editorPart);
    }

    private String[] getRuleNames(Object model) {
        SmooksResourceListType listType = SmooksUIUtils.getSmooks11ResourceListType((EObject)model);
        ArrayList<String> namesString = new ArrayList<String>();
        EList arList = listType.getAbstractResourceConfig();
        for (AbstractResourceConfig config : arList) {
            if (!(config instanceof RuleBasesType)) continue;
            this.fillNamesList(namesString, (RuleBasesType)config);
        }
        return namesString.toArray(new String[0]);
    }

    private void fillNamesList(List<String> namesString, RuleBasesType ruleBases) {
        EList ruleBaseList = ruleBases.getRuleBase();
        IResource resource = SmooksUIUtils.getResource((EObject)ruleBases);
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        for (RuleBase rulebase : ruleBaseList) {
            String src = rulebase.getSrc();
            IFile file = SmooksUIUtils.getFile(src, project);
            if (file == null || !file.exists()) continue;
            Properties properties = new Properties();
            String ruleBasesName = rulebase.getName();
            if (ruleBasesName == null) continue;
            try {
                properties.load(file.getContents());
            }
            catch (Throwable throwable) {
                continue;
            }
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String keyName = keys.nextElement().toString();
                namesString.add(String.valueOf(ruleBasesName) + "." + keyName);
            }
            properties.clear();
        }
    }
}

