/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.wizard;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.jboss.tools.smooks.configuration.editors.csv.CSVInputDataWizard;
import org.jboss.tools.smooks.configuration.editors.csv12.CSV12InputDataWizard;
import org.jboss.tools.smooks.configuration.editors.edi.EDIDataWizard;
import org.jboss.tools.smooks.configuration.editors.edireader12.EDIReader12DataWizard;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanContentProvider;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanStrucutredDataWizard;
import org.jboss.tools.smooks.configuration.editors.javabean.JavabeanlabelProvider;
import org.jboss.tools.smooks.configuration.editors.json.JsonDataWizard;
import org.jboss.tools.smooks.configuration.editors.json12.Json12DataWizard;
import org.jboss.tools.smooks.configuration.editors.wizard.BaseViewerInitor;
import org.jboss.tools.smooks.configuration.editors.wizard.IStructuredDataSelectionWizard;
import org.jboss.tools.smooks.configuration.editors.wizard.IViewerInitor;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataWizard;
import org.jboss.tools.smooks.configuration.editors.xml.XSDStructuredDataWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerInitorStore {
    protected static ViewerInitorStore instance = null;
    protected HashMap<String, IViewerInitor> initorMap = null;

    protected ViewerInitorStore() {
    }

    public Collection<IViewerInitor> getViewerInitorCollection() {
        HashMap<String, IViewerInitor> map = this.getInitorMap();
        if (map != null) {
            return map.values();
        }
        return null;
    }

    public IStructuredDataSelectionWizard getStructuredDataCreationWizard(String typeID) {
        if (this.getInitorMap() == null) {
            return null;
        }
        IViewerInitor initor = this.getInitorMap().get(typeID);
        if (initor == null) {
            return null;
        }
        IStructuredDataSelectionWizard wizard = initor.getStructuredDataLoadWizard();
        return wizard;
    }

    public ILabelProvider getLabelProvider(String typeID) {
        if (this.getInitorMap() == null) {
            return null;
        }
        IViewerInitor initor = this.getInitorMap().get(typeID);
        if (initor == null) {
            return null;
        }
        return initor.getLabelProvider();
    }

    public ITreeContentProvider getTreeCotentProvider(String typeID) {
        if (this.getInitorMap() == null) {
            return null;
        }
        IViewerInitor initor = this.getInitorMap().get(typeID);
        if (initor == null) {
            return null;
        }
        return initor.getTreeContentProvider();
    }

    public static synchronized ViewerInitorStore getInstance() {
        return new ViewerInitorStore();
    }

    protected HashMap<String, IViewerInitor> getInitorMap() {
        if (this.initorMap == null) {
            this.initorMap = this.createNewInitorMap();
        }
        return this.initorMap;
    }

    protected HashMap<String, IViewerInitor> createNewInitorMap() {
        HashMap<String, IViewerInitor> map = new HashMap<String, IViewerInitor>();
        BaseViewerInitor jsonViewerInitor = new BaseViewerInitor();
        String name = "JSON";
        String description = "Select Json data file as the input data.";
        String iconPath = null;
        String typeID = "input.json";
        jsonViewerInitor.setName(name);
        jsonViewerInitor.setDescription(description);
        jsonViewerInitor.setWizardIconPath(iconPath);
        jsonViewerInitor.setTypeID(typeID);
        jsonViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        jsonViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        jsonViewerInitor.setStructuredDataLoadWizard(new JsonDataWizard());
        map.put(typeID, jsonViewerInitor);
        BaseViewerInitor json12ViewerInitor = new BaseViewerInitor();
        name = "Json 1.2";
        description = "Select Json data file as the input data.(version 1.2)";
        iconPath = null;
        typeID = "input.json";
        json12ViewerInitor.setName(name);
        json12ViewerInitor.setDescription(description);
        json12ViewerInitor.setWizardIconPath(iconPath);
        json12ViewerInitor.setTypeID(typeID);
        json12ViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        json12ViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        json12ViewerInitor.setStructuredDataLoadWizard(new Json12DataWizard());
        json12ViewerInitor.setWizardIconPath("icons/full/obj16/jcu_obj.gif");
        BaseViewerInitor javabeanViewerInitor = new BaseViewerInitor();
        name = "Java";
        description = "Select a Java type(class,interface) as the input data.";
        iconPath = null;
        typeID = "input.java";
        javabeanViewerInitor.setName(name);
        javabeanViewerInitor.setDescription(description);
        javabeanViewerInitor.setWizardIconPath(iconPath);
        javabeanViewerInitor.setTypeID(typeID);
        javabeanViewerInitor.setLabelProvider((ILabelProvider)new JavabeanlabelProvider());
        javabeanViewerInitor.setTreeContentProvider(new JavabeanContentProvider());
        javabeanViewerInitor.setStructuredDataLoadWizard(new JavabeanStrucutredDataWizard());
        javabeanViewerInitor.setWizardIconPath("icons/full/obj16/jcu_obj.gif");
        map.put(typeID, javabeanViewerInitor);
        BaseViewerInitor xmlViewerInitor = new BaseViewerInitor();
        name = "XML";
        description = "Select a XML file to be the input data. ";
        iconPath = null;
        typeID = "input.xml";
        xmlViewerInitor.setName(name);
        xmlViewerInitor.setDescription(description);
        xmlViewerInitor.setWizardIconPath(iconPath);
        xmlViewerInitor.setTypeID(typeID);
        xmlViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        xmlViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        xmlViewerInitor.setStructuredDataLoadWizard(new XMLStructuredDataWizard());
        xmlViewerInitor.setWizardIconPath("icons/full/obj16/XMLFile.gif");
        map.put(typeID, xmlViewerInitor);
        BaseViewerInitor xsdViewerInitor = new BaseViewerInitor();
        name = "XSD/WSDL";
        description = "Select a XSD file to be the input data. Need to figure out a Root Element. ";
        iconPath = null;
        typeID = "input.xsd";
        xsdViewerInitor.setName(name);
        xsdViewerInitor.setDescription(description);
        xsdViewerInitor.setWizardIconPath(iconPath);
        xsdViewerInitor.setTypeID(typeID);
        xsdViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        xsdViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        xsdViewerInitor.setStructuredDataLoadWizard(new XSDStructuredDataWizard());
        xsdViewerInitor.setWizardIconPath("icons/full/obj16/XSDFile.gif");
        map.put(typeID, xsdViewerInitor);
        BaseViewerInitor csvViewerInitor = new BaseViewerInitor();
        name = "CSV";
        description = "Select CSV data file as the input data.";
        iconPath = null;
        typeID = "input.csv";
        csvViewerInitor.setName(name);
        csvViewerInitor.setDescription(description);
        csvViewerInitor.setWizardIconPath(iconPath);
        csvViewerInitor.setTypeID(typeID);
        csvViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        csvViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        csvViewerInitor.setStructuredDataLoadWizard(new CSVInputDataWizard());
        csvViewerInitor.setWizardIconPath("icons/full/obj16/csvfile.gif");
        map.put(typeID, csvViewerInitor);
        BaseViewerInitor csv12ViewerInitor = new BaseViewerInitor();
        name = "CSV 1.2";
        description = "Select CSV data file as the input data (version 1.2).";
        iconPath = null;
        typeID = "input.csv";
        csv12ViewerInitor.setName(name);
        csv12ViewerInitor.setDescription(description);
        csv12ViewerInitor.setWizardIconPath(iconPath);
        csv12ViewerInitor.setTypeID(typeID);
        csv12ViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        csv12ViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        csv12ViewerInitor.setStructuredDataLoadWizard(new CSV12InputDataWizard());
        BaseViewerInitor ediViewerInitor = new BaseViewerInitor();
        name = "EDI";
        description = "Select EDI data file as the input data.";
        iconPath = null;
        typeID = "input.edi";
        ediViewerInitor.setName(name);
        ediViewerInitor.setDescription(description);
        ediViewerInitor.setWizardIconPath(iconPath);
        ediViewerInitor.setTypeID(typeID);
        ediViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        ediViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        ediViewerInitor.setStructuredDataLoadWizard(new EDIDataWizard());
        map.put(typeID, ediViewerInitor);
        BaseViewerInitor edi12ViewerInitor = new BaseViewerInitor();
        name = "EDI 1.2";
        description = "Select EDI data file as the input data. (version 1.2)";
        iconPath = null;
        typeID = "input.edi";
        edi12ViewerInitor.setName(name);
        edi12ViewerInitor.setDescription(description);
        edi12ViewerInitor.setWizardIconPath(iconPath);
        edi12ViewerInitor.setTypeID(typeID);
        edi12ViewerInitor.setLabelProvider((ILabelProvider)new XMLStructuredDataLabelProvider());
        edi12ViewerInitor.setTreeContentProvider(new XMLStructuredDataContentProvider());
        edi12ViewerInitor.setStructuredDataLoadWizard(new EDIReader12DataWizard());
        return map;
    }
}

