/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.editors.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.xml.AbstractXMLObject;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagPropertyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagObject
extends AbstractXMLObject {
    protected List<TagPropertyObject> properties = new ArrayList<TagPropertyObject>();

    public List<TagPropertyObject> getProperties() {
        return this.properties;
    }

    public void setProperties(List<TagPropertyObject> properties) {
        this.properties = properties;
    }

    public void addProperty(TagPropertyObject pro) {
        this.getProperties().add(pro);
        if (pro != null) {
            pro.setParent(this);
        }
        Attr attribute = pro.getReferenceAttibute();
        Element parentElement = this.getReferenceElement();
        if (attribute != null && parentElement != null) {
            if (attribute.getParentNode() == parentElement) {
                return;
            }
            parentElement.appendChild(attribute);
        }
    }

    public void removeProperty(TagPropertyObject pro) {
        this.getProperties().remove(pro);
        if (pro != null) {
            pro.setParent(null);
        }
        Attr attribute = pro.getReferenceAttibute();
        Element parentElement = this.getReferenceElement();
        if (attribute != null && parentElement != null) {
            parentElement.removeAttributeNode(attribute);
        }
    }

    public void addChildTag(TagObject tag) {
        this.getXMLNodeChildren().add(tag);
        if (tag != null) {
            tag.setParent(this);
        }
        Element childElement = tag.getReferenceElement();
        Element parentElement = this.getReferenceElement();
        if (childElement != null && parentElement != null) {
            if (childElement.getParentNode() == parentElement) {
                return;
            }
            parentElement.appendChild(childElement);
        }
    }

    public void removeChildTag(TagObject tag) {
        this.getXMLNodeChildren().remove(tag);
        if (tag != null) {
            tag.setParent(null);
        }
        Element childElement = tag.getReferenceElement();
        Element parentElement = this.getReferenceElement();
        if (childElement != null && parentElement != null) {
            parentElement.removeChild(childElement);
        }
    }

    @Override
    public List<IXMLStructuredObject> getChildren() {
        ArrayList<IXMLStructuredObject> all = new ArrayList<IXMLStructuredObject>();
        List<AbstractXMLObject> tags = this.getXMLNodeChildren();
        List<TagPropertyObject> properties = this.getProperties();
        all.addAll(properties);
        all.addAll(tags);
        return all;
    }

    public String toString() {
        String blankString = "";
        int deep = -1;
        AbstractXMLObject parent = this;
        while (parent != null && !(parent instanceof TagList)) {
            ++deep;
            parent = parent.getParent();
        }
        int i = 0;
        while (i < deep) {
            blankString = String.valueOf(blankString) + "\t";
            ++i;
        }
        StringBuffer propertyesBuffer = new StringBuffer();
        for (TagPropertyObject pro : this.properties) {
            propertyesBuffer.append(" " + pro.getName() + "=\"\"");
        }
        StringBuffer buffer = null;
        buffer = propertyesBuffer.length() == 0 ? new StringBuffer(String.valueOf(blankString) + "<" + this.getName() + ">") : new StringBuffer(String.valueOf(blankString) + "<" + this.getName() + propertyesBuffer.toString() + ">");
        List<AbstractXMLObject> l = this.getXMLNodeChildren();
        if (!l.isEmpty()) {
            buffer.append("\n");
        }
        Iterator<AbstractXMLObject> iterator = l.iterator();
        while (iterator.hasNext()) {
            TagObject tag = (TagObject)iterator.next();
            buffer.append(tag.toString());
            if (!iterator.hasNext()) continue;
            buffer.append("\n");
        }
        if (l.isEmpty()) {
            buffer.append("</" + this.getName() + ">");
        } else {
            buffer.append("\n" + blankString + "</" + this.getName() + ">");
        }
        return buffer.toString();
    }
}

