/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.SelectorCreationDialog;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.validate.AbstractValidator;
import org.jboss.tools.smooks.configuration.validate.Messages;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.ExpressionType;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;
import org.jboss.tools.smooks.model.smooks.DocumentRoot;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorValidator
extends AbstractValidator {
    private List<Object> list = new ArrayList<Object>();

    @Override
    public List<Diagnostic> validate(Collection<?> selectedObjects, EditingDomain editingDomain) {
        return super.validate(selectedObjects, editingDomain);
    }

    @Override
    protected Diagnostic validateModel(Object model, EditingDomain editingDomain) {
        if (model instanceof EObject) {
            EStructuralFeature feature = this.getAttribute(model);
            if (feature == null) {
                return null;
            }
            Object data = ((EObject)model).eGet(feature);
            if (data == null) {
                if (feature instanceof EAttribute && model instanceof BeanType) {
                    return this.newWaringDiagnostic(Messages.SelectorValidator_Warning_Must_Be_Linked_to_Source, model, (EAttribute)feature);
                }
                return null;
            }
            String path = data.toString();
            if (path != null) {
                path = path.trim();
            }
            String sperator = "/";
            if (path.indexOf(47) == -1) {
                sperator = " ";
            }
            if ((path == null || path.length() == 0) && feature instanceof EAttribute && model instanceof BeanType) {
                return this.newWaringDiagnostic(Messages.SelectorValidator_Warning_Must_Be_Linked_to_Source, model, (EAttribute)feature);
            }
            if (feature != null && path != null) {
                if ("#document".equals(path)) {
                    return null;
                }
                IXMLStructuredObject node = null;
                for (Object obj : this.list) {
                    if (!(obj instanceof IXMLStructuredObject)) continue;
                    if (node == null) {
                        try {
                            node = SmooksUIUtils.localXMLNodeWithPath(path, (IXMLStructuredObject)obj, sperator, false);
                        }
                        catch (Throwable e) {
                            SmooksConfigurationActivator.getDefault();
                            SmooksConfigurationActivator.log(e);
                        }
                    }
                    if (node == null) continue;
                    return null;
                }
                if (node == null && feature instanceof EAttribute) {
                    if (model instanceof BeanType || model instanceof ValueType || model instanceof WiringType || model instanceof ExpressionType) {
                        return this.newWaringDiagnostic(String.valueOf(Messages.SelectorValidator_Warning_Cannot_Find_Input_Source) + path + "'", model, (EAttribute)feature);
                    }
                    return this.newWaringDiagnostic(String.valueOf(Messages.SelectorValidator_Warning_Selector) + path + Messages.SelectorValidator_Warning_Is_Not_Available, model, (EAttribute)feature);
                }
            }
        }
        return super.validateModel(model, editingDomain);
    }

    private EStructuralFeature getAttribute(Object model) {
        return SmooksUIUtils.getSelectorFeature((EObject)model);
    }

    @Override
    public void initValidator(Collection<?> selectedObjects, EditingDomain editingDomain) {
        this.list.clear();
        Resource resource = (Resource)editingDomain.getResourceSet().getResources().get(0);
        if (resource.getContents().isEmpty()) {
            return;
        }
        Object obj = resource.getContents().get(0);
        SmooksResourceListType listType = null;
        if (obj instanceof DocumentRoot) {
            listType = ((DocumentRoot)obj).getSmooksResourceList();
            IResource r = SmooksUIUtils.getResource((EObject)listType);
            IFile file = null;
            if (r instanceof IFile) {
                file = (IFile)r;
            }
            if (file == null) {
                return;
            }
            IContentType contentType = null;
            try {
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    contentType = contentDescription.getContentType();
                }
            }
            catch (Throwable throwable) {}
            IContentType smooksContentType = Platform.getContentTypeManager().getContentType("org.jboss.tools.smooks.ui.smooks.contentType");
            IContentType ediMappingContentType = Platform.getContentTypeManager().getContentType("org.jboss.tools.smooks.ui.edimap.contentType");
            if (!smooksContentType.equals(contentType) && !ediMappingContentType.equals(contentType)) {
                return;
            }
            final SmooksResourceListType finalList = listType;
            Display dis = SmooksConfigurationActivator.getDefault().getWorkbench().getDisplay();
            if (dis != null && !dis.isDisposed()) {
                dis.syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow window = SmooksConfigurationActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage activePage = window.getActivePage();
                        if (activePage != null) {
                            try {
                                List<Object> l = SelectorCreationDialog.generateInputData(finalList);
                                if (l != null) {
                                    SelectorValidator.this.list.addAll(l);
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }
}

