/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.smooks.configuration.actions.AddSmooksResourceAction;
import org.jboss.tools.smooks.configuration.editors.actions.Calc11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Database11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Datasources11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.FragmentRouting11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.ISmooksActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.JavaBean11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.PersistenceActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Reader11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Scripting11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Templating11ActionGrouper;
import org.jboss.tools.smooks.configuration.editors.actions.Validation10ActionGrouper;
import org.jboss.tools.smooks.configuration.wizards.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSmooksElementWizardPage
extends WizardPage {
    private Collection<IAction> childDescriptor = null;
    private IAction selectedAction;
    private TreeViewer actionViewer = null;
    private ViewerFilter[] filters;

    public NewSmooksElementWizardPage(String pageName, String title, ImageDescriptor titleImage, Collection<IAction> childDescriptor, ViewerFilter[] filters, String text, String description) {
        super(pageName, title, titleImage);
        this.childDescriptor = childDescriptor;
        this.setTitle(Messages.NewSmooksElementWizardPage_Page_Title);
        this.setDescription(Messages.NewSmooksElementWizardPage_Page_Description);
        if (text != null) {
            this.setTitle(text);
        }
        if (description != null) {
            this.setDescription(description);
        }
        this.filters = filters;
    }

    public NewSmooksElementWizardPage(String pageName, Collection<IAction> childDescriptor, ViewerFilter[] filters, String text, String description) {
        super(pageName);
        this.childDescriptor = childDescriptor;
        this.setTitle(Messages.NewSmooksElementWizardPage_Page_Title);
        this.setDescription(Messages.NewSmooksElementWizardPage_Page_Description);
        if (text != null) {
            this.setTitle(text);
        }
        if (description != null) {
            this.setDescription(description);
        }
        this.filters = filters;
    }

    public void createControl(Composite parent) {
        this.selectedAction = null;
        this.actionViewer = new TreeViewer(parent, 2048);
        GridData gd = new GridData(1808);
        this.actionViewer.getControl().setLayoutData((Object)gd);
        this.actionViewer.setContentProvider((IContentProvider)new SmooksElementActionsContentProvider());
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new SmooksElementActionsLabelProvider());
        this.actionViewer.setInput(this.getActions());
        this.actionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewSmooksElementWizardPage.this.selectedAction = (IAction)((IStructuredSelection)event.getSelection()).getFirstElement();
                NewSmooksElementWizardPage.this.updatePageStatus();
            }
        });
        this.actionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
        this.setControl((Control)parent);
    }

    public IAction getSelectedAction() {
        return this.selectedAction;
    }

    protected void updatePageStatus() {
        this.setPageComplete(true);
        if (this.selectedAction instanceof GroupAction) {
            this.setPageComplete(false);
        }
    }

    private void filterAction() {
        if (this.filters != null) {
            block0: for (AddSmooksResourceAction addSmooksResourceAction : this.childDescriptor) {
                if (!addSmooksResourceAction.isEnabled()) continue;
                int i = 0;
                while (i < this.filters.length) {
                    CommandParameter parameter;
                    ViewerFilter vf = this.filters[i];
                    Object descriptor = addSmooksResourceAction.getDescriptor();
                    if (descriptor instanceof CommandParameter && (parameter = (CommandParameter)descriptor).getValue() != null) {
                        Object value = AdapterFactoryEditingDomain.unwrap((Object)parameter.getValue());
                        boolean enable = vf.select(null, null, value);
                        addSmooksResourceAction.setEnabled(enable);
                        if (!enable) continue block0;
                    }
                    ++i;
                }
            }
        }
    }

    private Collection<IAction> getActions() {
        this.filterAction();
        ArrayList<IAction> actions = new ArrayList<IAction>();
        List<ISmooksActionGrouper> grouperList = this.getSmooksActionGrouper();
        for (ISmooksActionGrouper iSmooksActionGrouper : grouperList) {
            GroupAction ga = new GroupAction();
            ga.setText(iSmooksActionGrouper.getGroupName());
            this.fillGroupAction(ga, iSmooksActionGrouper);
            if (ga.getChildrenAction().isEmpty()) continue;
            actions.add((IAction)ga);
        }
        ArrayList tempActions = new ArrayList(actions);
        for (IAction c : this.childDescriptor) {
            boolean exsit = false;
            for (IAction iAction : tempActions) {
                List<IAction> childrenAction;
                if (!(iAction instanceof GroupAction) || (childrenAction = ((GroupAction)iAction).getChildrenAction()).indexOf(c) == -1) continue;
                exsit = true;
                break;
            }
            if (exsit || !c.isEnabled()) continue;
            actions.add(c);
        }
        return actions;
    }

    private void fillGroupAction(GroupAction ga, ISmooksActionGrouper grouper) {
        if (this.childDescriptor != null) {
            for (AddSmooksResourceAction addSmooksResourceAction : this.childDescriptor) {
                Object descriptor = addSmooksResourceAction.getDescriptor();
                if (!grouper.belongsToGroup(descriptor) || !addSmooksResourceAction.isEnabled()) continue;
                ga.addAction((IAction)addSmooksResourceAction);
            }
        }
    }

    private List<ISmooksActionGrouper> getSmooksActionGrouper() {
        ArrayList<ISmooksActionGrouper> grouperList = new ArrayList<ISmooksActionGrouper>();
        grouperList.add(new JavaBean11ActionGrouper());
        grouperList.add(new Reader11ActionGrouper());
        grouperList.add(new Calc11ActionGrouper());
        grouperList.add(new Database11ActionGrouper());
        grouperList.add(new Datasources11ActionGrouper());
        grouperList.add(new FragmentRouting11ActionGrouper());
        grouperList.add(new Scripting11ActionGrouper());
        grouperList.add(new Templating11ActionGrouper());
        grouperList.add(new PersistenceActionGrouper());
        grouperList.add(new Validation10ActionGrouper());
        return grouperList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupAction
    extends Action {
        private List<IAction> childrenAction = null;

        private GroupAction() {
        }

        public void run() {
        }

        public List<IAction> getChildrenAction() {
            if (this.childrenAction == null) {
                this.childrenAction = new ArrayList<IAction>();
            }
            return this.childrenAction;
        }

        public void addAction(IAction action) {
            this.getChildrenAction().add(action);
        }
    }

    private class SmooksElementActionsContentProvider
    implements ITreeContentProvider {
        private SmooksElementActionsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof GroupAction) {
                return ((GroupAction)((Object)parentElement)).getChildrenAction().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Collection) {
                return !((Collection)element).isEmpty();
            }
            if (element instanceof GroupAction) {
                return !((GroupAction)((Object)element)).getChildrenAction().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SmooksElementActionsLabelProvider
    extends LabelProvider {
        private Map<Object, Object> imageMap = new HashMap<Object, Object>();

        private SmooksElementActionsLabelProvider() {
        }

        public void dispose() {
            if (this.imageMap != null) {
                Collection<Object> values = this.imageMap.values();
                for (Object object : values) {
                    if (object == null || !(object instanceof Image)) continue;
                    ((Image)object).dispose();
                }
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            if (element instanceof IAction) {
                String key = ((IAction)element).getText();
                Image img = (Image)this.imageMap.get(key);
                if (img == null) {
                    ImageDescriptor id = ((IAction)element).getImageDescriptor();
                    if (id == null) {
                        return null;
                    }
                    img = id.createImage();
                    ((IAction)element).getDisabledImageDescriptor();
                    this.imageMap.put(key, img);
                }
                return img;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IAction) {
                return ((IAction)element).getText();
            }
            return super.getText(element);
        }
    }
}

