/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.configuration.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.configuration.wizards.Messages;
import org.jboss.tools.smooks.configuration.wizards.SmooksFileContainerSelectionPage;

public class SmooksConfigurationFileNewWizard
extends Wizard
implements INewWizard {
    private SmooksFileContainerSelectionPage containerSelectionPage;
    private ISelection selection;

    public SmooksConfigurationFileNewWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(SmooksConfigurationActivator.getImageDescriptor(Messages.SmooksConfigurationFileNewWizard_0));
    }

    public void addPages() {
        this.containerSelectionPage = new SmooksFileContainerSelectionPage(Messages.SmooksConfigurationFileNewWizard_PageName, (IStructuredSelection)this.selection);
        this.addPage((IWizardPage)this.containerSelectionPage);
    }

    public boolean performFinish() {
        final IPath containerPath = this.containerSelectionPage.getContainerFullPath();
        final String fileName = this.containerSelectionPage.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        SmooksConfigurationFileNewWizard.this.doFinish(containerPath, fileName, monitor, "1.2");
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SmooksConfigurationFileNewWizard_ErrorDialogTitle, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IPath containerPath, String fileName, IProgressMonitor monitor, String version) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(containerPath);
        IContainer container = null;
        if (resource.exists() && resource instanceof IContainer) {
            container = (IContainer)resource;
        }
        if (container == null) {
            this.throwCoreException("Container \"" + containerPath.toPortableString() + "\" does not exist.");
        }
        final IFile configFile = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(version);
            if (configFile.exists()) {
                configFile.setContents(stream, true, true, monitor);
            } else {
                configFile.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException e) {
            SmooksConfigurationActivator.getDefault();
            SmooksConfigurationActivator.log(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file with Smooks Editor.");
        final String fversion = version;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                FileEditorInput editorInput = new FileEditorInput(configFile);
                try {
                    if (fversion.equals("1.2")) {
                        page.openEditor((IEditorInput)editorInput, "org.jboss.tools.smooks.configuration.editors.MultiPageEditor", true);
                    }
                }
                catch (PartInitException e) {
                    SmooksConfigurationActivator.getDefault();
                    SmooksConfigurationActivator.log(e);
                }
            }
        });
        monitor.worked(1);
    }

    public static void createExtentionFile(IFile file, String version, String inputType, IProgressMonitor monitor) throws CoreException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        InputStream stream1 = SmooksConfigurationFileNewWizard.createExtContentStream(version, inputType);
        if (file.exists()) {
            file.setContents(stream1, true, true, monitor);
        } else {
            file.create(stream1, true, monitor);
        }
        stream1.close();
    }

    public static InputStream createExtContentStream(String version, String inputType) {
        String typeContents = null;
        if (inputType != null) {
            typeContents = "inputType = \"" + inputType + "\"";
        }
        String contents = "";
        contents = typeContents == null ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private InputStream openContentStream(String version) {
        String contents = "";
        if ("1.2".equals(version)) {
            contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<smooks-resource-list xmlns=\"http://www.milyn.org/xsd/smooks-1.1.xsd\">\n\t\t<params>\n\t\t\t<param name=\"stream.filter.type\">SAX</param>\n\t\t</params>\n</smooks-resource-list>";
        }
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.jboss.tools.smooks.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

