/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.jboss.tools.smooks.configuration.editors.AttributeFieldEditPart;
import org.jboss.tools.smooks.configuration.editors.IFilePathProcessor;
import org.jboss.tools.smooks.configuration.editors.IXMLStructuredObject;
import org.jboss.tools.smooks.configuration.editors.ModelPanelCreator;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.configuration.editors.xml.TagList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataContentProvider;
import org.jboss.tools.smooks.configuration.editors.xml.XMLStructuredDataLabelProvider;
import org.jboss.tools.smooks.configuration.validate.ISmooksModelValidateListener;
import org.jboss.tools.smooks.edimap.actions.AddComponentAction;
import org.jboss.tools.smooks.edimap.actions.AddFieldAction;
import org.jboss.tools.smooks.edimap.actions.AddSegmentAction;
import org.jboss.tools.smooks.edimap.actions.AddSubComponentAction;
import org.jboss.tools.smooks.edimap.editor.EDIEditPartFactory;
import org.jboss.tools.smooks.edimap.editor.EDIFileParser;
import org.jboss.tools.smooks.edimap.editor.EDIGraphicalTreeLabelProvider;
import org.jboss.tools.smooks.edimap.editor.EDIMappingMenuContextProvider;
import org.jboss.tools.smooks.edimap.editor.EDIMappingResultDialog;
import org.jboss.tools.smooks.edimap.editor.EDISegementsEditPart;
import org.jboss.tools.smooks.edimap.editor.Messages;
import org.jboss.tools.smooks.edimap.models.EDIDataContainerGraphModel;
import org.jboss.tools.smooks.edimap.models.EDIMappingNodeContainerGraphModel;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.common.RootModel;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.editparts.RootEditPart;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.model.medi.Delimiters;
import org.jboss.tools.smooks.model.medi.Description;
import org.jboss.tools.smooks.model.medi.DocumentRoot;
import org.jboss.tools.smooks.model.medi.Segment;
import org.jboss.tools.smooks.model.medi.Segments;
import org.milyn.Smooks;
import org.milyn.SmooksUtil;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.smooks.edi.SmooksEDIReader;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIMapFormPage
extends FormPage
implements ISmooksModelValidateListener,
ISelectionChangedListener,
ModifyListener {
    private ISmooksModelProvider modelProvider;
    private Delimiters delimiters = null;
    private Description description = null;
    private AdapterFactoryEditingDomain editingDomain;
    private ModelPanelCreator delimitersCreator;
    private ModelPanelCreator descriptionCreator;
    private ModelPanelCreator segmentsCreator;
    private Composite mappingModelPropertiesComposite;
    private String ediFilePath = null;
    private GraphicalViewer graphicalViewer;
    private Segments segments = null;
    private RootModel graphicalRootModel;
    private ActionRegistry actionRegistry;
    private DefaultEditDomain editDomain = null;
    private Composite descriptorComposite;
    private Composite delimitersComposite;
    private String ediFileEncoding = "UTF-8";

    public EDIMapFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        if (editor instanceof ISmooksModelProvider) {
            this.modelProvider = (ISmooksModelProvider)editor;
        }
        this.segmentsCreator = new ModelPanelCreator();
    }

    public EDIMapFormPage(String id, String title) {
        super(id, title);
    }

    @Override
    public void validateEnd(List<Diagnostic> diagnosticResult) {
        if (this.delimitersCreator != null) {
            this.delimitersCreator.markPropertyUI(this.modelProvider.getDiagnosticList());
        }
        if (this.descriptionCreator != null) {
            this.descriptionCreator.markPropertyUI(this.modelProvider.getDiagnosticList());
        }
        if (this.segmentsCreator != null) {
            if (this.getGraphicalViewer() == null) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.getGraphicalViewer().getSelection();
            if (selection.size() > 1) {
                return;
            }
            Object model = selection.getFirstElement();
            if (model instanceof EditPart) {
                model = ((EditPart)model).getModel();
            }
            if (model != null && model instanceof TreeNodeModel && (model = ((TreeNodeModel)model).getData()) instanceof EObject) {
                this.segmentsCreator.markPropertyUI(this.modelProvider.getDiagnosticList(), (EObject)model);
            }
        }
    }

    @Override
    public void validateStart() {
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected void initGraphicalModel() {
        if (this.graphicalRootModel == null) {
            this.graphicalRootModel = new RootModel();
        } else {
            this.graphicalRootModel.removeAllTreeNode();
        }
        DocumentRoot root = (DocumentRoot)this.modelProvider.getSmooksModel();
        Segments segments = root.getEdimap().getSegments();
        EDIMappingNodeContainerGraphModel container = new EDIMappingNodeContainerGraphModel(segments, (ITreeContentProvider)new AdapterFactoryContentProvider(this.editingDomain.getAdapterFactory()), (ILabelProvider)new EDIGraphicalTreeLabelProvider(this.editingDomain.getAdapterFactory()), this.modelProvider);
        container.setHeaderVisable(true);
        this.graphicalRootModel.addTreeNode(container);
        this.ediFilePath = this.getEDIFilePath();
        this.createEDIDataGraphModel();
        List<TreeNodeModel> linkedSourceModel = this.createLinkModel();
        this.getGraphicalViewer().setContents((Object)this.graphicalRootModel);
        this.expandSegmentNode(linkedSourceModel);
    }

    private void expandSegmentNode(List<TreeNodeModel> linkedSourceModel) {
        EditPart editPart = this.getGraphicalViewer().getContents();
        EDISegementsEditPart segmentsPart = null;
        if (editPart instanceof RootEditPart) {
            List children = ((RootEditPart)editPart).getChildren();
            for (Object object : children) {
                if (!(object instanceof EDISegementsEditPart)) continue;
                segmentsPart = (EDISegementsEditPart)object;
                break;
            }
        }
        if (segmentsPart != null) {
            SmooksUIUtils.expandGraphTree(linkedSourceModel, segmentsPart);
        }
    }

    protected void initializeGraphicalViewer() {
        this.initGraphicalModel();
    }

    protected void createGEFActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new DeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new SaveAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new AddSegmentAction((IWorkbenchPart)this, this.modelProvider);
        registry.registerAction((IAction)action);
        action = new AddFieldAction((IWorkbenchPart)this, this.modelProvider);
        registry.registerAction((IAction)action);
        action = new AddComponentAction((IWorkbenchPart)this, this.modelProvider);
        registry.registerAction((IAction)action);
        action = new AddSubComponentAction((IWorkbenchPart)this, this.modelProvider);
        registry.registerAction((IAction)action);
        Iterator it = registry.getActions();
        while (it.hasNext()) {
            IAction a = (IAction)it.next();
            if (!(a instanceof SelectionAction)) continue;
            ((SelectionAction)a).setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        }
    }

    protected void configureGraphicalViewer() {
        this.createGEFActions();
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.button);
        this.getGraphicalViewer().setRootEditPart((org.eclipse.gef.RootEditPart)new FreeformGraphicalRootEditPart());
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new EDIEditPartFactory());
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(this.getGraphicalViewer());
        keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        EDIMappingMenuContextProvider provider = new EDIMappingMenuContextProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
    }

    public void rebuildGUI() {
        IItemPropertySource itemPropertySource;
        this.initEDIModels();
        this.disposeCompositeControls(this.descriptorComposite, null);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        if (this.descriptionCreator != null) {
            itemPropertySource = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt((Notifier)this.description, IItemPropertySource.class);
            this.descriptionCreator.createModelPanel((EObject)this.description, toolkit, this.descriptorComposite, itemPropertySource, this.modelProvider, (IEditorPart)this.getEditor());
        }
        this.descriptorComposite.getParent().layout();
        this.disposeCompositeControls(this.delimitersComposite, null);
        if (this.delimitersCreator != null) {
            itemPropertySource = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt((Notifier)this.delimiters, IItemPropertySource.class);
            Map<Object, Object> fieldEditorMap = this.delimitersCreator.createModelPanel((EObject)this.delimiters, toolkit, this.delimitersComposite, itemPropertySource, this.modelProvider, (IEditorPart)this.getEditor());
            this.handleDelimiterFieldEditor(fieldEditorMap);
        }
        this.delimitersComposite.getParent().layout();
        this.initGraphicalModel();
    }

    private void handleDelimiterFieldEditor(Map<Object, Object> fieldEditorMap) {
    }

    private void removeEDIGraphModel() {
        List<AbstractSmooksGraphicalModel> children = this.graphicalRootModel.getChildren();
        ArrayList<AbstractSmooksGraphicalModel> temp = new ArrayList<AbstractSmooksGraphicalModel>(children);
        for (AbstractSmooksGraphicalModel treeNodeModel : temp) {
            if (!(treeNodeModel.getData() instanceof TagObject)) continue;
            this.graphicalRootModel.removeTreeNode(treeNodeModel);
        }
        temp.clear();
        temp = null;
    }

    private String getEDIFilePath() {
        return null;
    }

    private String getEDIFileEncoding() {
        return null;
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected void updateSelectionActions() {
        Iterator iterator = this.getActionRegistry().getActions();
        while (iterator.hasNext()) {
            Object type = iterator.next();
            if (!(type instanceof UpdateAction)) continue;
            ((UpdateAction)type).update();
        }
    }

    protected void hookGraphicalViewer() {
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
        this.graphicalViewer.setEditDomain((EditDomain)this.editDomain);
        this.editDomain.addViewer((EditPartViewer)this.graphicalViewer);
    }

    public Object getAdapter(Class type) {
        if (type == CommandStack.class && this.editDomain != null) {
            return this.editDomain.getCommandStack();
        }
        if (type == ISmooksModelProvider.class) {
            return this.modelProvider;
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(type);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.editDomain.getCommandStack().addCommandStackListener(new org.eclipse.gef.commands.CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                EDIMapFormPage.this.updateSelectionActions();
                EDIMapFormPage.this.getEditor().editorDirtyStateChanged();
            }
        });
        if (this.modelProvider != null) {
            this.initEDIModels();
            IItemPropertySource propertySource1 = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt((Notifier)this.delimiters, IItemPropertySource.class);
            this.delimitersCreator = new ModelPanelCreator((EObject)this.delimiters, propertySource1);
            IItemPropertySource propertySource2 = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt((Notifier)this.description, IItemPropertySource.class);
            this.descriptionCreator = new ModelPanelCreator((EObject)this.description, propertySource2);
            this.handleCommandStack(this.editingDomain.getCommandStack());
        }
    }

    protected void initEDIModels() {
        DocumentRoot root = (DocumentRoot)this.modelProvider.getSmooksModel();
        this.delimiters = root.getEdimap().getDelimiters();
        this.description = root.getEdimap().getDescription();
        this.segments = root.getEdimap().getSegments();
        if (this.segments.getXmltag() == null) {
            this.segments.setXmltag("root");
        }
        this.editingDomain = (AdapterFactoryEditingDomain)this.modelProvider.getEditingDomain();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.modelProvider != null) {
            try {
                this.editDomain.getCommandStack().flush();
                this.firePropertyChange(257);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean isDirty() {
        if (this.editDomain != null) {
            return this.editDomain.getCommandStack().isDirty();
        }
        return super.isDirty();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.EDIMapFormPage_Form_Title);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 13;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)gridLayout);
        Section descriptionSection = toolkit.createSection(form.getBody(), 384);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        descriptionSection.setLayoutData((Object)gd);
        descriptionSection.setText(Messages.EDIMapFormPage_Description_Section_Title);
        FillLayout flayout = new FillLayout();
        descriptionSection.setLayout((Layout)flayout);
        Composite desciptorContainer = toolkit.createComposite((Composite)descriptionSection);
        GridLayout dgl = new GridLayout();
        dgl.marginHeight = 0;
        dgl.marginWidth = 0;
        desciptorContainer.setLayout((Layout)dgl);
        descriptionSection.setClient((Control)desciptorContainer);
        this.descriptorComposite = toolkit.createComposite(desciptorContainer, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.descriptorComposite.setLayout((Layout)gl);
        gd = new GridData(1808);
        this.descriptorComposite.setLayoutData((Object)gd);
        if (this.descriptionCreator != null) {
            this.descriptionCreator.createModelPanel(toolkit, this.descriptorComposite, this.modelProvider, (IEditorPart)this.getEditor());
        }
        Section delimiterSection = toolkit.createSection(form.getBody(), 384);
        gd = new GridData(768);
        gd.verticalAlignment = 1;
        gd.verticalSpan = 2;
        delimiterSection.setLayoutData((Object)gd);
        delimiterSection.setText(Messages.EDIMapFormPage_Delimiter_Section_Title);
        FillLayout flayout1 = new FillLayout();
        delimiterSection.setLayout((Layout)flayout1);
        this.delimitersComposite = toolkit.createComposite((Composite)delimiterSection, 0);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 2;
        this.delimitersComposite.setLayout((Layout)gl1);
        delimiterSection.setClient((Control)this.delimitersComposite);
        if (this.delimitersCreator != null) {
            Map<Object, Object> editPartMap = this.delimitersCreator.createModelPanel(toolkit, this.delimitersComposite, this.modelProvider, (IEditorPart)this.getEditor());
            this.handleDelimiterFieldEditor(editPartMap);
        }
        Section testSection = toolkit.createSection(form.getBody(), 384);
        testSection.setVisible(false);
        gd = new GridData(768);
        gd.verticalAlignment = 1;
        testSection.setLayoutData((Object)gd);
        testSection.setText(Messages.EDIMapFormPage_EDI_File_Setting_Section);
        FillLayout flayout2 = new FillLayout();
        testSection.setLayout((Layout)flayout2);
        Composite fileComposite = toolkit.createComposite((Composite)testSection, 0);
        GridLayout fgl = new GridLayout();
        fgl.numColumns = 2;
        fileComposite.setLayout((Layout)fgl);
        testSection.setClient((Control)fileComposite);
        AttributeFieldEditPart pathEditPart = SmooksUIUtils.createStringFieldEditor(Messages.EDIMapFormPage_EDI_File_Field, fileComposite, (EditingDomain)this.editingDomain, toolkit, null, null, false, false, true, new IFilePathProcessor(){

            public String processFileSystemPath(String filePath) {
                return filePath;
            }

            public String processWorkBenchPath(IFile file) {
                String s = file.getFullPath().toPortableString();
                s = "Workspace:/" + s;
                return s;
            }
        }, 0, null, -1, null, false);
        Text ediFileText = (Text)pathEditPart.getContentControl();
        String filePath = this.getEDIFilePath();
        if (filePath != null) {
            ediFileText.setText(filePath);
        }
        ediFileText.addModifyListener((ModifyListener)this);
        AttributeFieldEditPart encodingEditPart = SmooksUIUtils.createStringFieldEditor(Messages.EDIMapFormPage_EDI_File_Encoding_Field, fileComposite, (EditingDomain)this.editingDomain, toolkit, null, null, false, false, false, 0, null, -1, null);
        Text encodingText = (Text)encodingEditPart.getContentControl();
        String encoding = this.getEDIFileEncoding();
        if (encoding != null) {
            encodingText.setText(encoding);
        }
        encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Section ediModelViewerSection = toolkit.createSection(form.getBody(), 256);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        ediModelViewerSection.setLayoutData((Object)gd);
        ediModelViewerSection.setText(Messages.EDIMapFormPage_Graphical_Mapping_Section);
        FillLayout flayout3 = new FillLayout();
        ediModelViewerSection.setLayout((Layout)flayout3);
        Composite viewerComposite = toolkit.createComposite((Composite)ediModelViewerSection);
        ediModelViewerSection.setClient((Control)viewerComposite);
        GridLayout vgl = new GridLayout();
        vgl.numColumns = 2;
        viewerComposite.setLayout((Layout)vgl);
        Hyperlink showTransformResultLink = toolkit.createHyperlink(viewerComposite, Messages.EDIMapFormPage_Show_Result_Link, 0);
        showTransformResultLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                EDIMapFormPage.this.testEDITransform();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        showTransformResultLink.setLayoutData((Object)gd);
        showTransformResultLink.setEnabled(false);
        showTransformResultLink.setVisible(false);
        SashForm sashForm = new SashForm(viewerComposite, 0);
        gd = new GridData(1808);
        sashForm.setLayoutData((Object)gd);
        Composite tagComposite = toolkit.createComposite((Composite)sashForm);
        tagComposite.setBackground(new Color(null, 128, 128, 128));
        FillLayout tagLayout = new FillLayout();
        tagLayout.marginHeight = 1;
        tagLayout.marginWidth = 1;
        tagComposite.setLayout((Layout)tagLayout);
        this.createGraphicalViewer(tagComposite);
        Composite mc = toolkit.createComposite((Composite)sashForm);
        GridLayout mcgl = new GridLayout();
        mc.setLayout((Layout)mcgl);
        toolkit.createLabel(mc, Messages.EDIMapFormPage_Label_Properties);
        Composite cs = toolkit.createCompositeSeparator(mc);
        gd = new GridData(768);
        gd.heightHint = 1;
        cs.setLayoutData((Object)gd);
        this.mappingModelPropertiesComposite = toolkit.createComposite(mc);
        gd = new GridData(1808);
        this.mappingModelPropertiesComposite.setLayoutData((Object)gd);
        GridLayout mgl = new GridLayout();
        mgl.numColumns = 2;
        this.mappingModelPropertiesComposite.setLayout((Layout)mgl);
        sashForm.setWeights(new int[]{10, 3});
    }

    private void handleCommandStack(org.eclipse.emf.common.command.CommandStack commandStack) {
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                final Command mostRecentCommand = ((org.eclipse.emf.common.command.CommandStack)event.getSource()).getMostRecentCommand();
                EDIMapFormPage.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (mostRecentCommand != null) {
                            Command rawCommand = mostRecentCommand;
                            while (rawCommand instanceof CommandWrapper) {
                                rawCommand = ((CommandWrapper)rawCommand).getCommand();
                            }
                            if (rawCommand instanceof SetCommand || rawCommand instanceof AddCommand || rawCommand instanceof DeleteCommand) {
                                EDIMapFormPage.this.refershRecentAffectedModel(rawCommand, mostRecentCommand.getAffectedObjects());
                            }
                        }
                    }
                });
            }
        });
    }

    private void refershRecentAffectedModel(Command command, Collection<?> models) {
        for (Object object : models) {
            if (object == this.delimiters) {
                this.rebuildEDIGraph();
                continue;
            }
            TreeNodeModel node = this.findEDIGraphicalModel(object);
            if (node == null) continue;
            if (command instanceof SetCommand) {
                node.fireVisualChanged();
            }
            if (!(command instanceof AddCommand) && !(command instanceof DeleteCommand)) continue;
            node.fireChildrenChanged();
            node.fireConnectionChanged();
        }
    }

    private void createEDIDataGraphModel() {
        if (this.ediFilePath != null) {
            try {
                if (!new File(SmooksUIUtils.parseFilePath(this.ediFilePath)).exists()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (this.delimiters != null && this.ediFilePath != null) {
            String segment = this.delimiters.getSegment();
            String field = this.delimiters.getField();
            String component = this.delimiters.getComponent();
            String subComponent = this.delimiters.getSubComponent();
            char se = '\u0001';
            char f = '\u0001';
            char c = '\u0001';
            char su = '\u0001';
            if (segment != null && segment.length() == 1) {
                se = segment.toCharArray()[0];
            }
            if (field != null && field.length() == 1) {
                f = field.toCharArray()[0];
            }
            if (component != null && component.length() == 1) {
                c = component.toCharArray()[0];
            }
            if (subComponent != null && subComponent.length() == 1) {
                su = subComponent.toCharArray()[0];
            }
            EDIFileParser parser = new EDIFileParser();
            try {
                TagList tl = parser.parserEDIFile(this.ediFilePath, se, f, c, su);
                List<IXMLStructuredObject> children = tl.getChildren();
                for (IXMLStructuredObject object : children) {
                    EDIDataContainerGraphModel container = new EDIDataContainerGraphModel(object, new XMLStructuredDataContentProvider(), (ILabelProvider)new XMLStructuredDataLabelProvider());
                    container.setHeaderVisable(true);
                    this.graphicalRootModel.addTreeNode(container);
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void disconnectSegement(List<Segment> segmentList) {
        for (Segment segment : segmentList) {
            TreeNodeModel segmentGraphicalModel = this.findEDIGraphicalModel(segment);
            if (segmentGraphicalModel == null) continue;
            List<TreeNodeConnection> sourceConnections = segmentGraphicalModel.getSourceConnections();
            List<TreeNodeConnection> targetConnections = segmentGraphicalModel.getTargetConnections();
            ArrayList<TreeNodeConnection> sourceConnectionsTemp = new ArrayList<TreeNodeConnection>(sourceConnections);
            ArrayList<TreeNodeConnection> targetConnectionsTemp = new ArrayList<TreeNodeConnection>(targetConnections);
            for (TreeNodeConnection treeNodeConnection : targetConnectionsTemp) {
                treeNodeConnection.getSourceNode().getSourceConnections().remove(treeNodeConnection);
                treeNodeConnection.getSourceNode().fireConnectionChanged();
                treeNodeConnection.getTargetNode().getTargetConnections().remove(treeNodeConnection);
                treeNodeConnection.getTargetNode().fireConnectionChanged();
            }
            targetConnectionsTemp.clear();
            targetConnectionsTemp = null;
            for (TreeNodeConnection treeNodeConnection : sourceConnectionsTemp) {
                treeNodeConnection.getSourceNode().getSourceConnections().remove(treeNodeConnection);
                treeNodeConnection.getSourceNode().fireConnectionChanged();
                treeNodeConnection.getTargetNode().getTargetConnections().remove(treeNodeConnection);
                treeNodeConnection.getTargetNode().fireConnectionChanged();
            }
            sourceConnectionsTemp.clear();
            sourceConnectionsTemp = null;
            this.disconnectSegement((List<Segment>)segment.getSegment());
        }
    }

    private void disconnectSegements() {
        if (this.graphicalRootModel != null && this.segments != null) {
            EList segmentList = this.segments.getSegment();
            this.disconnectSegement((List<Segment>)segmentList);
        }
    }

    public List<TreeNodeModel> createLinkModel() {
        if (this.graphicalRootModel != null && this.segments != null) {
            EList segmentList = this.segments.getSegment();
            List<TreeNodeModel> links = this.linkNode((Collection<?>)segmentList);
            return links;
        }
        return Collections.emptyList();
    }

    protected List<TreeNodeModel> linkNode(Collection<?> segmentList) {
        ArrayList<TreeNodeModel> sourceLinkedModel = new ArrayList<TreeNodeModel>();
        for (Object obj : segmentList) {
            if (!(obj instanceof Segment)) continue;
            Segment segment = (Segment)obj;
            TreeNodeModel segmentGraphicalModel = this.findEDIGraphicalModel(segment);
            String code = segment.getSegcode();
            AbstractSmooksGraphicalModel model = this.findEDIDataGraphicalModel(code);
            if (segmentGraphicalModel != null && model != null && !this.isLinked(segmentGraphicalModel, model)) {
                new TreeNodeConnection(segmentGraphicalModel, model).connect();
            }
            sourceLinkedModel.add(segmentGraphicalModel);
            List<TreeNodeModel> linkedModel = this.linkNode((Collection<?>)segment.getSegment());
            if (linkedModel == null) continue;
            sourceLinkedModel.addAll(linkedModel);
        }
        return sourceLinkedModel;
    }

    private boolean isLinked(AbstractSmooksGraphicalModel source, AbstractSmooksGraphicalModel target) {
        List<TreeNodeConnection> connections = source.getSourceConnections();
        for (TreeNodeConnection treeNodeConnection : connections) {
            if (treeNodeConnection.getTargetNode() != target) continue;
            return true;
        }
        return false;
    }

    private TreeNodeModel findEDIGraphicalModel(Object model) {
        if (this.graphicalRootModel != null) {
            List<AbstractSmooksGraphicalModel> treeNodeList = this.graphicalRootModel.getChildren();
            return (TreeNodeModel)this.findEDIGraphicalModel(model, treeNodeList);
        }
        return null;
    }

    private AbstractSmooksGraphicalModel findEDIGraphicalModel(Object model, List<?> treeNodeList) {
        for (AbstractSmooksGraphicalModel treeNodeModel : treeNodeList) {
            Object data = treeNodeModel.getData();
            if (data == model) {
                return treeNodeModel;
            }
            AbstractSmooksGraphicalModel m = this.findEDIGraphicalModel(model, treeNodeModel.getChildren());
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private AbstractSmooksGraphicalModel findEDIDataGraphicalModel(String code) {
        if (code == null) {
            return null;
        }
        if (this.graphicalRootModel != null) {
            List<AbstractSmooksGraphicalModel> treeNodeList = this.graphicalRootModel.getChildren();
            for (AbstractSmooksGraphicalModel treeNodeModel : treeNodeList) {
                String name;
                Object model = treeNodeModel.getData();
                if (!(model instanceof TagObject) || !code.equals(name = ((TagObject)model).getName())) continue;
                return treeNodeModel;
            }
        }
        return null;
    }

    protected void disposeCompositeControls(Composite composite, Control[] ignoreControl) {
        if (composite != null) {
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (ignoreControl != null) {
                    int j = 0;
                    while (j < ignoreControl.length) {
                        if (child == ignoreControl[j]) {
                            // empty if block
                        }
                        ++j;
                    }
                }
                child.dispose();
                child = null;
                ++i;
            }
        }
    }

    private void disposeMappingModelPropertiesCompoisiteControls() {
        this.disposeCompositeControls(this.mappingModelPropertiesComposite, null);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this.getGraphicalViewer()) {
            this.initEDIModels();
            this.disposeMappingModelPropertiesCompoisiteControls();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() > 1) {
                return;
            }
            Object model = selection.getFirstElement();
            if (model instanceof EditPart) {
                model = ((EditPart)model).getModel();
            }
            if (model != null) {
                if (model instanceof TreeNodeModel) {
                    model = ((TreeNodeModel)model).getData();
                }
                if (model instanceof EObject) {
                    IItemPropertySource itemPropertySource = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt(model, IItemPropertySource.class);
                    this.segmentsCreator.setModel((EObject)model);
                    this.segmentsCreator.setPropertySource(itemPropertySource);
                    this.segmentsCreator.createModelPanel((EObject)model, this.getManagedForm().getToolkit(), this.mappingModelPropertiesComposite, itemPropertySource, this.modelProvider, (IEditorPart)this.getEditor());
                    this.mappingModelPropertiesComposite.getParent().layout();
                }
            }
            this.updateSelectionActions();
        }
    }

    protected void testEDITransform() {
        try {
            if (this.getEditor().isDirty()) {
                MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)Messages.EDIMapFormPage_Info_Dialog_Title, (String)Messages.EDIMapFormPage_Info_Dialog_Msg);
                return;
            }
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            IFile file = input.getFile();
            String path = file.getLocation().toOSString();
            File ediFile = new File(SmooksUIUtils.parseFilePath(this.ediFilePath));
            if (ediFile == null || !ediFile.exists()) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)Messages.EDIMapFormPage_Transform_Error_Dialog_Title, (String)(String.valueOf(Messages.EDIMapFormPage_Transform_Error_Dialog_Msg) + this.ediFilePath));
                return;
            }
            if (file == null || !file.exists()) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)Messages.EDIMapFormPage_Transform_Error_Dialog_Title, (String)(String.valueOf(Messages.EDIMapFormPage_Transform_Error_Dialog_Msg2) + path));
                return;
            }
            Smooks smooks = new Smooks();
            SmooksResourceConfiguration readerConfig = new SmooksResourceConfiguration("org.xml.sax.driver", SmooksEDIReader.class.getName());
            File f = new File(file.getLocation().toOSString());
            readerConfig.setParameter("mapping-model", f.toURI().toString());
            if (this.ediFileEncoding == null || this.ediFileEncoding.trim().length() == 0) {
                this.ediFileEncoding = "UTF-8";
            }
            readerConfig.setParameter("encoding", this.ediFileEncoding);
            SmooksUtil.registerResource((SmooksResourceConfiguration)readerConfig, (Smooks)smooks);
            DOMResult domResult = new DOMResult();
            FileInputStream ediInputStream = new FileInputStream(ediFile);
            smooks.filter((Source)new StreamSource(ediInputStream), (Result)domResult);
            Document model = (Document)domResult.getNode();
            StringWriter modelWriter = new StringWriter();
            XmlUtil.serialize((Node)model, (boolean)true, (Writer)modelWriter);
            EDIMappingResultDialog dialog = new EDIMappingResultDialog(this.getSite().getShell());
            dialog.setText(modelWriter.toString());
            dialog.open();
            modelWriter.close();
            ediInputStream.close();
            model = null;
        }
        catch (Throwable t) {
            SmooksUIUtils.showErrorDialog(this.getEditorSite().getShell(), SmooksUIUtils.createErrorStatus(t));
        }
    }

    public void modifyText(ModifyEvent e) {
    }

    private void rebuildEDIGraph() {
    }
}

