/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jboss.tools.smooks.configuration.editors.xml.TagObject;

public class Test {
    public static void main(String[] args) {
        try {
            new Test().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void test() throws IOException {
        InputStream stream = Test.class.getResourceAsStream("input-message.edi");
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        int segment = 10;
        char field = '*';
        char component = '^';
        char subcomponent = '~';
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> segmentList = new ArrayList<String>();
        int readed = -1;
        while ((readed = br.read()) != -1) {
            if (readed != segment) {
                stringBuffer.append((char)readed);
                continue;
            }
            segmentList.add(stringBuffer.toString());
            stringBuffer = null;
            stringBuffer = new StringBuffer();
        }
        br.close();
        reader.close();
        stream.close();
        TagObject rootTag = new TagObject();
        rootTag.setName("root");
        ArrayList<String> names = new ArrayList<String>();
        char[] separators = new char[]{field, component, subcomponent};
        for (String string : segmentList) {
            String[] fields = string.split("\\" + new String(new char[]{field}));
            TagObject tag = null;
            if (fields.length != 0) {
                tag = new TagObject();
                if (names.indexOf(fields[0]) == -1) {
                    tag.setName(fields[0]);
                    names.add(tag.getName());
                    rootTag.addChildTag(tag);
                }
            }
            if (tag == null) continue;
            String ss = string.substring(fields[0].length(), string.length());
            this.generateChildrenTag(tag, ss, separators, 0);
        }
        System.out.println(rootTag);
    }

    private String getSeparator(String s) {
        if (s.equals("*") || s.equals("+") || s.equals("^")) {
            return "\\" + s;
        }
        return s;
    }

    private void generateChildrenTag(TagObject parent, String content, char[] separators, int currentSeparator) {
        char separator = separators[currentSeparator];
        String sss = new String(new char[]{separator});
        if (content.indexOf(sss) == -1) {
            return;
        }
        String[] contentArray = content.split(sss = this.getSeparator(sss));
        if (contentArray == null || contentArray.length == 0) {
            return;
        }
        int i = 0;
        while (i < contentArray.length) {
            String con = contentArray[i];
            if (con != null && con.length() != 0) {
                TagObject child = new TagObject();
                child.setName(con);
                parent.addChildTag(child);
                int newIndex = currentSeparator + 1;
                if (newIndex <= separators.length - 1) {
                    this.generateChildrenTag(child, con, separators, newIndex);
                }
            }
            ++i;
        }
    }
}

