/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.edimap.models;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.jboss.tools.smooks.edimap.models.EDIDataContainerGraphModel;
import org.jboss.tools.smooks.edimap.models.EDIDataContainerModel;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.model.medi.MEdiPackage;
import org.jboss.tools.smooks.model.medi.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIMappingNodeGraphModel
extends TreeNodeModel {
    IEditingDomainProvider domainProvider = null;

    public EDIMappingNodeGraphModel(Object data, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IEditingDomainProvider domainProvider) {
        super(data, contentProvider, labelProvider);
        this.domainProvider = domainProvider;
    }

    @Override
    protected TreeNodeModel createChildModel(Object model, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        return new EDIMappingNodeGraphModel(model, contentProvider, labelProvider, this.domainProvider);
    }

    @Override
    public boolean canLinkWithSource(Object model) {
        return false;
    }

    @Override
    public void addSourceConnection(TreeNodeConnection connection) {
        AbstractSmooksGraphicalModel targetNode;
        super.addSourceConnection(connection);
        if (this.getData() instanceof Segment && (targetNode = connection.getTargetNode()) != null && targetNode.getData() instanceof EDIDataContainerModel && this.domainProvider != null) {
            String segCode = ((EDIDataContainerModel)targetNode.getData()).getSegCode();
            String sc = ((Segment)this.getData()).getSegcode();
            if (sc != null && sc.equals(segCode)) {
                return;
            }
            EditingDomain domain = this.domainProvider.getEditingDomain();
            if (domain != null) {
                Command command = SetCommand.create((EditingDomain)domain, (Object)this.getData(), (Object)MEdiPackage.Literals.SEGMENT__SEGCODE, (Object)segCode);
                domain.getCommandStack().execute(command);
            }
        }
    }

    @Override
    public void removeSourceConnection(TreeNodeConnection connection) {
        super.removeSourceConnection(connection);
        if (this.getData() instanceof Segment) {
            EditingDomain domain;
            String sc = ((Segment)this.getData()).getSegcode();
            if (sc == null) {
                return;
            }
            if (this.domainProvider != null && (domain = this.domainProvider.getEditingDomain()) != null) {
                Command command = SetCommand.create((EditingDomain)domain, (Object)this.getData(), (Object)MEdiPackage.Literals.SEGMENT__SEGCODE, null);
                domain.getCommandStack().execute(command);
            }
        }
    }

    @Override
    public void removeTargetConnection(TreeNodeConnection connection) {
        super.removeTargetConnection(connection);
    }

    @Override
    public void addTargetConnection(TreeNodeConnection connection, AbstractSmooksGraphicalModel sourceNode) {
        super.addTargetConnection(connection, sourceNode);
    }

    @Override
    public boolean isLinkable(Class<?> type) {
        Object nodeModel = this.getData();
        if (!(nodeModel instanceof Segment)) {
            return false;
        }
        if (!this.getSourceConnections().isEmpty()) {
            return false;
        }
        return super.isLinkable(type);
    }

    @Override
    public boolean canLinkWithTarget(Object model) {
        Object nodeModel = this.getData();
        if (!(nodeModel instanceof Segment)) {
            return false;
        }
        return model instanceof EDIDataContainerGraphModel;
    }
}

