/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.editor.propertySections;

import java.util.List;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jboss.tools.smooks.editor.propertySections.AbstractSmooksPropertySection;
import org.jboss.tools.smooks.editor.propertySections.Messages;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.editparts.freemarker.FreemarkerCSVNodeEditPart;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerCSVNodeGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.freemarker.FreemarkerTemplateGraphicalModel;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.SmooksFactory;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

public class CSVRecordSection
extends AbstractSmooksPropertySection {
    private Text speratorText;
    private Text quoteText;
    private boolean fireEvent = true;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section section = this.createRootSection(factory, parent);
        section.setText(Messages.CSVRecordSection_Section_Title);
        Composite mainComposite = factory.createComposite((Composite)section);
        section.setClient((Control)mainComposite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        mainComposite.setLayout((Layout)gl);
        factory.createLabel(mainComposite, Messages.CSVRecordSection_Label_Separator);
        this.speratorText = factory.createText(mainComposite, "");
        this.speratorText.setTextLimit(1);
        GridData gd = new GridData(768);
        this.speratorText.setLayoutData((Object)gd);
        factory.createLabel(mainComposite, Messages.CSVRecordSection_Label_Quote);
        this.quoteText = factory.createText(mainComposite, "");
        this.quoteText.setTextLimit(1);
        gd = new GridData(768);
        this.quoteText.setLayoutData((Object)gd);
        this.hookTextControls();
    }

    private Freemarker getFreemarker() {
        Object graphModel = this.getPresentSelectedGraphModel();
        if (graphModel instanceof AbstractSmooksGraphicalModel) {
            AbstractSmooksGraphicalModel templateGModel = (AbstractSmooksGraphicalModel)graphModel;
            while (templateGModel != null && !(templateGModel instanceof FreemarkerTemplateGraphicalModel)) {
                templateGModel = templateGModel.getParent();
            }
            if (templateGModel != null) {
                Object freemarker = templateGModel.getData();
                if ((freemarker = AdapterFactoryEditingDomain.unwrap((Object)freemarker)) instanceof Freemarker) {
                    return (Freemarker)freemarker;
                }
            }
        }
        return null;
    }

    private FreemarkerCSVNodeEditPart getRecordCSVEditPart() {
        GraphicalEditPart editPart = this.getPresentSelectedEditPart();
        List children = editPart.getChildren();
        for (Object childEditPart : children) {
            if (!(childEditPart instanceof FreemarkerCSVNodeEditPart)) continue;
            return (FreemarkerCSVNodeEditPart)childEditPart;
        }
        return null;
    }

    private void generateNewTemplateContent() {
        Object data;
        FreemarkerCSVNodeEditPart editPart = this.getRecordCSVEditPart();
        if (editPart != null && (data = editPart.getModel()) instanceof FreemarkerCSVNodeGraphicalModel) {
            ((FreemarkerCSVNodeGraphicalModel)data).changeFreemarkerContents();
        }
    }

    private void hookTextControls() {
        this.speratorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Freemarker freemarker;
                if (CSVRecordSection.this.fireEvent && (freemarker = CSVRecordSection.this.getFreemarker()) != null) {
                    ParamType param = SmooksModelUtils.getParam((List)freemarker.getParam(), (String)"seperator");
                    if (param == null) {
                        param = SmooksFactory.eINSTANCE.createParamType();
                        param.setName("seperator");
                        freemarker.getParam().add((Object)param);
                    }
                    SmooksModelUtils.setTextToSmooksType((EditingDomain)CSVRecordSection.this.getSmooksModelProvider().getEditingDomain(), (AnyType)param, (String)CSVRecordSection.this.speratorText.getText());
                    CSVRecordSection.this.generateNewTemplateContent();
                }
            }
        });
        this.quoteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Freemarker freemarker;
                if (CSVRecordSection.this.fireEvent && (freemarker = CSVRecordSection.this.getFreemarker()) != null) {
                    ParamType param = SmooksModelUtils.getParam((List)freemarker.getParam(), (String)"quote");
                    if (param == null) {
                        param = SmooksFactory.eINSTANCE.createParamType();
                        param.setName("quote");
                        freemarker.getParam().add((Object)param);
                    }
                    SmooksModelUtils.setTextToSmooksType((EditingDomain)CSVRecordSection.this.getSmooksModelProvider().getEditingDomain(), (AnyType)param, (String)CSVRecordSection.this.quoteText.getText());
                    CSVRecordSection.this.generateNewTemplateContent();
                }
            }
        });
    }

    public void refresh() {
        this.fireEvent = false;
        super.refresh();
        Freemarker freemarker = this.getFreemarker();
        if (freemarker != null) {
            String quote = SmooksModelUtils.getParamValue((List)freemarker.getParam(), (String)"quote");
            String sperator = SmooksModelUtils.getParamValue((List)freemarker.getParam(), (String)"seperator");
            if (quote == null) {
                quote = "";
            }
            if (sperator == null) {
                sperator = "";
            }
            this.speratorText.setText(sperator);
            this.quoteText.setText(quote);
        }
        this.fireEvent = true;
    }
}

