/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.editor.propertySections;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.propertySections.AbstractSmooksPropertySection;
import org.jboss.tools.smooks.editor.propertySections.Messages;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.javabean12.ValueType;

public class JavaMappingPathSection
extends AbstractSmooksPropertySection {
    private Composite controlComposite;
    private Text pathText;
    private Text namespaceText;
    private Text defaultValueText;
    protected boolean lock = false;
    private Label defaultValueLabel;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section section = this.createRootSection(factory, parent);
        section.setText(Messages.JavaMappingPathSection_MappingPath);
        this.controlComposite = factory.createComposite((Composite)section, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 13;
        gridLayout.verticalSpacing = 20;
        this.controlComposite.setLayout((Layout)gridLayout);
        section.setClient((Control)this.controlComposite);
        this.createTextContorls(factory);
        this.hookTextContorls();
    }

    protected void createTextContorls(TabbedPropertySheetWidgetFactory factory) {
        Label pathLabel = factory.createLabel(this.controlComposite, Messages.JavaMappingPathSection_PathLabel);
        pathLabel.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.pathText = factory.createText(this.controlComposite, "", 8);
        GridData gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        Label namespaceLabel = factory.createLabel(this.controlComposite, Messages.JavaMappingPathSection_NamespaceLabel);
        namespaceLabel.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.namespaceText = factory.createText(this.controlComposite, "");
        this.namespaceText.setLayoutData((Object)gd);
        this.defaultValueLabel = factory.createLabel(this.controlComposite, Messages.JavaMappingPathSection_DefaultLabel);
        this.defaultValueLabel.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.defaultValueText = factory.createText(this.controlComposite, "");
        this.defaultValueText.setLayoutData((Object)gd);
    }

    protected void hookTextContorls() {
        this.namespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EObject model;
                EStructuralFeature feature;
                if (JavaMappingPathSection.this.lock) {
                    return;
                }
                Object obj = JavaMappingPathSection.this.getTargetModel();
                EditingDomain domain = JavaMappingPathSection.this.getSmooksModelProvider().getEditingDomain();
                if (obj instanceof EObject && domain != null && (feature = SmooksUIUtils.getSelectorNamespaceFeature(model = (EObject)obj)) != null) {
                    String oldV;
                    Object v = model.eGet(feature);
                    String newV = ((Text)e.getSource()).getText().trim();
                    if (v != null && (oldV = v.toString().trim()).equals(newV)) {
                        return;
                    }
                    Command setCommand = SetCommand.create((EditingDomain)domain, (Object)model, (Object)feature, (Object)newV);
                    domain.getCommandStack().execute(setCommand);
                }
            }
        });
        this.defaultValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (JavaMappingPathSection.this.lock) {
                    return;
                }
                Object obj = JavaMappingPathSection.this.getTargetModel();
                EditingDomain domain = JavaMappingPathSection.this.getSmooksModelProvider().getEditingDomain();
                if (obj instanceof ValueType && domain != null) {
                    String oldV;
                    ValueType model = (ValueType)obj;
                    String v = model.getDefault();
                    String newV = ((Text)e.getSource()).getText().trim();
                    if (v != null && (oldV = v.toString().trim()).equals(newV)) {
                        return;
                    }
                    Command setCommand = SetCommand.create((EditingDomain)domain, (Object)model, (Object)Javabean12Package.Literals.VALUE_TYPE__DEFAULT, (Object)newV);
                    domain.getCommandStack().execute(setCommand);
                }
            }
        });
    }

    protected void refreshTextControls() {
        this.lock = true;
        this.pathText.setText("");
        this.namespaceText.setText("");
        this.defaultValueText.setText("");
        this.defaultValueLabel.setVisible(false);
        this.defaultValueText.setVisible(false);
        Object obj = this.getTargetModel();
        if (obj instanceof EObject) {
            Object v;
            EObject model = (EObject)obj;
            EStructuralFeature feature = SmooksUIUtils.getSelectorFeature(model);
            if (feature != null && (v = model.eGet(feature)) != null) {
                this.pathText.setText(v.toString().trim());
            }
            if ((feature = SmooksUIUtils.getSelectorNamespaceFeature(model)) != null && (v = model.eGet(feature)) != null) {
                this.namespaceText.setText(v.toString().trim());
            }
            if (model instanceof ValueType) {
                this.defaultValueLabel.setVisible(true);
                this.defaultValueText.setVisible(true);
                v = ((ValueType)model).getDefault();
                if (v != null) {
                    this.defaultValueText.setText(v.toString().trim());
                }
            }
        }
        this.lock = false;
    }

    protected Object getTargetModel() {
        TreeNodeConnection lineModel = (TreeNodeConnection)this.getPresentSelectedGraphModel();
        Object model = lineModel.getTargetNode().getData();
        model = AdapterFactoryEditingDomain.unwrap((Object)model);
        return model;
    }

    public void refresh() {
        super.refresh();
        this.refreshTextControls();
    }
}

