/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.editor.propertySections;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.editor.propertySections.AbstractSmooksPropertySection;
import org.jboss.tools.smooks.editor.propertySections.DecodeParamMetaData;
import org.jboss.tools.smooks.editor.propertySections.DecodeParamMetaDataFactory;
import org.jboss.tools.smooks.editor.propertySections.Messages;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.graphical.editors.model.javamapping.JavaBeanChildGraphModel;
import org.jboss.tools.smooks.model.javabean12.DecodeParamType;
import org.jboss.tools.smooks.model.javabean12.Javabean12Package;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.decoders.EnumDecoder;
import org.milyn.javabean.decoders.IntegerDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueDecodeParamSection
extends AbstractSmooksPropertySection {
    private Composite controlComposite;
    private TableViewer paramterViewer;
    private CCombo decoderCombo;
    boolean isEnumTarget;
    private TableColumn nameColumn;
    private TableColumn valueColumn;
    private static List<String> DECODERS = new ArrayList<String>();

    static {
        Map map = DataDecoder.Factory.getInstalledDecoders();
        Collection decoders = map.values();
        DECODERS.add("");
        for (Class dataDecoderClass : decoders) {
            if (dataDecoderClass == null) continue;
            String name = dataDecoderClass.getSimpleName();
            if (name.endsWith("Decoder")) {
                name = name.substring(0, name.length() - "Decoder".length());
            }
            if (DECODERS.contains(name)) continue;
            DECODERS.add(name);
        }
        Collections.sort(DECODERS);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section section = this.createRootSection(factory, parent);
        section.setText(Messages.ValueDecodeParamSection_SectionTitle);
        this.controlComposite = factory.createComposite((Composite)section, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 13;
        gridLayout.verticalSpacing = 20;
        this.controlComposite.setLayout((Layout)gridLayout);
        section.setClient((Control)this.controlComposite);
        this.createDecoderCombo(factory, this.controlComposite);
        this.createDecodeParamViewer(factory, this.controlComposite);
    }

    private void createDecoderCombo(TabbedPropertySheetWidgetFactory factory, Composite parent) {
        factory.createLabel(this.controlComposite, Messages.ValueDecodeParamSection_DecoderLabel).setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.decoderCombo = factory.createCCombo(parent, 8);
        GridData gd = new GridData(768);
        this.decoderCombo.setLayoutData((Object)gd);
        for (String decoderName : DECODERS) {
            this.decoderCombo.add(decoderName);
        }
        this.decoderCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValueDecodeParamSection.this.changeDecoder();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void changeDecoder() {
        ISmooksModelProvider provider = this.getSmooksModelProvider();
        if (provider != null) {
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)provider.getEditingDomain();
            String newDecoder = this.decoderCombo.getText();
            TreeNodeConnection lineModel = (TreeNodeConnection)this.getPresentSelectedGraphModel();
            Object model = lineModel.getTargetNode().getData();
            if ((model = AdapterFactoryEditingDomain.unwrap((Object)model)) != null && model instanceof ValueType) {
                String decoder = ((ValueType)model).getDecoder();
                if (newDecoder.equals(decoder)) {
                    return;
                }
                CompoundCommand command = new CompoundCommand();
                Command setCommand = SetCommand.create((EditingDomain)editingDomain, (Object)model, (Object)Javabean12Package.Literals.VALUE_TYPE__DECODER, (Object)newDecoder);
                if (!((ValueType)model).getDecodeParam().isEmpty()) {
                    Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Collection)((ValueType)model).getDecodeParam());
                    command.append(setCommand);
                    command.append(removeCommand);
                }
                if (command.isEmpty()) {
                    editingDomain.getCommandStack().execute(setCommand);
                } else {
                    editingDomain.getCommandStack().execute((Command)command);
                }
                this.initDecodeParamViewer();
            }
        }
    }

    private void createDecodeParamViewer(TabbedPropertySheetWidgetFactory factory, Composite sashForm) {
        GridData gd = new GridData(1808);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label label = factory.createLabel(sashForm, Messages.ValueDecodeParamSection_DecoderParamLabel);
        label.setLayoutData((Object)gd);
        label.setForeground(factory.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite viewerComposite = factory.createComposite(sashForm, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        viewerComposite.setLayoutData((Object)gd);
        viewerComposite.setBackground(factory.getColors().getBorderColor());
        FillLayout layout = new FillLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        viewerComposite.setLayout((Layout)layout);
        this.paramterViewer = new TableViewer(viewerComposite, 65536);
        this.paramterViewer.setContentProvider((IContentProvider)new DecodeParamViewerContentProvider());
        this.paramterViewer.setLabelProvider((IBaseLabelProvider)new DecodeParamTypeLabelProvider());
        this.paramterViewer.setFilters(new ViewerFilter[]{new DecodeParamTypeFilter()});
        this.nameColumn = new TableColumn(this.paramterViewer.getTable(), 0);
        this.valueColumn = new TableColumn(this.paramterViewer.getTable(), 0);
        this.nameColumn.setText(Messages.ValueDecodeParamSection_ParamNameColumnText);
        this.valueColumn.setText(Messages.ValueDecodeParamSection_ParamValueColumnText);
        this.nameColumn.setWidth(150);
        this.valueColumn.setWidth(150);
        this.paramterViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.paramterViewer.getTable()), new TextCellEditor((Composite)this.paramterViewer.getTable())});
        this.paramterViewer.setColumnProperties(new String[]{"name", "value"});
        this.paramterViewer.setCellModifier((ICellModifier)new DecodeParamCellModifier());
        this.paramterViewer.getTable().setHeaderVisible(true);
        this.paramterViewer.getTable().setLinesVisible(true);
    }

    private void initDecoderCombo() {
        JavaBeanChildGraphModel javaBeanChildGraphModel;
        Object bindingTypeObj;
        this.decoderCombo.select(-1);
        TreeNodeConnection lineModel = (TreeNodeConnection)this.getPresentSelectedGraphModel();
        AbstractSmooksGraphicalModel targetNode = lineModel.getTargetNode();
        if (targetNode instanceof JavaBeanChildGraphModel && (bindingTypeObj = (javaBeanChildGraphModel = (JavaBeanChildGraphModel)targetNode).getBindingTypeObj()) != null && bindingTypeObj instanceof ValueType) {
            Class<?> targetPropertyType = javaBeanChildGraphModel.getJavaType();
            String decoderAlias = ((ValueType)bindingTypeObj).getDecoder();
            if (decoderAlias != null) {
                int index = DECODERS.indexOf(decoderAlias.trim());
                this.decoderCombo.select(index);
            } else {
                String decoderName;
                DataDecoder decoder = DataDecoder.Factory.create(targetPropertyType);
                if (decoder.getClass().getPackage() == IntegerDecoder.class.getPackage() && (decoderName = decoder.getClass().getSimpleName()).endsWith("Decoder")) {
                    decoderAlias = decoderName.substring(0, decoderName.length() - "Decoder".length());
                    int index = DECODERS.indexOf(decoderAlias);
                    this.decoderCombo.select(index);
                }
            }
        }
    }

    private void initDecodeParamViewer() {
        JavaBeanChildGraphModel javaBeanChildGraphModel;
        Object bindingTypeObj;
        this.paramterViewer.setInput((Object)"NULL");
        TreeNodeConnection lineModel = (TreeNodeConnection)this.getPresentSelectedGraphModel();
        AbstractSmooksGraphicalModel targetNode = lineModel.getTargetNode();
        if (targetNode instanceof JavaBeanChildGraphModel && (bindingTypeObj = (javaBeanChildGraphModel = (JavaBeanChildGraphModel)targetNode).getBindingTypeObj()) != null && bindingTypeObj instanceof ValueType) {
            Class<?> targetPropertyType = javaBeanChildGraphModel.getJavaType();
            String decoderAlias = ((ValueType)bindingTypeObj).getDecoder();
            DataDecoder decoder = decoderAlias != null ? DataDecoder.Factory.create((String)decoderAlias) : DataDecoder.Factory.create(targetPropertyType);
            if (decoder instanceof EnumDecoder) {
                this.isEnumTarget = true;
                this.paramterViewer.setInput(this.newEnumDecodeParamSet(targetPropertyType, (ValueType)bindingTypeObj, javaBeanChildGraphModel));
                this.nameColumn.setText(Messages.ValueDecodeParamSection_EnumParamNameColumnText);
                this.valueColumn.setText(Messages.ValueDecodeParamSection_EnumParamValueColumnText);
            } else {
                this.isEnumTarget = false;
                this.nameColumn.setText(Messages.ValueDecodeParamSection_ParamNameColumnText);
                this.valueColumn.setText(Messages.ValueDecodeParamSection_ParamValueColumnText);
                DecodeParamMetaData[] decodeParamMetaData = DecodeParamMetaDataFactory.getDecodeParamMetaData(decoder.getClass());
                if (decodeParamMetaData != null) {
                    this.paramterViewer.setInput(this.newDecodeParam(decodeParamMetaData, (ValueType)bindingTypeObj));
                }
            }
        }
    }

    private List<DecodeParam> newDecodeParam(DecodeParamMetaData[] decodeParamMetaData, ValueType valueType) {
        ArrayList<DecodeParam> list = new ArrayList<DecodeParam>();
        int i = 0;
        while (i < decodeParamMetaData.length) {
            DecodeParamMetaData decodeParamMD = decodeParamMetaData[i];
            DecodeParam p = new DecodeParam();
            DecodeParamType dp = this.findDecodeParamType(decodeParamMD.getName(), valueType);
            p.setName(decodeParamMD.getName());
            if (dp != null) {
                String dpv = dp.getValue();
                if (dpv != null) {
                    dpv = dpv.trim();
                }
                p.setValue(dpv);
            } else if (decodeParamMD.getDefaultVal() != null) {
                p.setValue(decodeParamMD.getDefaultVal());
            } else {
                decodeParamMD.isRequiresConfiguration();
            }
            list.add(p);
            ++i;
        }
        return list;
    }

    private List<DecodeParam> newEnumDecodeParamSet(Class<?> enumType, ValueType valueType, JavaBeanChildGraphModel enumValueModelNode) {
        ArrayList<DecodeParam> list = new ArrayList<DecodeParam>();
        Properties configuredParams = JavaBeanChildGraphModel.getDecoderParams(valueType);
        if (!configuredParams.isEmpty()) {
            Set<Map.Entry<Object, Object>> paramSet = configuredParams.entrySet();
            for (Map.Entry<Object, Object> param : paramSet) {
                String paramName = param.getKey().toString();
                if (paramName.equals("enumType")) continue;
                DecodeParam p = new DecodeParam();
                p.setName(paramName);
                p.setValue(param.getValue().toString());
                list.add(p);
            }
        } else {
            Field[] enumFields;
            Field[] fieldArray = enumFields = enumType.getDeclaredFields();
            int n = enumFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field enumField = fieldArray[n2];
                if (enumField.isEnumConstant()) {
                    DecodeParam p = new DecodeParam();
                    p.setName(enumField.getName());
                    p.setValue(enumField.getName());
                    list.add(p);
                }
                ++n2;
            }
            enumValueModelNode.newEnumDecodeParamSet(enumType, valueType);
        }
        return list;
    }

    private DecodeParamType findDecodeParamType(String name, ValueType valueType) {
        EList ps = valueType.getDecodeParam();
        for (DecodeParamType dp : ps) {
            String dpn = dp.getName();
            if (dpn != null) {
                dpn = dpn.trim();
            }
            if (!name.equals(dpn)) continue;
            return dp;
        }
        return null;
    }

    protected void createDecodeParamGUIContents(Object model, ISmooksModelProvider provider, IEditorPart part, FormToolkit factory, Composite controlComposite) {
    }

    @Override
    public void refresh() {
        super.refresh();
        this.initDecoderCombo();
        this.initDecodeParamViewer();
    }

    private class DecodeParam {
        String name;
        String value;

        private DecodeParam() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private class DecodeParamCellModifier
    implements ICellModifier {
        private DecodeParamCellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object currentElement = ((TableItem)element).getData();
                TreeNodeConnection lineModel = (TreeNodeConnection)ValueDecodeParamSection.this.getPresentSelectedGraphModel();
                EditingDomain editingDomain = ValueDecodeParamSection.this.getSmooksModelProvider().getEditingDomain();
                Object model = lineModel.getTargetNode().getData();
                if ((model = AdapterFactoryEditingDomain.unwrap((Object)model)) != null && model instanceof ValueType && currentElement instanceof DecodeParam) {
                    String svalue;
                    String pname = ((DecodeParam)currentElement).getName();
                    DecodeParamType paramType = ValueDecodeParamSection.this.findDecodeParamType(pname, (ValueType)model);
                    Command command = null;
                    if (!ValueDecodeParamSection.this.isEnumTarget && property.equals("value")) {
                        if (value != null) {
                            String svalue2 = ((String)value).trim();
                            if ("".equals(svalue2)) {
                                if (paramType != null) {
                                    command = RemoveCommand.create((EditingDomain)editingDomain, (Object)paramType);
                                }
                            } else if (paramType == null) {
                                AbstractSmooksGraphicalModel targetNode = lineModel.getTargetNode();
                                if (targetNode instanceof JavaBeanChildGraphModel) {
                                    command = ((JavaBeanChildGraphModel)targetNode).addDecodeParam(pname, (String)value, (ValueType)model);
                                }
                            } else {
                                command = SetCommand.create((EditingDomain)editingDomain, (Object)paramType, (Object)Javabean12Package.Literals.DECODE_PARAM_TYPE__VALUE, (Object)value);
                            }
                        }
                        if (command != null) {
                            editingDomain.getCommandStack().execute(command);
                            ((DecodeParam)currentElement).setValue((String)value);
                            ValueDecodeParamSection.this.paramterViewer.update(currentElement, new String[]{property});
                        }
                    } else if (ValueDecodeParamSection.this.isEnumTarget && property.equals("name") && value != null && !"".equals(svalue = ((String)value).trim())) {
                        command = SetCommand.create((EditingDomain)editingDomain, (Object)paramType, (Object)Javabean12Package.Literals.DECODE_PARAM_TYPE__NAME, (Object)value);
                        editingDomain.getCommandStack().execute(command);
                        ((DecodeParam)currentElement).setName((String)value);
                        ValueDecodeParamSection.this.paramterViewer.update(currentElement, new String[]{property});
                    }
                }
            }
        }

        public Object getValue(Object element, String property) {
            element = AdapterFactoryEditingDomain.unwrap((Object)element);
            if (!ValueDecodeParamSection.this.isEnumTarget && property.equals("value")) {
                if (element instanceof DecodeParam) {
                    String name = ((DecodeParam)element).getValue();
                    if (name == null) {
                        name = "";
                    }
                    return name;
                }
            } else if (ValueDecodeParamSection.this.isEnumTarget && property.equals("name") && element instanceof DecodeParam) {
                String name = ((DecodeParam)element).getName();
                if (name == null) {
                    name = "";
                }
                return name;
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ValueDecodeParamSection.this.isEnumTarget ? "name" : "value") && element instanceof DecodeParam;
        }
    }

    private class DecodeParamTypeFilter
    extends ViewerFilter {
        private DecodeParamTypeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return (element = AdapterFactoryEditingDomain.unwrap((Object)element)) instanceof DecodeParam;
        }
    }

    private class DecodeParamTypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int columnIndex) {
            Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (columnIndex == 0 && obj instanceof DecodeParam) {
                String name = ((DecodeParam)obj).getName();
                if (name == null) {
                    name = "";
                }
                return name;
            }
            if (columnIndex == 1 && obj instanceof DecodeParam) {
                String value = ((DecodeParam)obj).getValue();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }
    }

    private class DecodeParamViewerContentProvider
    implements IStructuredContentProvider {
        private DecodeParamViewerContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

