/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.gef.tree.model.IConnectableNode;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;
import org.jboss.tools.smooks.graphical.editors.model.IValidatableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractSmooksGraphicalModel
implements IConnectableNode,
IValidatableModel {
    private int severity = -1;
    private List<String> messages = null;
    public static final String PRO_ADD_CHILD = "_pro_add_child";
    public static final String PRO_MOVE_CHILD = "_pro_move_child";
    public static final String PRO_REMOVE_CHILD = "_pro_remove_child";
    public static final String PRO_ADD_SOURCE_CONNECTION = "_pro_add_source_connected";
    public static final String PRO_SEVERITY_CHANGED = "_pro_severity_changed";
    public static final String PRO_ADD_TARGET_CONNECTION = "_pro_add_target_connected";
    public static final String PRO_REMOVE_SOURCE_CONNECTION = "_pro_remove_source_connected";
    public static final String PRO_REMOVE_TARGET_CONNECTION = "_pro_remove_target_connected";
    public static final String PRO_TEXT_CHANGED = "_pro_text_changed";
    public static final String PRO_FORCE_VISUAL_CHANGED = "_pro_force_text_changed";
    public static final String PRO_FORCE_CHIDLREN_CHANGED = "_pro_force_children_changed";
    public static final String PRO_FORCE_CONNECTION_CHANGED = "_pro_force_connection_changed";
    protected Object data = null;
    private boolean linkable = true;
    private AbstractSmooksGraphicalModel parent = null;
    private HashMap<String, Object> userDataMap = new HashMap();
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected List<AbstractSmooksGraphicalModel> children = null;
    protected List<TreeNodeConnection> sourceConnections = new ArrayList<TreeNodeConnection>();
    protected List<TreeNodeConnection> targetConnections = new ArrayList<TreeNodeConnection>();

    public AbstractSmooksGraphicalModel(Object data) {
        this.setData(data);
    }

    public boolean hasChildren() {
        return true;
    }

    public AbstractSmooksGraphicalModel getParent() {
        return this.parent;
    }

    public void setParent(AbstractSmooksGraphicalModel parent) {
        this.parent = parent;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public void setSeverity(int severity) {
        int old = this.severity;
        if (severity == this.severity) {
            old = -1;
        }
        this.severity = severity;
        this.support.firePropertyChange(PRO_SEVERITY_CHANGED, old, this.severity);
    }

    public List<AbstractSmooksGraphicalModel> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<AbstractSmooksGraphicalModel>();
        }
        return this.children;
    }

    public List<AbstractSmooksGraphicalModel> getChildrenWithoutDynamic() {
        if (this.children == null) {
            this.children = new ArrayList<AbstractSmooksGraphicalModel>();
        }
        return this.children;
    }

    public static void disconnectAllConnections(AbstractSmooksGraphicalModel node) {
        AbstractSmooksGraphicalModel.disconnectAllConnections(node, null);
    }

    public static void disconnectAllConnections(AbstractSmooksGraphicalModel node, List<TreeNodeConnection> deletedConnections) {
        List<TreeNodeConnection> sourceConnections = node.getSourceConnections();
        List<TreeNodeConnection> targetConnections = node.getTargetConnections();
        ArrayList<TreeNodeConnection> tempSourceConnections = new ArrayList<TreeNodeConnection>(sourceConnections);
        ArrayList<TreeNodeConnection> tempTargetConnections = new ArrayList<TreeNodeConnection>(targetConnections);
        for (TreeNodeConnection treeNodeConnection : tempTargetConnections) {
            AbstractSmooksGraphicalModel abstractSmooksGraphicalModel = treeNodeConnection.getSourceNode();
            abstractSmooksGraphicalModel.getSourceConnections().remove(treeNodeConnection);
            abstractSmooksGraphicalModel.fireConnectionChanged();
            if (deletedConnections == null) continue;
            deletedConnections.add(treeNodeConnection);
        }
        for (TreeNodeConnection treeNodeConnection : tempSourceConnections) {
            AbstractSmooksGraphicalModel abstractSmooksGraphicalModel = treeNodeConnection.getTargetNode();
            abstractSmooksGraphicalModel.getTargetConnections().remove(treeNodeConnection);
            abstractSmooksGraphicalModel.fireConnectionChanged();
            if (deletedConnections == null) continue;
            deletedConnections.add(treeNodeConnection);
        }
        tempSourceConnections.clear();
        tempTargetConnections.clear();
        tempSourceConnections = null;
        tempTargetConnections = null;
        List<AbstractSmooksGraphicalModel> children = node.getChildren();
        for (TreeNodeModel treeNodeModel : children) {
            AbstractSmooksGraphicalModel.disconnectAllConnections(treeNodeModel, deletedConnections);
        }
    }

    public static void disconnectAllConnectionsWithEvent(AbstractSmooksGraphicalModel node, List<TreeNodeConnection> deletedConnections) {
        List<TreeNodeConnection> sourceConnections = node.getSourceConnections();
        List<TreeNodeConnection> targetConnections = node.getTargetConnections();
        ArrayList<TreeNodeConnection> tempSourceConnections = new ArrayList<TreeNodeConnection>(sourceConnections);
        ArrayList<TreeNodeConnection> tempTargetConnections = new ArrayList<TreeNodeConnection>(targetConnections);
        for (TreeNodeConnection treeNodeConnection : tempTargetConnections) {
            treeNodeConnection.disconnect();
            if (deletedConnections == null) continue;
            deletedConnections.add(treeNodeConnection);
        }
        for (TreeNodeConnection treeNodeConnection : tempSourceConnections) {
            treeNodeConnection.disconnect();
            if (deletedConnections == null) continue;
            deletedConnections.add(treeNodeConnection);
        }
        tempSourceConnections.clear();
        tempTargetConnections.clear();
        tempSourceConnections = null;
        tempTargetConnections = null;
        List<AbstractSmooksGraphicalModel> children = node.getChildren();
        for (TreeNodeModel treeNodeModel : children) {
            AbstractSmooksGraphicalModel.disconnectAllConnectionsWithEvent(treeNodeModel, deletedConnections);
        }
    }

    protected boolean graphicalChildExist(Object model, Object[] models) {
        int i = 0;
        while (i < models.length) {
            if (model == models[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean childExsit(Object model) {
        if (this.children != null) {
            for (TreeNodeModel treeNodeModel : this.children) {
                if (treeNodeModel.getData() != model) continue;
                return true;
            }
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addSourceConnection(TreeNodeConnection connection) {
        if (this.sourceConnections.indexOf(connection) == -1) {
            this.sourceConnections.add(connection);
            this.support.firePropertyChange(PRO_ADD_SOURCE_CONNECTION, null, connection);
        }
    }

    public void removeSourceConnection(TreeNodeConnection connection) {
        if (this.sourceConnections.indexOf(connection) != -1) {
            this.sourceConnections.remove(connection);
            this.support.firePropertyChange(PRO_REMOVE_SOURCE_CONNECTION, connection, null);
        }
    }

    public void addTargetConnection(TreeNodeConnection connection, AbstractSmooksGraphicalModel sourceNode) {
        if (this.targetConnections.indexOf(connection) == -1) {
            this.targetConnections.add(connection);
            this.support.firePropertyChange(PRO_ADD_TARGET_CONNECTION, null, connection);
        }
    }

    public void removeTargetConnection(TreeNodeConnection connection) {
        if (this.targetConnections.indexOf(connection) != -1) {
            this.targetConnections.remove(connection);
            this.support.firePropertyChange(PRO_REMOVE_TARGET_CONNECTION, connection, null);
        }
    }

    public void addChild(AbstractSmooksGraphicalModel node) {
        if (this.getChildrenWithoutDynamic().indexOf(node) == -1) {
            this.getChildrenWithoutDynamic().add(node);
            node.setParent(this);
            this.support.firePropertyChange(PRO_ADD_CHILD, null, node);
        }
    }

    public void addChild(int index, AbstractSmooksGraphicalModel node) {
        this.addChild(node);
        this.moveChild(index, node);
    }

    public void moveChild(int index, AbstractSmooksGraphicalModel node) {
        int oldIndex = this.getChildrenWithoutDynamic().indexOf(node);
        if (index >= 0 && index <= this.getChildrenWithoutDynamic().size() - 1 && oldIndex != -1 && index != oldIndex) {
            this.getChildrenWithoutDynamic().remove(node);
            this.getChildrenWithoutDynamic().add(index, node);
            this.support.firePropertyChange(PRO_MOVE_CHILD, oldIndex, index);
        }
    }

    public void removeChild(AbstractSmooksGraphicalModel node) {
        if (this.getChildrenWithoutDynamic().indexOf(node) != -1) {
            this.getChildrenWithoutDynamic().remove(node);
            node.setParent(null);
            this.support.firePropertyChange(PRO_REMOVE_CHILD, node, null);
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setUserData(String key, Object data) {
        this.userDataMap.put(key, data);
    }

    public Object getUserData(String key) {
        return this.userDataMap.get(key);
    }

    public String getText() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public boolean isLinkable(Class<?> connectionType) {
        return this.linkable;
    }

    public void setLinkable(boolean linkable) {
        this.linkable = linkable;
    }

    public boolean canLinkWithSource(Object model) {
        return true;
    }

    public boolean canLinkWithTarget(Object model) {
        return true;
    }

    public void setText(String text) {
    }

    @Override
    public List<TreeNodeConnection> getSourceConnections() {
        return this.sourceConnections;
    }

    @Override
    public List<TreeNodeConnection> getTargetConnections() {
        return this.targetConnections;
    }

    public void fireChildrenChanged() {
        this.support.firePropertyChange(PRO_FORCE_CHIDLREN_CHANGED, new Object(), null);
    }

    public void fireConnectionChanged() {
        this.support.firePropertyChange(PRO_FORCE_CONNECTION_CHANGED, new Object(), null);
    }

    public void fireVisualChanged() {
        this.support.firePropertyChange(PRO_FORCE_VISUAL_CHANGED, new Object(), null);
    }

    @Override
    public void addMessage(String message) {
        this.getMessage().add(message);
    }

    @Override
    public List<String> getMessage() {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        return this.messages;
    }
}

