/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.gef.tree.editparts.TreeNodeEditPart;
import org.jboss.tools.smooks.gef.tree.editpolicy.FigureHighlightEditPolicy;
import org.jboss.tools.smooks.gef.tree.editpolicy.TreeNodeGraphicalNodeEditPolicy;
import org.jboss.tools.smooks.gef.tree.figures.DragLinkFigure;
import org.jboss.tools.smooks.gef.tree.figures.IMoveableModel;
import org.jboss.tools.smooks.gef.tree.figures.TreeContainerFigure;
import org.jboss.tools.smooks.gef.tree.figures.TreeFigureExpansionEvent;
import org.jboss.tools.smooks.gef.tree.model.TreeContainerModel;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeContainerEditPart
extends TreeNodeEditPart {
    public TreeContainerEditPart() {
        this.childrenLoaded = true;
    }

    @Override
    protected IFigure createFigure() {
        return new TreeContainerFigure((TreeContainerModel)this.getModel());
    }

    protected String getLabelText() {
        TreeContainerModel model = (TreeContainerModel)this.getModel();
        String text = model.getText();
        return text;
    }

    @Override
    protected void refreshVisuals() {
        boolean isSource;
        TreeContainerModel model = (TreeContainerModel)this.getModel();
        String text = this.getLabelText();
        if (text != null && model.isHeaderVisable() && this.getFigure() instanceof TreeContainerFigure) {
            TreeContainerFigure figure = (TreeContainerFigure)this.getFigure();
            Image i = model.getImage();
            Label tooltip = null;
            int serverity = model.getSeverity();
            String message = this.getSeverityMessage(model);
            if (serverity == -1) {
                i = model.getImage();
            }
            if (serverity == 4) {
                i = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/error_obj.gif");
                tooltip = this.errorLabel;
                tooltip.setText(message);
            }
            if (serverity == 2) {
                i = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/warning_obj.gif");
                tooltip = this.warningLabel;
                tooltip.setText(message);
            }
            if (i != null) {
                figure.setIcon(i);
            }
            figure.setText(text);
            figure.setToolTip((IFigure)tooltip);
        }
        if (!(isSource = this.isSourceLinkNodeEditPart())) {
            IFigure figure = this.getFigure();
            boolean cfr_ignored_0 = figure instanceof TreeContainerFigure;
        }
        Point location = model.getLocation();
        Dimension size = this.getFigure().getPreferredSize();
        try {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(location, size));
            IFigure figure = this.getFigure().getParent();
            figure.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IFigure getContentPane() {
        if (this.getFigure() instanceof TreeContainerFigure) {
            TreeContainerFigure t = (TreeContainerFigure)this.getFigure();
            return t.getContentFigure();
        }
        return this.getFigure();
    }

    @Override
    public TreeContainerEditPart getTreeContainerEditPart() {
        return this;
    }

    @Override
    public boolean isSourceLinkNodeEditPart() {
        Object model = this.getModel();
        if (model != null && model instanceof TreeContainerModel) {
            return ((TreeContainerModel)model).isSourceLinkNode();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("__pro_bounds_changed".equals(evt.getPropertyName())) {
            this.refreshVisuals();
            DefaultEditDomain domain = (DefaultEditDomain)this.getViewer().getEditDomain();
            IEditorPart editor = domain.getEditorPart();
            ISmooksModelProvider modelProvider = (ISmooksModelProvider)editor.getAdapter(ISmooksModelProvider.class);
            if (modelProvider != null) {
                boolean cfr_ignored_0 = this.getModel() instanceof IMoveableModel;
            }
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("NodeEditPolicy", (EditPolicy)new TreeNodeGraphicalNodeEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FigureHighlightEditPolicy());
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        Object model = this.getModel();
        if (model instanceof TreeContainerModel && request instanceof SelectionRequest) {
            Point location = ((SelectionRequest)request).getLocation();
            IFigure figure = this.getFigure();
            IFigure figure1 = figure.findFigureAt(location);
            if (figure1 instanceof DragLinkFigure && ((TreeContainerModel)model).canDragLink()) {
                this.getViewer().select((EditPart)this);
                return new ConnectionDragCreationTool();
            }
        }
        return super.getDragTracker(request);
    }

    @Override
    public List<?> getModelChildren() {
        TreeNodeModel node = (TreeNodeModel)this.getModel();
        return node.getChildren();
    }

    @Override
    public void treeCollapsed(TreeFigureExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeFigureExpansionEvent event) {
    }
}

