/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.smooks.configuration.SmooksConfigurationActivator;
import org.jboss.tools.smooks.gef.tree.editpolicy.TreeNodeConnectionEditPolicy;
import org.jboss.tools.smooks.gef.tree.editpolicy.TreeNodeEndpointEditPolicy;
import org.jboss.tools.smooks.gef.tree.figures.LeftOrRightAnchor;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeConnection;
import org.jboss.tools.smooks.graphical.editors.model.IValidatableModel;

public class TreeNodeConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    protected int alpha = 255;
    protected boolean canDelete = true;
    private Image markerImage = null;
    protected Label errorLabel = new Label();
    protected Label warningLabel = new Label();

    public void activate() {
        super.activate();
        TreeNodeConnection connection = (TreeNodeConnection)this.getModel();
        connection.addPropertyChangeListener(this);
    }

    public void deactivate() {
        TreeNodeConnection connection = (TreeNodeConnection)this.getModel();
        connection.removePropertyChangeListener(this);
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new TreeNodeConnectionEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new TreeNodeEndpointEditPolicy());
    }

    public void changeLineAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Image getMarkerImage() {
        return this.markerImage;
    }

    public void setMarkerImage(Image markerImage) {
        this.markerImage = markerImage;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    protected IEditorPart getEditorPart() {
        GraphicalViewer viewer = (GraphicalViewer)this.getViewer();
        DefaultEditDomain domain = (DefaultEditDomain)viewer.getEditDomain();
        return domain.getEditorPart();
    }

    protected void refreshVisuals() {
        Label tooltip = null;
        this.setMarkerImage(null);
        Object connection = this.getModel();
        if (connection instanceof IValidatableModel) {
            int serverity = ((IValidatableModel)connection).getSeverity();
            String message = this.getSeverityMessage((IValidatableModel)connection);
            Image image = null;
            if (serverity == -1) {
                image = null;
            }
            if (serverity == 4) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/error_obj.gif");
                tooltip = this.errorLabel;
                tooltip.setText(message);
            }
            if (serverity == 2) {
                image = SmooksConfigurationActivator.getDefault().getImageRegistry().get("icons/full/obj16/warning_obj.gif");
                tooltip = this.warningLabel;
                tooltip.setText(message);
            }
            if (image != null) {
                this.setMarkerImage(image);
                this.getFigure().repaint();
            }
            this.getFigure().setToolTip((IFigure)tooltip);
        }
    }

    protected String getSeverityMessage(IValidatableModel model) {
        List<String> messages = model.getMessage();
        String message = null;
        for (String string : messages) {
            message = message == null ? " - " + string : String.valueOf(message) + "\n" + " - " + string;
        }
        return message;
    }

    protected IFigure createSourceFlagFigure() {
        Figure sourceFlagFigure = new Figure(){

            public void paint(Graphics graphics) {
                graphics.pushState();
                ConnectionAnchor sourceAnchor = TreeNodeConnectionEditPart.this.getSourceConnectionAnchor();
                ConnectionAnchor targetAnchor = TreeNodeConnectionEditPart.this.getTargetConnectionAnchor();
                boolean startLeft = false;
                if (sourceAnchor instanceof LeftOrRightAnchor) {
                    ((LeftOrRightAnchor)sourceAnchor).getLocation(targetAnchor.getReferencePoint());
                    startLeft = ((LeftOrRightAnchor)sourceAnchor).isLeft();
                }
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.listBackground);
                if (!startLeft) {
                    Point p = this.getBounds().getTopLeft();
                    Point p2 = this.getBounds().getBottomLeft();
                    Point p3 = this.getBounds().getTopRight();
                    p3 = new Point(p3.x, p3.y + this.getSize().height / 2);
                    PointList pointList = new PointList();
                    pointList.addPoint(p);
                    pointList.addPoint(p2.x, p2.y - 1);
                    pointList.addPoint(p3);
                    graphics.fillPolygon(pointList);
                    graphics.drawPolygon(pointList);
                } else {
                    Point p = this.getBounds().getTopRight();
                    Point p2 = this.getBounds().getBottomRight();
                    Point p3 = this.getBounds().getTopLeft();
                    p3 = new Point(p3.x, p3.y + this.getSize().height / 2);
                    PointList pointList = new PointList();
                    pointList.addPoint(p.x - 1, p.y);
                    pointList.addPoint(p2.x - 1, p2.y - 1);
                    pointList.addPoint(p3);
                    graphics.fillPolygon(pointList);
                    graphics.drawPolygon(pointList);
                }
                graphics.popState();
                super.paint(graphics);
            }
        };
        return sourceFlagFigure;
    }

    protected IFigure createTargetFlagFigure() {
        Figure targetFlagFigure = new Figure(){

            public void paint(Graphics graphics) {
                ConnectionAnchor sourceAnchor = TreeNodeConnectionEditPart.this.getSourceConnectionAnchor();
                ConnectionAnchor targetAnchor = TreeNodeConnectionEditPart.this.getTargetConnectionAnchor();
                boolean targetLeft = false;
                if (targetAnchor instanceof LeftOrRightAnchor) {
                    ((LeftOrRightAnchor)targetAnchor).getLocation(sourceAnchor.getReferencePoint());
                    targetLeft = ((LeftOrRightAnchor)targetAnchor).isLeft();
                }
                graphics.pushState();
                graphics.setBackgroundColor(ColorConstants.button);
                if (targetLeft) {
                    Point p = this.getBounds().getTopLeft();
                    Point p2 = this.getBounds().getBottomLeft();
                    Point p3 = this.getBounds().getTopRight();
                    p3 = new Point(p3.x, p3.y + this.getSize().height / 2);
                    PointList pointList = new PointList();
                    pointList.addPoint(p);
                    pointList.addPoint(p2.x, p2.y - 1);
                    pointList.addPoint(p3);
                    graphics.fillPolygon(pointList);
                    graphics.drawPolygon(pointList);
                } else {
                    Point p = this.getBounds().getTopRight();
                    Point p2 = this.getBounds().getBottomRight();
                    Point p3 = this.getBounds().getTopLeft();
                    p3 = new Point(p3.x, p3.y + this.getSize().height / 2);
                    PointList pointList = new PointList();
                    pointList.addPoint(p.x - 1, p.y);
                    pointList.addPoint(p2.x - 1, p2.y - 1);
                    pointList.addPoint(p3);
                    graphics.fillPolygon(pointList);
                    graphics.drawPolygon(pointList);
                }
                graphics.popState();
            }
        };
        return targetFlagFigure;
    }

    protected void drawLineMarkerImage(Graphics graphics) {
        if (this.getMarkerImage() != null) {
            graphics.drawImage(this.getMarkerImage(), this.getFigure().getBounds().getCenter().getTranslated(-this.getMarkerImage().getBounds().width / 2, -this.getMarkerImage().getBounds().height / 2));
        }
    }

    protected Connection createConnectionFigure() {
        PolylineConnection connection = new PolylineConnection(){

            public void paintFigure(Graphics graphics) {
                graphics.setAlpha(TreeNodeConnectionEditPart.this.alpha);
                graphics.setLineWidth(3);
                super.paintFigure(graphics);
                TreeNodeConnectionEditPart.this.drawLineMarkerImage(graphics);
            }

            public PointList getPoints() {
                PointList list;
                ConnectionAnchor sourceAnchor = TreeNodeConnectionEditPart.this.getSourceConnectionAnchor();
                ConnectionAnchor targetAnchor = TreeNodeConnectionEditPart.this.getTargetConnectionAnchor();
                boolean startLeft = false;
                if (sourceAnchor instanceof LeftOrRightAnchor) {
                    ((LeftOrRightAnchor)sourceAnchor).getLocation(targetAnchor.getReferencePoint());
                    startLeft = ((LeftOrRightAnchor)sourceAnchor).isLeft();
                }
                boolean targetLeft = false;
                if (targetAnchor instanceof LeftOrRightAnchor) {
                    ((LeftOrRightAnchor)targetAnchor).getLocation(sourceAnchor.getReferencePoint());
                    targetLeft = ((LeftOrRightAnchor)targetAnchor).isLeft();
                }
                if ((list = super.getPoints()).size() == 0) {
                    return list;
                }
                Point start = this.getStart();
                int slength = 20;
                int tlength = 20;
                if (startLeft) {
                    slength = -slength;
                }
                if (targetLeft) {
                    tlength = -tlength;
                }
                Point start2 = new Point(start.x + slength, start.y);
                Point end = this.getEnd();
                Point end2 = new Point(end.x + tlength, end.y);
                list.removeAllPoints();
                list.addPoint(start);
                list.addPoint(start2);
                list.addPoint(end2);
                list.addPoint(end);
                return list;
            }
        };
        connection.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        return connection;
    }

    public IFigure createFigure() {
        Connection connection = this.createConnectionFigure();
        IFigure targetFlagFigure = this.createTargetFlagFigure();
        IFigure sourceFlagFigure = this.createSourceFlagFigure();
        targetFlagFigure.setSize(7, 7);
        sourceFlagFigure.setSize(7, 7);
        ConnectionLocator targetLocator = new ConnectionLocator(connection, 3);
        connection.add(targetFlagFigure, (Object)targetLocator);
        ConnectionLocator sourceLocator = new ConnectionLocator(connection, 2);
        connection.add(sourceFlagFigure, (Object)sourceLocator);
        connection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        return connection;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String event = evt.getPropertyName();
        if ("_pro_severity_changed".equals(event)) {
            this.refreshVisuals();
        }
    }
}

