/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.figures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphAnimation {
    private int minsteplegth = 30;
    private int maxstep = 50;
    private Map<GraphicalEditPart, Rectangle> initMap = new HashMap<GraphicalEditPart, Rectangle>();
    private Map<GraphicalEditPart, Rectangle> finalMap = new HashMap<GraphicalEditPart, Rectangle>();

    public void recordInit(GraphicalEditPart editpart) {
        this.initMap.put(editpart, editpart.getFigure().getBounds());
    }

    public void recordFinal(GraphicalEditPart editpart, Rectangle rectangle) {
        this.finalMap.put(editpart, rectangle);
    }

    public void start(List<GraphicalEditPart> figureList) {
        int ystep;
        HashMap<IFigure, Integer> ystepmap = new HashMap<IFigure, Integer>();
        HashMap<IFigure, Integer> xstepmap = new HashMap<IFigure, Integer>();
        for (GraphicalEditPart editPart : figureList) {
            IFigure figure = editPart.getFigure();
            Rectangle rect = this.initMap.get(editPart);
            int initx = rect.x;
            int inity = rect.y;
            Rectangle rect1 = this.finalMap.get(editPart);
            int finalx = rect1.x;
            int finaly = rect1.y;
            int chax = finalx - initx;
            int xstep = this.minsteplegth;
            if (chax < 0) {
                xstep = -xstep;
            }
            Math.abs(chax / this.minsteplegth);
            int chay = finaly - inity;
            ystep = this.minsteplegth;
            if (chay < 0) {
                ystep = -ystep;
            }
            Math.abs(chay / this.minsteplegth);
            ystepmap.put(figure, ystep);
            xstepmap.put(figure, xstep);
        }
        int allfigure = 0;
        ArrayList<GraphicalEditPart> processedParts = new ArrayList<GraphicalEditPart>();
        while (figureList.size() > allfigure) {
            for (GraphicalEditPart editPart : figureList) {
                if (processedParts.contains(editPart)) continue;
                IFigure figure = editPart.getFigure();
                Rectangle rect = figure.getBounds();
                int initx = rect.x;
                int inity = rect.y;
                Rectangle rect1 = this.finalMap.get(editPart);
                int finalx = rect1.x;
                int finaly = rect1.y;
                int xstep = (Integer)xstepmap.get(figure);
                ystep = (Integer)ystepmap.get(figure);
                int x = initx + xstep;
                int y = inity + ystep;
                if (initx != finalx) {
                    initx = Math.abs(x - finalx) <= this.minsteplegth ? finalx : x;
                }
                if (inity != finaly) {
                    inity = Math.abs(y - finaly) <= this.minsteplegth ? finaly : y;
                }
                if (initx == finalx && inity == finaly) {
                    processedParts.add(editPart);
                    ++allfigure;
                }
                Point location = new Point(initx, inity);
                Dimension size = figure.getPreferredSize();
                figure.setLocation(new Point(initx, inity));
                figure.getUpdateManager().performUpdate();
                try {
                    ((GraphicalEditPart)editPart.getParent()).setLayoutConstraint((EditPart)editPart, figure, (Object)new Rectangle(location, size));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(20L);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

