/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.smooks.configuration.editors.GraphicsConstants;
import org.jboss.tools.smooks.gef.tree.editpolicy.IShowHighlighFigure;
import org.jboss.tools.smooks.gef.tree.figures.ISelectableFigure;
import org.jboss.tools.smooks.gef.tree.figures.ITreeFigureListener;
import org.jboss.tools.smooks.gef.tree.figures.TreeContainerFigure;
import org.jboss.tools.smooks.gef.tree.figures.TreeFigureExpansionEvent;
import org.jboss.tools.smooks.gef.tree.model.TreeNodeModel;

public class TreeNodeFigure
extends Figure
implements ISelectableFigure,
IShowHighlighFigure {
    private List<ITreeFigureListener> treeListener = new ArrayList<ITreeFigureListener>();
    private Color oldLabelColor = null;
    protected int SPACE_INT = 14;
    protected int CLICKNODE_HEIGHT = 18;
    protected int CLICKNODE_WIDTH = 18;
    private Figure contentFigure;
    private Figure labelContainer;
    private Figure clickNode;
    private Label label;
    private boolean mouseEnter = false;
    protected boolean expand = false;
    private TreeNodeModel model;
    private boolean focus;
    private boolean selected;
    private Image labelImage = null;
    private boolean showHighlight;

    public TreeNodeFigure(TreeNodeModel model) {
        this.model = model;
        this.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.setLayoutManager((LayoutManager)this.createTreeNodeFigureLayout());
        this.createLabelContainer();
        this.createContentFigure();
        this.initFigure();
    }

    protected ToolbarLayout createTreeNodeFigureLayout() {
        return new ToolbarLayout();
    }

    protected void initFigure() {
    }

    public void addTreeListener(ITreeFigureListener listener) {
        this.treeListener.add(listener);
    }

    public void removeTreeListener(ITreeFigureListener listener) {
        this.treeListener.remove(listener);
    }

    public TreeNodeModel getModel() {
        return this.model;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public void setModel(TreeNodeModel model) {
        this.model = model;
    }

    public Label getLabel() {
        return this.label;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    private void createContentFigure() {
        Figure panelFigure = new Figure();
        ToolbarLayout layout = new ToolbarLayout();
        layout.setVertical(false);
        panelFigure.setLayoutManager((LayoutManager)layout);
        Figure spaceFigure = new Figure(){

            public Dimension getPreferredSize(int hint, int hint2) {
                return new Dimension(TreeNodeFigure.this.SPACE_INT, 0);
            }
        };
        if (this.needSpaceFigure()) {
            panelFigure.add((IFigure)spaceFigure);
        }
        this.contentFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
            }
        };
        panelFigure.add((IFigure)this.contentFigure);
        this.contentFigure.setLayoutManager((LayoutManager)this.createContentFigureLayout());
        this.add((IFigure)panelFigure);
    }

    protected boolean needSpaceFigure() {
        return true;
    }

    public Figure getContentFigure() {
        return this.contentFigure;
    }

    public Dimension getPreferredSize(int hint, int hint2) {
        if (this.expand) {
            return super.getPreferredSize(hint, hint2);
        }
        LayoutManager layout = this.labelContainer.getLayoutManager();
        if (layout != null) {
            layout.invalidate();
        }
        this.labelContainer.invalidateTree();
        try {
            Dimension size = this.labelContainer.getPreferredSize(hint, hint2);
            Insets insets = this.getBorder().getInsets(null);
            return new Dimension(size.width + insets.left + insets.right, size.height + insets.bottom + insets.top);
        }
        catch (Throwable throwable) {
            return new Dimension(100, 100);
        }
    }

    public Figure getClickNode() {
        return this.clickNode;
    }

    protected void createLabelContainer() {
        this.labelContainer = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
            }
        };
        this.clickNode = new Clickable(){

            public void paintBorder(Graphics graphics) {
            }

            public void paintFigure(Graphics graphics) {
                TreeNodeFigure.this.drawClickFigure((IFigure)TreeNodeFigure.this.clickNode, graphics);
            }
        };
        ((Clickable)this.clickNode).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                boolean hasChildren = TreeNodeFigure.this.model.hasChildren();
                if (!hasChildren) {
                    return;
                }
                TreeNodeFigure.this.changeTreeExpansionState();
            }
        });
        ((Clickable)this.clickNode).addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                boolean hasChildren = TreeNodeFigure.this.model.hasChildren();
                if (!hasChildren) {
                    return;
                }
                TreeNodeFigure.this.mouseEnter = true;
                TreeNodeFigure.this.clickNode.repaint();
            }

            public void mouseExited(MouseEvent me) {
                boolean hasChildren = TreeNodeFigure.this.model.hasChildren();
                if (!hasChildren) {
                    return;
                }
                TreeNodeFigure.this.mouseEnter = false;
                TreeNodeFigure.this.clickNode.repaint();
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.clickNode.setSize(new Dimension(this.CLICKNODE_WIDTH, this.CLICKNODE_HEIGHT));
        Figure imageFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                if (TreeNodeFigure.this.labelImage != null) {
                    graphics.drawImage(TreeNodeFigure.this.labelImage, this.getBounds().getTopLeft().x, this.getBounds().getTopLeft().y + 2);
                }
            }
        };
        imageFigure.setSize(new Dimension(18, 18));
        this.label = new Label();
        this.isFocus();
        if (this.model != null) {
            this.label.setText(this.model.getText());
        } else {
            this.label.setText("");
        }
        if (this.needClickFigure()) {
            this.labelContainer.add((IFigure)this.clickNode);
        }
        this.labelContainer.add((IFigure)imageFigure);
        this.labelContainer.add((IFigure)this.label);
        this.labelContainer.setLayoutManager(this.createLabelContainerLayout());
        this.add((IFigure)this.labelContainer);
    }

    protected boolean needClickFigure() {
        return true;
    }

    protected LayoutManager createLabelContainerLayout() {
        ToolbarLayout tl = new ToolbarLayout();
        tl.setVertical(false);
        return tl;
    }

    public void updateLabel() {
        if (this.model != null) {
            this.label.setText(this.model.getText());
        } else {
            this.label.setText("");
        }
    }

    public void setLabelImage(Image labelImage) {
        this.labelImage = labelImage;
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }

    protected ToolbarLayout createContentFigureLayout() {
        ToolbarLayout layout = new ToolbarLayout();
        return layout;
    }

    public void paint(Graphics graphics) {
        if (this.oldLabelColor == null) {
            this.oldLabelColor = this.label.getForegroundColor();
        }
        this.label.setForegroundColor(this.oldLabelColor);
        if (this.isFocus() || this.isSelected() || this.showHighlight) {
            this.label.setForegroundColor(GraphicsConstants.FONT_COLOR);
        }
        super.paint(graphics);
    }

    public void setNodeLabelForegroundColor(Color color) {
        this.oldLabelColor = color;
    }

    protected void drawClickFigure(IFigure clickFigure, Graphics graphics) {
        Rectangle rect = clickFigure.getBounds();
        Point center = rect.getCenter();
        int width = 8;
        PointList pointList = new PointList();
        boolean hasChildren = this.model.hasChildren();
        if (hasChildren) {
            if (this.expand) {
                Point point1 = new Point(center.x - width / 2, center.y - width / 4);
                Point point2 = new Point(point1.x + width, point1.y);
                Point point3 = new Point(point1.x + width / 2, point1.y + width / 2);
                pointList.addPoint(point1);
                pointList.addPoint(point2);
                pointList.addPoint(point3);
            } else {
                Point point1 = new Point(center.x - width / 4, center.y - width / 2);
                Point point2 = new Point(point1.x, point1.y + width);
                Point point3 = new Point(point1.x + width / 2, point1.y + width / 2);
                pointList.addPoint(point1);
                pointList.addPoint(point2);
                pointList.addPoint(point3);
            }
            graphics.drawPolygon(pointList);
        }
        if (this.mouseEnter) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.fillPolygon(pointList);
            graphics.popState();
        }
    }

    public void expandNode() {
        this.expand = false;
        this.changeTreeExpansionState();
    }

    public void collapsedNode() {
        this.expand = true;
        this.changeTreeExpansionState();
    }

    private void changeTreeExpansionState() {
        try {
            IFigure parent = this.contentFigure.getParent();
            while (parent != null) {
                if (parent instanceof TreeContainerFigure) break;
                parent = parent.getParent();
            }
            if (parent != null) {
                Rectangle oldRectangle = parent.getClientArea();
                this.expand = !this.expand;
                for (ITreeFigureListener listener : this.treeListener) {
                    TreeFigureExpansionEvent event = new TreeFigureExpansionEvent(this);
                    if (!this.expand) {
                        listener.treeCollapsed(event);
                        continue;
                    }
                    listener.treeExpanded(event);
                }
                if (!this.expand) {
                    this.contentFigure.setLayoutManager(null);
                    this.contentFigure.setSize(new Dimension(0, 0));
                } else {
                    this.contentFigure.setLayoutManager((LayoutManager)this.createContentFigureLayout());
                    this.contentFigure.setSize(this.contentFigure.getPreferredSize());
                }
                Rectangle newRectangle = parent.getClientArea();
                int w = Math.max(oldRectangle.width, newRectangle.width);
                int h = Math.max(oldRectangle.height, newRectangle.height);
                IFigure panel = parent.getParent();
                if (panel != null) {
                    panel.repaint(oldRectangle.x, oldRectangle.y, w, h);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showHighlightBackgroudColor(Color color) {
        this.showHighlight = true;
        this.repaint();
    }

    public void showbackOldbackgroundColor(Color color) {
        this.showHighlight = false;
        this.repaint();
    }
}

