/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.gef.tree.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.jboss.tools.smooks.gef.model.AbstractSmooksGraphicalModel;
import org.jboss.tools.smooks.graphical.editors.model.IValidatableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodeConnection
implements IValidatableModel {
    protected int severity = 0;
    private Object data;
    private AbstractSmooksGraphicalModel sourceNode;
    private AbstractSmooksGraphicalModel targetNode;
    protected List<String> markerMessages = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public TreeNodeConnection() {
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public TreeNodeConnection(AbstractSmooksGraphicalModel sourceNode, AbstractSmooksGraphicalModel targetNode) {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        Assert.isNotNull((Object)sourceNode);
        Assert.isNotNull((Object)targetNode);
    }

    public void connect() {
        this.connectSource();
        this.connectTarget();
    }

    public void disconnect() {
        this.disconnectSource();
        this.disconnectTarget();
    }

    public void connectSource() {
        this.sourceNode.addSourceConnection(this);
    }

    public void connectTarget() {
        this.targetNode.addTargetConnection(this, this.sourceNode);
    }

    public void disconnectSource() {
        this.sourceNode.removeSourceConnection(this);
    }

    public void disconnectTarget() {
        this.targetNode.removeTargetConnection(this);
    }

    public AbstractSmooksGraphicalModel getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(AbstractSmooksGraphicalModel sourceNode) {
        this.sourceNode = sourceNode;
    }

    public AbstractSmooksGraphicalModel getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(AbstractSmooksGraphicalModel targetNode) {
        this.targetNode = targetNode;
    }

    @Override
    public void addMessage(String message) {
        this.getMessage().add(message);
    }

    @Override
    public List<String> getMessage() {
        if (this.markerMessages == null) {
            this.markerMessages = new ArrayList<String>();
        }
        return this.markerMessages;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void setSeverity(int severity) {
        int old = this.severity;
        if (severity == this.severity) {
            old = -1;
        }
        this.severity = severity;
        this.support.firePropertyChange("_pro_severity_changed", old, this.severity);
    }
}

