/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.actions.AbstractProcessGraphAction;
import org.jboss.tools.smooks.graphical.actions.Messages;
import org.jboss.tools.smooks.graphical.editors.TaskTypeManager;
import org.jboss.tools.smooks.graphical.editors.process.IProcessProvider;
import org.jboss.tools.smooks.graphical.editors.process.ProcessType;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.model.smooks.SmooksPackage;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTaskNodeAction
extends AbstractProcessGraphAction {
    private IProcessProvider processProvider;

    public DeleteTaskNodeAction(IProcessProvider processProvider, ISmooksModelProvider modelProvider, IEditorPart editor) {
        super(Messages.DeleteTaskNodeAction_Action_Delete, modelProvider, editor);
        this.processProvider = processProvider;
    }

    @Override
    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    @Override
    public void update() {
        TaskType task;
        List<TaskType> taskList = this.getCurrentSelectedTask();
        if (!taskList.isEmpty() && taskList.size() == 1 && "input".equals((task = taskList.get(0)).getId())) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(taskList != null && !taskList.isEmpty() && taskList.size() == 1);
    }

    @Override
    public void run() {
        ProcessType process;
        super.run();
        if (this.getProvider() != null && this.processProvider != null && (process = this.processProvider.getProcess()) != null) {
            List<TaskType> currentTasks = this.getCurrentSelectedTask();
            TaskType currentTask = currentTasks.get(0);
            ArrayList<TaskType> allTask = new ArrayList<TaskType>();
            SmooksUIUtils.fillAllTask(currentTask, allTask);
            List<Object> associatedElements = new ArrayList<Object>();
            SmooksResourceListType listType = SmooksUIUtils.getSmooks11ResourceListType(this.provider.getSmooksModel());
            if (listType != null) {
                for (TaskType taskType : allTask) {
                    List<Object> elements = TaskTypeManager.getAssociatedSmooksElements(taskType, listType);
                    if (elements == null || elements.isEmpty()) continue;
                    associatedElements.addAll(elements);
                }
            }
            Command remove = null;
            if (associatedElements.isEmpty()) {
                Object parent = currentTask.getParent();
                if (parent instanceof Process) {
                    ((ProcessType)parent).removeTask(currentTask);
                }
                if (parent instanceof TaskType) {
                    ((TaskType)parent).removeTask(currentTask);
                }
            } else {
                associatedElements = this.getDeletedObjects(associatedElements);
                CompoundCommand ccommand = new CompoundCommand();
                remove = RemoveCommand.create((EditingDomain)this.provider.getEditingDomain(), (Object)listType, (Object)SmooksPackage.Literals.SMOOKS_RESOURCE_LIST_TYPE__ABSTRACT_RESOURCE_CONFIG_GROUP, associatedElements);
                if (remove.canExecute()) {
                    ccommand.append(remove);
                    Object parent = currentTask.getParent();
                    if (parent instanceof Process) {
                        ((ProcessType)parent).removeTask(currentTask);
                    }
                    if (parent instanceof TaskType) {
                        ((TaskType)parent).removeTask(currentTask);
                    }
                }
                this.provider.getEditingDomain().getCommandStack().execute((Command)ccommand);
            }
        }
    }

    private List<Object> getDeletedObjects(List<Object> deletingObjects) {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (Object object : deletingObjects) {
            EStructuralFeature feature = SmooksUIUtils.getFeature(object);
            if (feature != null) {
                object = FeatureMapUtil.createEntry((EStructuralFeature)feature, (Object)object);
            }
            objs.add(object);
        }
        return objs;
    }
}

