/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.editor.ISmooksModelProvider;
import org.jboss.tools.smooks.graphical.editors.GraphicalModelFactory;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.javabean12.ExpressionType;
import org.jboss.tools.smooks.model.javabean12.ValueType;
import org.jboss.tools.smooks.model.javabean12.WiringType;
import org.jboss.tools.smooks.model.rules10.RuleBase;
import org.jboss.tools.smooks.model.rules10.RuleBasesType;
import org.jboss.tools.smooks.model.validation10.RuleType;

public class GraphicalModelFactoryImpl
implements GraphicalModelFactory {
    protected ILabelProvider createLabelProvider(AdapterFactory factory) {
        return new AdapterFactoryLabelProvider(factory){

            public String getText(Object object) {
                String label = GraphicalModelFactoryImpl.this.getGraphLabelText(object);
                if (label == null) {
                    return super.getText(object);
                }
                return label;
            }
        };
    }

    protected String getGraphLabelText(Object element) {
        Object obj = AdapterFactoryEditingDomain.unwrap((Object)element);
        if (obj instanceof BeanType) {
            String p = ((BeanType)obj).getBeanId();
            if (p == null) {
                p = "<NULL>";
            }
            return p;
        }
        if (obj instanceof ValueType) {
            String p = ((ValueType)obj).getProperty();
            if (p == null) {
                p = "<NULL>";
            }
            return p;
        }
        if (obj instanceof WiringType) {
            String p = ((WiringType)obj).getProperty();
            if (p == null) {
                p = "<NULL>";
            }
            return p;
        }
        if (obj instanceof ExpressionType) {
            String p = ((ExpressionType)obj).getProperty();
            if (p == null) {
                p = "<NULL>";
            }
            return p;
        }
        return null;
    }

    protected boolean canCreateGraphicalModel(Object model, ISmooksModelProvider provider) {
        String version = provider.getPlatformVersion();
        return !SmooksUIUtils.isUnSupportElement(version, (EObject)model);
    }

    public Object createGraphicalModel(Object model, ISmooksModelProvider provider) {
        Object graphModel = null;
        String version = provider.getPlatformVersion();
        if (model instanceof RuleType || model instanceof RuleBase || model instanceof RuleBasesType) {
            return null;
        }
        if (SmooksUIUtils.isUnSupportElement(version, (EObject)model)) {
            return null;
        }
        return graphModel;
    }
}

