/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.smooks.graphical.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.jboss.tools.smooks.configuration.editors.uitls.SmooksUIUtils;
import org.jboss.tools.smooks.graphical.editors.TaskTypeManager;
import org.jboss.tools.smooks.graphical.editors.process.ProcessFactory;
import org.jboss.tools.smooks.graphical.editors.process.ProcessType;
import org.jboss.tools.smooks.graphical.editors.process.TaskType;
import org.jboss.tools.smooks.model.freemarker.Freemarker;
import org.jboss.tools.smooks.model.javabean12.BeanType;
import org.jboss.tools.smooks.model.smooks.AbstractResourceConfig;
import org.jboss.tools.smooks.model.smooks.ParamType;
import org.jboss.tools.smooks.model.smooks.SmooksFactory;
import org.jboss.tools.smooks.model.smooks.SmooksResourceListType;
import org.jboss.tools.smooks.model.xsl.Xsl;
import org.jboss.tools.smooks10.model.smooks.util.SmooksModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAnalyzer {
    protected IEditingDomainProvider domainProvider;

    public ProcessAnalyzer(IEditingDomainProvider domainProvider) {
        this.domainProvider = domainProvider;
        Assert.isNotNull((Object)this.domainProvider);
    }

    public List<TaskType> analyzeTaskID(SmooksResourceListType resourceList) {
        ArrayList<String> taskIDs = new ArrayList<String>();
        ArrayList<TaskType> tasks = new ArrayList<TaskType>();
        EList resourceConfigList = resourceList.getAbstractResourceConfig();
        for (AbstractResourceConfig abstractResourceConfig : resourceConfigList) {
            TaskType task;
            if (abstractResourceConfig instanceof BeanType) {
                if (taskIDs.contains("java_mapping")) continue;
                taskIDs.add("java_mapping");
                task = ProcessFactory.eINSTANCE.createTaskType();
                task.setId("java_mapping");
                task.setName(TaskTypeManager.getTaskLabel(task));
                tasks.add(task);
            }
            if (abstractResourceConfig instanceof Freemarker) {
                ParamType idParam;
                task = ProcessFactory.eINSTANCE.createTaskType();
                task.setId("freemarker_csv_template");
                task.setName(TaskTypeManager.getTaskLabel(task));
                tasks.add(task);
                String refid = SmooksModelUtils.getParamValue((List)((Freemarker)abstractResourceConfig).getParam(), (String)"id");
                if (refid == null) {
                    refid = SmooksModelUtils.generateTaskID((SmooksResourceListType)resourceList, Freemarker.class, (String)"freemarker");
                    idParam = SmooksFactory.eINSTANCE.createParamType();
                    idParam.setName("id");
                    idParam.setStringValue(refid);
                    ((Freemarker)abstractResourceConfig).getParam().add((Object)idParam);
                }
                if (refid != null) {
                    idParam = SmooksFactory.eINSTANCE.createParamType();
                    idParam.setName("idref");
                    idParam.setStringValue(refid);
                }
                taskIDs.add("freemarker_csv_template");
            }
            boolean cfr_ignored_0 = abstractResourceConfig instanceof Xsl;
        }
        return tasks;
    }

    private void fillAllTask(TaskType task, List<TaskType> taskList) {
        SmooksUIUtils.fillAllTask(task, taskList);
    }

    public boolean analyzeSmooksModels(ProcessType process, SmooksResourceListType resourceList) {
        boolean modelWasChanged = false;
        List<TaskType> currentList = process.getTask();
        ArrayList<TaskType> taskList = new ArrayList<TaskType>();
        for (TaskType taskType : currentList) {
            this.fillAllTask(taskType, taskList);
        }
        if (taskList.isEmpty()) {
            modelWasChanged = true;
        }
        List<TaskType> tasks = this.analyzeTaskID(resourceList);
        for (TaskType taskType : tasks) {
            if (!this.canAdd(taskList, taskType)) continue;
            taskList.add(taskType);
        }
        new ArrayList();
        return modelWasChanged;
    }

    public boolean analyzeSmooksModels(SmooksResourceListType resourceList) {
        boolean modelWasChanged = false;
        return modelWasChanged;
    }

    public static void main(String[] args) {
    }

    private boolean canAdd(List<TaskType> list, TaskType taskType) {
        if ("java_mapping".equals(taskType.getId())) {
            for (TaskType taskType1 : list) {
                if (!"java_mapping".equals(taskType1.getId())) continue;
                return false;
            }
        }
        return true;
    }

    private List<TaskType> getTaskTypes(String id, List<TaskType> taskList) {
        ArrayList<TaskType> tasks = new ArrayList<TaskType>();
        for (TaskType taskType : taskList) {
            if (!id.equals(taskType.getId())) continue;
            tasks.add(taskType);
        }
        return tasks;
    }

    private TaskType getTaskType(String id, List<TaskType> taskList) {
        for (TaskType taskType : taskList) {
            if (!id.equals(taskType.getId())) continue;
            return taskType;
        }
        return null;
    }

    private boolean linkTask(List<TaskType> taskList, List<TaskType> dummyTasks, CompoundCommand compoundCommand) {
        TaskType first = this.getTaskType("input", taskList);
        if (first != null) {
            taskList.remove(first);
            return this.linkTask(first, taskList, dummyTasks, compoundCommand);
        }
        return false;
    }

    private boolean linkTask(TaskType taskType, List<TaskType> taskList, List<TaskType> dummyTasks, CompoundCommand compoundCommand) {
        String id = taskType.getId();
        TaskTypeManager.getChildTaskIDs(id);
        boolean changed = false;
        return changed;
    }
}

